/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pickselectoraction.h"

#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QDebug>

PickSelectorAction::PickSelectorAction(QObject *parent)
    : QWidgetAction(parent)
    , m_selectedIndex(0)
{
    m_pModel = NULL;
}

PickSelectorAction::~PickSelectorAction() {
    if ( m_pModel ) { delete m_pModel; m_pModel = NULL; }
}

/*! Create the WidgetAction widget
    Just remember that every time the menu is opened we need to create a new widget.
*/
QWidget* PickSelectorAction::createWidget(QWidget *parent) {
    if ( m_pModel ) {  delete m_pModel; m_pModel = NULL; }
    m_pModel = new QStringListModel(this);
    m_pModel->setStringList(m_items);

    QMaemo5ListPickSelector *selector = new QMaemo5ListPickSelector(parent);
    selector->setModel(m_pModel);
    selector->setCurrentIndex(m_selectedIndex);

    QMaemo5ValueButton *valueButton = new QMaemo5ValueButton(text(), parent);
    // Maemo5 style guide wants the menu entries centered.
    valueButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    valueButton->setPickSelector(selector);

    connect(selector, SIGNAL(selected(const QString &)), this, SLOT(optionSelected(const QString &)));

    return valueButton;
}

void PickSelectorAction::optionSelected(const QString& str) {
    int index = -1;
    for ( int c=0; c<m_items.size(); c++ ){
        if ( m_items.at(c) == str ) {
            index =c;
            break;
        }
    }

    if (index<0){
        qDebug() << "Not find item...how?";
        return;
    }

    qDebug() << "Item Selected: " << str << ", index=" << QString::number(index);
    m_selectedIndex = index;
    selectionChanged(m_selectedIndex);
}

QStringList& PickSelectorAction::items() {
    return m_items;
}

void PickSelectorAction::setSelectedIndex(int index) {
    if (index<0 || index>=m_items.size() ) return;
    m_selectedIndex = index;

}

int PickSelectorAction::selectedIndex() {
    return m_selectedIndex;
}
