/*
 * This file is part of MSA program
 *
 * Copyright (C) 2010 - Ivan Galov
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "mywidget.h"

#include "qmaemo5homescreenadaptor.h"
#include <QtGui>
#include <QDebug>

int main(int argc, char *argv[])
{
    // enforce native graphics system for now due to a bug in Maemo's composition
    // manager
    
    qDebug() << "Connected!\n";
    
    QApplication::setGraphicsSystem("native");
    QApplication app(argc, argv);

	/* create widget object */
    MyWidget w;
    
    /* create adaptor for displaying widget */
	QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
	adaptor->setSettingsAvailable(true);

/*
	QObject::connect(&s, SIGNAL(indication()),&w, SLOT(indication()));
	QObject::connect(&s, SIGNAL(updateCity(QString)),&w, SLOT(updateCity(QString)));
	QObject::connect(&s, SIGNAL(updateTemp(QString)),&w, SLOT(updateTemp(QString)));
	QObject::connect(&s, SIGNAL(updateIcon(QString)),&w, SLOT(updateIcon(QString)));
	QObject::connect(&s, SIGNAL(updateCaption(QString)),&w, SLOT(updateCaption(QString)));
	QObject::connect(&s, SIGNAL(startGPS()),&w, SLOT(startGPS()));
*/
	QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));
    
	/* show widget */
    w.show();

	//s.start();
    app.exec();

	//w.stopGPS();
	//s.terminate();
}

