#include <QDebug>

#include "interface.h"
#include "driver_config.h"
#include "config.h"


void init(MysocialsDrv* drv) {
    qDebug()<<"init MysocialsDrv";
    QString id;

    if(drv->id == NULL)
        drv->id = DRIVER_ID;

    Profile* pr = new Profile(drv->id);

    pr->addToList();

    drv->name = DRIVER_NAME;
    drv->driverName = DRIVER_ID;
    drv->send = NULL;
    drv->shutdown = NULL;
    drv->pic = DRIVER_PIC;

    qDebug()<<"driver "<<DRIVER_NAME<<" init END";

return;
}
void send(QDomDocument* request, MysocialsDrv* drv){

    Driver *driver = new Driver();
    Request *req = new Request(request);
    driver->setRequest(req, drv);
    QObject::connect(driver,SIGNAL(requestProcessed(QDomDocument*)),drv,SLOT(emitGotResponse(QDomDocument*)));
    driver->executeRequest();

}

void test(MysocialsDrv* drv) {
    qDebug()<<"test start";
    qDebug()<<"test end";



}

