<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>


<xsl:template match="response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="profile/item/uid"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">FirstName</xsl:attribute>
                <xsl:value-of select="profile/item/first_name"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="profile/item/last_name"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">NickName</xsl:attribute>
                <xsl:value-of select="profile/item/nickname"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Gender</xsl:attribute>
                <xsl:if test="number(profile/item/sex) = 1">
                <xsl:text>female</xsl:text>
                </xsl:if>
                <xsl:if test="number(profile/item/sex) = 2">
                <xsl:text>male</xsl:text>
                </xsl:if>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Birthday</xsl:attribute>
                <xsl:value-of select="profile/item/bdate"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">MobilePhone</xsl:attribute>
                <xsl:value-of select="profile/item/mobile_phone"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">HomePhone</xsl:attribute>
                <xsl:value-of select="profile/item/home_phone"/>
            </xsl:element>

            <xsl:element name="{$IMG}">
                <xsl:attribute name="name">Img</xsl:attribute>
                <xsl:value-of select="profile/item/photo_big"/>
            </xsl:element>

            <xsl:if test="profile/item/city">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">CityName</xsl:attribute>
                    <xsl:value-of select="city/item"/>
                </xsl:element>
            </xsl:if>

            <xsl:if test="profile/item/country">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">CountryName</xsl:attribute>
                    <xsl:value-of select="country/item"/>
                </xsl:element>
            </xsl:if>

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
