<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListPhotoComments</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(comments/item)"/>

                <xsl:attribute name="name">commentsList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                    <xsl:if test="number($quantity) > 0">
                        <xsl:value-of select="number($quantity) - 1"/>
                    </xsl:if>
                    <xsl:if test="number($quantity) = 0">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                </xsl:attribute>


                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="owner_id"/>
                </xsl:attribute>

		<xsl:if test="/data/Request/Params/string[@name='albumId']">
            	    <xsl:attribute name="albumId">
                	<xsl:value-of select="/data/Request/Params/string[@name='albumId']"/>
            	    </xsl:attribute>
                </xsl:if>

                <xsl:attribute name="photoId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="photo_id"/>
                </xsl:attribute>

                <xsl:for-each select="comments/item">
                    <xsl:if test="cid">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">comment</xsl:attribute>
                            <xsl:attribute name="id">
                                <xsl:text>vk</xsl:text>
                            <xsl:value-of select="cid"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">SenderId</xsl:attribute>
                                <xsl:text>vk</xsl:text>
                               <xsl:value-of select="from_id"/>
                            </xsl:element>

                            <xsl:if test="from_id">
                                <xsl:if test="from_id != '0'">
                                    <xsl:variable name="current_uid" select="from_id"/>
                                    <xsl:element name="{$STRING}">
                                       <xsl:attribute name="name">SenderName</xsl:attribute>
                                            <xsl:value-of select="//sender/item[uid=$current_uid]/first_name"/>
                                            <xsl:text> </xsl:text>
                                            <xsl:value-of select="//sender/item[uid=$current_uid]/last_name"/>
                                    </xsl:element>
                                </xsl:if>
                            </xsl:if>


                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="date"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:value-of select="message"/>
                            </xsl:element>

                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>

            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
