<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">
<xsl:choose>
<xsl:when test="albums/item and owner_id">

    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getAlbumsWithIcons</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                    <xsl:value-of select="//owner_id"/>
            </xsl:attribute>
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">albums</xsl:attribute>
                    <xsl:copy-of select="/data/response/albums"/>
                </xsl:element>
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">icons</xsl:attribute>
                        <xsl:for-each select="albums/item">
                            <xsl:if test="thumb_id and thumb_id != '0'">                        
		                          <xsl:value-of select="/data/response/owner_id"/>
		                          <xsl:text>_</xsl:text>
		                          <xsl:value-of select="thumb_id"/>
		                          <xsl:if test="not(position()=last())">
		                              <xsl:text>,</xsl:text>
		                          </xsl:if>
	                          </xsl:if>
                        </xsl:for-each> 
                </xsl:element>

        </xsl:element>
    </xsl:element>
</xsl:when>
<xsl:otherwise>

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="0"/>
                </xsl:attribute>                                
                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/data/response/owner_id"/>
                </xsl:attribute>                                

            </xsl:element>
        </xsl:element>
    </xsl:element>

</xsl:otherwise>

</xsl:choose>
</xsl:template>

</xsl:stylesheet>
