#include "request.h"


//Request::Request(QObject *parent) :
//    QObject(parent)
//{
//}

Request::Request(QDomDocument* req)
{
    request = req->cloneNode(true).toDocument();
    connect(this,SIGNAL(errorOccured(Error)),this,SLOT(setError(Error)));
}

Request::~Request()
{
}

QDomDocument Request::applyParser(QDomDocument in, QString parser)
{
    QString req;
    QString out;
    QDomDocument ret;

    req = in.toString(1);

    QXmlQuery query(QXmlQuery::XSLT20);
    query.setFocus(req);
    query.bindVariable("MID", QXmlItem("mid"));
    query.bindVariable("SID", QXmlItem("sid"));
    query.bindVariable("SECRET", QXmlItem("secret"));
    query.setQuery(QUrl(parser));
    if(!query.evaluateTo(&out)){
        emit errorOccured(applyParserError);
    } else {
        ret.setContent(out,1,NULL,NULL,NULL);
    }
    return ret;
}

void Request::setProxy(QString proxy, int port)
{
    this->proxy = proxy;
    this->port = port;
}

void Request::setProfile(Profile* profile)
{
    this->profile = profile;
}

bool Request::processRequest()
{
    QString parser;
    qDebug()<<"START processRequest";

    if (this->request.documentElement().tagName().compare("Request") != 0){
        emit errorOccured(checkRequestError);
        return false;
    }

    /* use standart parser */
    parser = "parser.xsl";

    /* create inner request */
    this->innerRequest = this->applyParser(this->request, parser);
    if(this->innerRequest.isNull())
        return false;

    qDebug()<<"Apply parser... \n"<<innerRequest.toString(1)<<"\n";

    /* unknown request */
    if (this->innerRequest.documentElement().tagName().compare("InnerRequest") != 0){
        this->response = this->innerRequest.cloneNode(true).toDocument();
        qDebug()<<"No tag InnerRequest";
        return true;
    }

     //set request type
     this->type = this->innerRequest.documentElement().
             attribute("type").trimmed();

     //set request parser
     this->parser = this->innerRequest.documentElement().
             elementsByTagName("parser").at(0).toElement().text().trimmed();

     //set request parser type
     this->parserType = this->innerRequest.documentElement().
              elementsByTagName("parser").at(0).toElement().attribute("type").trimmed();


        if (this->type.compare("upload") == 0
            || this->type.compare("get") ==0
            || this->type.compare("post") ==0
            || this->type.compare("download") ==0
            || this->type.compare("webauth") == 0
            || this->type.compare("webcaptcha") == 0) {

            this->url = this->innerRequest. elementsByTagName("InnerRequest").at(0).toElement().
                    elementsByTagName("url").at(0).toElement().text().trimmed();

            if (this->url.isEmpty()) {
                emit errorOccured(makeUrlError);
                qDebug()<<"url=NULL";
                return false;
            }

            QDomElement paramsNode = this->innerRequest.documentElement().
                    elementsByTagName("params").at(0).toElement();

            if (!paramsNode.isNull()){
                QString params = paramsNode.text().trimmed();
                //encoded_params = g_uri_escape_string(params, NOT_ESCAPE, 0);
                this->url += params;
            }

            qDebug()<<"url = "<<this->url;

            this->processUrl();
        }
}

void Request::processUrl()
{

}


void Request::parseResponse(QByteArray data)
{
    Parser p;
    // Parse server response
    if (!this->parserType.isEmpty()){

        if (this->parserType.compare(PARSER_JSON) == 0) {
            //json_parser(inner_req, pr, data, 0, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_SETTINGS) == 0) {
            //settings_parser(inner_req, pr, data, 0, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_EMPTY) == 0) {
            //empty_parser(inner_req, pr, data, 0, &resp_str);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_DOWNLOAD) == 0) {
            //download_parser(inner_req, pr, data, data_size, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_TEXT) == 0) {
            //text_parser(inner_req, pr, data, 0, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_WEBAUTH) == 0) {
            this->profile->update();
            data = p.parse_webauth(data);

            //webauth_parser(inner_req, pr, data, 0, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        } else if (this->parserType.compare(PARSER_WEBCAPTCHA) == 0) {
            //webcaptcha_parser(inner_req, pr, data, 0, &resp_str);
            //g_free(data);
            //data = g_strdup(resp_str);
            //g_free(resp_str);
        }
    }
        QDomDocument resp;
        QDomElement innerReq;
        QDomDocument newResp;

        resp.setContent(data,1,NULL,NULL,NULL);

        if (!resp.isNull()){

            QDomDocument doc;
            QDomElement root = doc.createElement("data");
            doc.appendChild(root);

            root.appendChild(doc.importNode(this->request.documentElement(), true));
            root.appendChild(doc.importNode(resp.documentElement(), true));

            qDebug()<<"Response = "<<doc.toString(1);
            newResp = applyParser(doc, this->parser);
            qDebug()<<"apply parser "<<this->parser;
            if(!this->response.isNull() && this->response.elementsByTagName("Request").count() > 0){
                innerReq = this->response.elementsByTagName("Request").at(0).toElement();
                QDomElement tmp = newResp.documentElement().cloneNode(true).toElement();
                innerReq.parentNode().replaceChild(tmp,innerReq);

            } else
                this->response = newResp;


            if(this->response.isNull())
                return;
            qDebug()<<"parsed Response = "<<this->response.toString(1);


        // Search for requests
            this->processInnerRequest();
        }
}

void Request::processInnerRequest()
{
    qDebug()<<"processInnerRequest";
    QDomElement innerReq;
    if(this->response.elementsByTagName("Request").count() > 0){
        qDebug()<<"found Request";
        innerReq = this->response.elementsByTagName("Request").at(0).toElement();
        QDomDocument doc;
        doc.appendChild(doc.importNode(innerReq, true));
        this->request = doc;
    } else {
        this->request.clear();
        qDebug()<<"No inner Request";
    }
    emit gotResponse();
}

void Request::setError(Error err)
{
    qDebug()<<"Error occured, code = "<<err;
}
