<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">audio</xsl:attribute>
        <xsl:attribute name="function">getListVideo</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">videoList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(video)"/>
                </xsl:attribute>                             
                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="video/owner_id"/>
                </xsl:attribute>                             
   
                <xsl:for-each select="video">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">video</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>vk</xsl:text>
                        <xsl:value-of select="vid"/>
                        </xsl:attribute>
                 
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">title</xsl:attribute>
                           <xsl:value-of select="title"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="description"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">duration</xsl:attribute>
                            <xsl:value-of select="duration"/>
                        </xsl:element>

                        <xsl:element name="{$IMG}">
                            <xsl:attribute name="name">Img</xsl:attribute>
                            <xsl:value-of select="image"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">link</xsl:attribute>
                            <xsl:text>http://vkontakte.ru/</xsl:text>
                            <xsl:value-of select="link"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">url</xsl:attribute>
                            <xsl:value-of select="player"/>
                        </xsl:element>

                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
