<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">settings</xsl:attribute>
                <xsl:attribute name="function">getSettings</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">mid</xsl:attribute>
                        <xsl:if test="$MID != '(null)'">
                            <xsl:value-of select="$MID"/>
                        </xsl:if>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">sid</xsl:attribute>
                        <xsl:if test="$SID != '(null)'">
                            <xsl:value-of select="$SID"/>
                        </xsl:if>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">secret</xsl:attribute>
                        <xsl:if test="$SECRET != '(null)'">
                            <xsl:value-of select="$SECRET"/>
                        </xsl:if>
                    </xsl:element> 
                </xsl:element>
                </xsl:element>                    
</xsl:template>
</xsl:stylesheet>


