<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>
<xsl:include href="attachment.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getListOutboxMessages</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(messages/item)"/>

                <xsl:attribute name="name">messageList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                    <xsl:if test="number($quantity) > 0">
                        <xsl:value-of select="number($quantity) - 1"/>
                    </xsl:if>
                    <xsl:if test="number($quantity) = 0">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                </xsl:attribute>

                <xsl:for-each select="messages/item">
                    <xsl:if test="mid">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">message</xsl:attribute>
                            <xsl:attribute name="id">
                                <xsl:text>vk</xsl:text>
                            <xsl:value-of select="mid"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">SenderId</xsl:attribute>
                                <xsl:text>vk</xsl:text>
                               <xsl:value-of select="$MID"/>
                            </xsl:element>

                            <xsl:if test="uid">
                                <xsl:if test="uid != '0'">
                                    <xsl:variable name="current_uid" select="uid"/>
                                    <xsl:element name="{$ARRAY}">
                                        <xsl:attribute name="name">recipientList</xsl:attribute>
                                        <xsl:attribute name="quantity">1</xsl:attribute>
                                        <xsl:element name="{$STRUCT}">
                                        <xsl:attribute name="name">recipient</xsl:attribute>
                                        <xsl:element name="{$STRING}">
                                           <xsl:attribute name="name">RecipientId</xsl:attribute>
                                            <xsl:text>vk</xsl:text>
                                           <xsl:value-of select="uid"/>
                                        </xsl:element>
                                        <xsl:element name="{$STRING}">
                                           <xsl:attribute name="name">RecipientName</xsl:attribute>
                                                <xsl:value-of select="//recipient/item[uid=$current_uid]/first_name"/>
                                                <xsl:text> </xsl:text>
                                                <xsl:value-of select="//recipient/item[uid=$current_uid]/last_name"/>
                                        </xsl:element>
                                        </xsl:element>
                                    </xsl:element>
                                </xsl:if>
                            </xsl:if>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="date"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Title</xsl:attribute>
                                <xsl:value-of select="title"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:value-of select="body"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Status</xsl:attribute>
                                <xsl:value-of select="read_state"/>
                            </xsl:element>

                            <xsl:apply-templates select="attachment"/>

                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
