<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:variable name="ERROR_CODE" select="/data/error/error_code"/>  

<xsl:template match="/data">
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="/data/error">
    <xsl:choose>
        <xsl:when test="error_code = '14'">
            <xsl:element name="{'Request'}">
                <xsl:attribute name="class">system</xsl:attribute>
                <xsl:attribute name="function">getCaptcha</xsl:attribute>
                <xsl:element name="{'Params'}">
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">sid</xsl:attribute>
                        <xsl:value-of select="captcha_sid"/>
                    </xsl:element>
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">url</xsl:attribute>
                        <xsl:value-of select="captcha_img"/>
                    </xsl:element>
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">class</xsl:attribute>
                        <xsl:value-of select="/data/Request/@class"/>
                    </xsl:element>
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">function</xsl:attribute>
                        <xsl:value-of select="/data/Request/@function"/>
                    </xsl:element>
                    <xsl:copy-of select="/data/Request/Params"/>
                </xsl:element> 
            </xsl:element>
        </xsl:when>
        <xsl:otherwise>
            <xsl:element name="{'Response'}">
                <xsl:attribute name="class">systemMessages</xsl:attribute>
                    <xsl:attribute name="function">errorMessage</xsl:attribute>
                <xsl:element name="{'Params'}">
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">moduleName</xsl:attribute>
                        <xsl:text>vkontakte</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:if test="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]">
                            <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/code"/>
                        </xsl:if>
                    </xsl:element> 
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/message"/>
                    </xsl:element> 
                    <xsl:element name="{'string'}">
                        <xsl:attribute name="name">comment</xsl:attribute>
                        <xsl:value-of select="error_msg"/>
                    </xsl:element> 
                </xsl:element>
                </xsl:element>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="/data/info">
    <xsl:element name="{'Response'}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
            <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{'Params'}">
        </xsl:element>
        </xsl:element>
</xsl:template>

</xsl:stylesheet>
