#ifndef REQUEST_H
#define REQUEST_H

#include <QObject>
#include <QXmlQuery>
#include <QDomDocument>
#include <QDomElement>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QDebug>
#include <QScriptEngine>

#include "profile.h"
#include "config.h"
#include "parser.h"


#define PARSER_JSON "json"
#define PARSER_SETTINGS "settings"
#define PARSER_EMPTY "empty"
#define PARSER_DOWNLOAD "download"
#define PARSER_TEXT "text"
#define PARSER_WEBAUTH "webauth"
#define PARSER_WEBCAPTCHA "webcaptcha"



class Request : public QObject
{
    Q_OBJECT
public:
    //explicit Request(QObject *parent = 0);

    enum Error{
        applyParserError,
        checkRequestError,
        makeUrlError,
        networkError,
        serverError
    };

    Request(QDomDocument* req);
    ~Request();

    bool processRequest();

    void setProxy(QString proxy, int port);

    void setProfile(Profile* profile);

    QDomDocument applyParser(QDomDocument in, QString parser);

    void processUrl();

    void processInnerRequest();

    QDomDocument request;
    QDomDocument innerRequest;
    QDomDocument response;
    QString type;
    QString parser;
    QString parserType;
    QString url;
    QString proxy;
    int port;
    Profile* profile;
    Request* nextRequest;

signals:
    void errorOccured(Error err);
    void gotResponse();
public slots:
    void parseResponse(QByteArray data);
    void setError(Error err);
};

#endif // REQUEST_H
