<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:template match="attachment">
    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">attachment</xsl:attribute>

      <xsl:choose>
        <xsl:when test="type = 'photo'">
            <xsl:attribute name="type">
                <xsl:text>image</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="photo/pid"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="photo/owner_id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlSmall</xsl:attribute>
                <xsl:value-of select="photo/src"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlBig</xsl:attribute>
                <xsl:value-of select="photo/src_big"/>
            </xsl:element>
            <xsl:if test="photo/aid">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">albumId</xsl:attribute>
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="photo/aid"/>
                </xsl:element>
            </xsl:if>
        </xsl:when>
        <xsl:when test="type = 'graffiti'">
            <xsl:attribute name="type">
                <xsl:text>image</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="graffiti/gid"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="graffiti/owner_id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlSmall</xsl:attribute>
                <xsl:value-of select="graffiti/src"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlBig</xsl:attribute>
                <xsl:value-of select="graffiti/src_big"/>
            </xsl:element>
        </xsl:when>

        <xsl:when test="type = 'app'">
            <xsl:attribute name="type">
                <xsl:text>image</xsl:text>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlSmall</xsl:attribute>
                <xsl:value-of select="app/src"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlBig</xsl:attribute>
                <xsl:value-of select="app/src_big"/>
            </xsl:element>
        </xsl:when>

        <xsl:when test="type = 'video'">
            <xsl:attribute name="type">
                <xsl:text>video</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
            <xsl:value-of select="video/vid"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>vk</xsl:text>
            <xsl:value-of select="video/owner_id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:value-of select="video/title"/>
            </xsl:element>
            <xsl:element name="{$NUMBER}">
                <xsl:attribute name="name">duration</xsl:attribute>
                <xsl:value-of select="video/duration"/>
            </xsl:element>
        </xsl:when>

        <xsl:when test="type = 'audio'">
            <xsl:attribute name="type">
                <xsl:text>audio</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
            <xsl:value-of select="audio/aid"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>vk</xsl:text>
            <xsl:value-of select="audio/owner_id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:value-of select="audio/title"/>
            </xsl:element>
            <xsl:element name="{$NUMBER}">
                <xsl:attribute name="name">duration</xsl:attribute>
                <xsl:value-of select="audio/duration"/>
            </xsl:element>
        </xsl:when>

        <xsl:when test="type = 'link'">
            <xsl:attribute name="type">
                <xsl:text>link</xsl:text>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:value-of select="link/title"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">description</xsl:attribute>
                <xsl:value-of select="link/description"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">url</xsl:attribute>
                <xsl:value-of select="link/url"/>
            </xsl:element>
            <xsl:if test="link/image_src">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">urlImage</xsl:attribute>
                    <xsl:value-of select="link/image_src"/>
                </xsl:element>
            </xsl:if>
        </xsl:when>

        <xsl:when test="type = 'note'">
            <xsl:attribute name="type">
                <xsl:text>note</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="note/nid"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="note/owner_id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:value-of select="note/title"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">url</xsl:attribute>
                <xsl:value-of select="note/url"/>
                <xsl:text>http://vkontakte.ru/note</xsl:text>
                <xsl:value-of select="note/owner_id"/>
                <xsl:text>_</xsl:text>
                <xsl:value-of select="note/nid"/>
            </xsl:element>

        </xsl:when>

        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
