<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">friends</xsl:attribute>
        <xsl:attribute name="function">getListFriends</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:if test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/>
                </xsl:if>
                <xsl:if test="not(/data/Request/Params/@id)">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="$MID"/>
                </xsl:if>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(friends/item)"/>

                <xsl:attribute name="name">ContactList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                        <xsl:value-of select="number($quantity)"/>
                </xsl:attribute>


                <xsl:for-each select="friends/*">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">Contact</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>vk</xsl:text>
                        <xsl:value-of select="uid"/>
                        </xsl:attribute>
                 
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">FirstName</xsl:attribute>
                           <xsl:value-of select="first_name"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">LastName</xsl:attribute>
                            <xsl:value-of select="last_name"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">FriendStatus</xsl:attribute>
                            <xsl:value-of select="online"/>
                        </xsl:element>

                        <xsl:element name="{$IMG}">
                            <xsl:attribute name="name">Img</xsl:attribute>
                            <xsl:value-of select="photo_medium"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>

            </xsl:element> 
        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
