<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">
    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">savePhoto</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">server</xsl:attribute>
                <xsl:value-of select="server"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">photos_list</xsl:attribute>
                <xsl:value-of select="photos_list"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">aid</xsl:attribute>
                <xsl:value-of select="aid"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">hash</xsl:attribute>
                <xsl:value-of select="hash"/>
            </xsl:element>


        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
