/*
 * parser.h -  parser for MySocials driver
 * This file is part of MSA program
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _PARSER_H_
#define _PARSER_H_

/*
 * MSA_UNUSED is used to prevent warnings about unused variables.
 * Use with caution, because this may complicate the detection of errors.
 */
#define MSA_UNUSED(x) (void)x;

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <json.h>
#include <glib.h>

#include <unistd.h>

#include "driver_config.h"
#include "driver.h"
#include "profile.h"

int json_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
int settings_parser(xmlDocPtr inner_req, struct ProfileData *cp, gchar* data, int data_size, gchar **response);
int empty_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
int download_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
int text_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
int webauth_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
void process_url(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response);
#endif
