<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>


<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getTotalCountInbox</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="$MID"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">quantity</xsl:attribute>
                    <xsl:value-of select="count"/>
            </xsl:element>

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
