/*
 * vkontakte.c -  driver vkontakte of MSA program
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
//#include "msa.h"
//#include "mysocials_driver.h"

#include "driver.h"
#include "vkontakte.h"

#include <libxml/tree.h>
#include <libxml/parser.h>


/**
* Функция отправки данных драйвером
*/
static int vk_driver_send(xmlDocPtr request, xmlDocPtr* response, msa_module* driver_info);

static int vk_driver_shutdown();
/**
 * Module initialization. Prepare driverVK for work.
 *
 * @param d - msa_module, information for dispatcher
 * @return 0 on success or 1 otherwise.
 */
extern int msa_module_init(msa_module* d)
{
#ifdef TEST
    g_debug("TEST = %d",TEST );
#endif
    g_debug("driver %s: init START", DRIVER_NAME);

    d->name = g_strdup(DRIVER_NAME);
    d->send = vk_driver_send;
    d->shutdown = vk_driver_shutdown;
    d->shutdown = NULL;
    d->pic = VK_PIC;
    
    
    set_events = d->set_events;
    

    GConfClient *client;
    gchar* login;
    gchar* password;
    gint value;
    gint time = 0;
    int conf = 0;

g_debug("before gconf");
    g_type_init();
    client = gconf_client_get_default ();
g_debug("after gconf");

    /* Get the initial value from GConf. */
    gchar* path  = g_strconcat(PATH, STATUS, NULL);
    value = gconf_client_get_int (client, path , NULL);
    g_free(path);
    
    path = g_strconcat(PATH, LOGIN, NULL);
    login = gconf_client_get_string (client, path, NULL);
    g_free(path);
    
    path= g_strconcat(PATH, PASSWORD, NULL);
    password = gconf_client_get_string (client, path, NULL);
    g_free(path);
    d->status = value;

    path  = g_strconcat(PATH, AUTOUPDATE, NULL);
    time = gconf_client_get_int (client, path , NULL);
    g_free(path);

	
    if (value == 0) {
        d->status = OFF;
        d->state = CONF;
    } else {
        if ( login == NULL || password == NULL ) {
            d->state = NOT_CONF;
            d->status = OFF;
        } else {
            g_free(login);
            g_free(password);
            d->state = CONF;
        }
#ifndef TEST
        g_print("TEST NOT DEFINE\n");
        init_event_manager((int)time);
#endif
    }

    g_object_unref((gpointer)client);
    
    g_debug("driver %s: init END", DRIVER_NAME);
    return 0;
}

/**
 * DriverVK handler
 *
 * @param request -  
 * @param response - 
 * @return 0 on success or 1 otherwise.
 */
static int vk_driver_send(xmlDocPtr request, xmlDocPtr* response, msa_module* info)
{
    xmlDocPtr reqXml = NULL, bufXml = NULL;
    xmlDocPtr doc = NULL;
    if (info == NULL) {
        g_debug("default proxy settings");
        info_proxy = g_strdup("proxy.karelia.ru");
        info_port = 81;
    } else {
        g_debug("get proxy settings %s %d ", info->proxy, info->port);
        info_proxy = info->proxy;
        info_port = info->port;    
    }

    g_debug("vk_driver_send: START");
    xmlDocDump(stdout, request);

    doc = xmlNewDoc(BAD_CAST "1.0");
    doc->encoding = g_strdup(UTF8);


	if(request == NULL)
	{
		printf("Error! Can't open request.xml\n");
		return 1;
	}

    xmlNodePtr node = NULL, node2 = NULL;
    node = xmlDocGetRootElement(request);
    node = node->children;
    char *source;
    
    while (node != NULL) {
        if (strcmp(node->name, "Content")==0) {
            node = node->children;
            //xmlUnlinkNode(node);
            node2 = xmlCopyNode(node,1); 

            bufXml = xmlNewDoc(BAD_CAST "1.0");
            bufXml->encoding = UTF8;
            xmlDocSetRootElement(bufXml,node2);
            break;
        } else if(strcmp(node->name, "SourceID") == 0) {
                source = xmlNodeGetContent(node);
                }
        node = node->next;
    }

    int i = 0;
    xmlDocDump(stdout, bufXml);
    vk_req(bufXml, doc, info);
    //xmlFreeDoc(bufXml);    

    //xmlDocDump(stdout,doc);

    int *size;
    char* tmp;
    xmlChar* temp2;

    node = xmlDocGetRootElement(doc);
    node2 = xmlCopyNode(node, 1);
    //xmlFreeNode(node);
    xmlFreeDoc(doc);
    reqXml = xmlNewDoc( BAD_CAST g_strdup("1.0"));
    reqXml->encoding = g_strdup(UTF8);

    node = xmlNewDocNode(reqXml, NULL, "TransitData", NULL);
    xmlDocSetRootElement(reqXml, node);

    xmlNodePtr child;
    child = xmlNewDocNode(reqXml, NULL, "SourceID", NULL);
    xmlNodeSetContent(child, "vkontakte");
    xmlAddChild(node, child);

    child = xmlNewDocNode(reqXml, NULL, "TargetID", NULL);
    xmlNodeSetContent(child, source);
    xmlAddChild(node, child);
    g_free(source);

    child = xmlNewDocNode(reqXml, NULL, "Content", NULL);
    xmlAddChild(node, child);

    node = node->children;

    while (node != NULL) {
        if (strcmp(node->name, "Content") ==  0) {
            xmlAddChild(node, node2);
            break;
        }
        node = node->next;  
    }
    xmlDocDump(stdout, reqXml);
    *response = xmlCopyDoc(reqXml, 1);
    xmlFreeDoc(request);
    xmlFreeDoc(reqXml);
    //g_debug("!!!!!!!");
    return 0;
}

/**
 * Shutdown driver
 *
 * @return 0
 */
static int vk_driver_shutdown()
{
//maybe remove cookie and logout from server
    g_debug("vk_driver_shutdown");
    return 0;
}
