/*
 * vkontakte.c -  driver vkontakte of MSA program
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "driver.h"
#include "vkontakte.h"

#include <libxml/tree.h>
#include <libxml/parser.h>

const char* response_string = "\
<TransitData>\
<TargetID></TargetID>\
<SourceID>vkontakte</SourceID>\
<Content>\
</Content>\
</TransitData>";
/**
* Функция отправки данных драйвером
*/
static int vk_driver_send(xmlDocPtr request, xmlDocPtr* response, msa_module* driver_info);

static int vk_driver_shutdown();
/**
 * Module initialization. Prepare driverVK for work.
 *
 * @param d - msa_module, information for dispatcher
 * @return 0 on success or 1 otherwise.
 */
extern int msa_module_init(msa_module* d)
{
#ifdef TEST
    g_debug("TEST = %d",TEST );
#endif
    g_debug("driver %s: init START", DRIVER_NAME);

    d->name = g_strdup(DRIVER_NAME);
    d->send = vk_driver_send;
    d->shutdown = vk_driver_shutdown;
    d->pic = g_strdup(VK_PIC);
    
    
    set_events = d->set_events;
    

    GConfClient *client;
    gchar* login;
    gchar* password;
    gint value;
    gint time = 0;
    int conf = 0;

g_debug("before gconf");
    g_type_init();
    client = gconf_client_get_default ();
g_debug("after gconf");

    /* Get the initial value from GConf. */
    gchar* path  = g_strconcat(PATH, STATUS, NULL);
    value = gconf_client_get_int (client, path , NULL);
    g_free(path);
    
    path = g_strconcat(PATH, LOGIN, NULL);
    login = gconf_client_get_string (client, path, NULL);
    g_free(path);
    
    path= g_strconcat(PATH, PASSWORD, NULL);
    password = gconf_client_get_string (client, path, NULL);
    g_free(path);
    d->status = value;

    path  = g_strconcat(PATH, AUTOUPDATE, NULL);
    time = gconf_client_get_int (client, path , NULL);
    g_free(path);

	
    if (value == 0) {
        d->status = OFF;
        d->state = CONF;
    } else {
        if ( login == NULL || password == NULL ) {
            d->state = NOT_CONF;
            d->status = OFF;
        } else {
            g_free(login);
            g_free(password);
            d->state = CONF;
        }
#ifndef TEST
        g_print("TEST NOT DEFINE\n");
        init_event_manager((int)time);
#endif
    }

    g_object_unref((gpointer)client);
    
    g_debug("driver %s: init END", DRIVER_NAME);
    return 0;
}

/**
 * DriverVK handler
 *
 * @param request -  
 * @param response - 
 * @return 0 on success or 1 otherwise.
 */
static int vk_driver_send(xmlDocPtr request, xmlDocPtr* response, msa_module* info)
{
    xmlDocPtr reqXml = NULL, respXml = NULL;
    xmlDocPtr buffXml = NULL;
    if (info == NULL) {
        g_debug("msa_module in NULL! can't perform request!");
        return FAILURE;
    } else {
        g_debug("get proxy settings %s %d ", info->proxy, info->port);
        info_proxy = info->proxy;
        info_port = info->port;
    }

    g_debug("vk_driver_send: START");

    respXml = xmlNewDoc(BAD_CAST "1.0");
    respXml->encoding = g_strdup(UTF8);


    if(request == NULL) {
        printf("Error! Can't read request\n");
        return FAILURE;
    }

    xmlXPathObject *Obj = NULL;
    xmlNodePtr node = NULL, node_request = NULL, node_response = NULL;
    gchar* source;
    
    Obj = xpath("//TransitData/SourceID", request);
    if(Obj != NULL) {
        node = Obj->nodesetval->nodeTab[0];
        source = xmlNodeGetContent(node);
        xmlXPathFreeObject(Obj);
    } else {
        return FAILURE;
      }
    
    Obj = xpath("//TransitData/Content/Request", request);
    if(Obj != NULL) {
        node = Obj->nodesetval->nodeTab[0];
        node_request = xmlCopyNode(node, 1);
        xmlUnlinkNode(node_request);
        reqXml = xmlNewDoc(BAD_CAST "1.0");
        reqXml->encoding = g_strdup(UTF8);
        xmlDocSetRootElement(reqXml, node_request);
        xmlXPathFreeObject(Obj);
    } else {
        return FAILURE;
      }
    xmlFreeDoc(request);
    
    vk_req(reqXml, respXml, info);
    xmlFreeDoc(reqXml);

    node = xmlDocGetRootElement(respXml);
    node_response = xmlCopyNode(node, 1);
    xmlUnlinkNode(node_response);
    xmlFreeDoc(respXml);
    
    //buffXml = xmlNewDoc( BAD_CAST "1.0");

    buffXml = xmlParseDoc(BAD_CAST response_string);
    buffXml->encoding = g_strdup(UTF8);
    
    Obj = xpath("//TransitData/TargetID", buffXml);
    if(Obj != NULL) {
        node = Obj->nodesetval->nodeTab[0];
        xmlNodeSetContent(node, source);
        xmlXPathFreeObject(Obj);
    } else {
        return FAILURE;
    }

    Obj = xpath("//TransitData/Content", buffXml);
    if(Obj != NULL){
        node = Obj->nodesetval->nodeTab[0];
        xmlAddChild(node, node_response);
        xmlXPathFreeObject(Obj);
    } else {
        return FAILURE;
    }
    
    *response = xmlCopyDoc(buffXml, 1);
    xmlFreeDoc(buffXml);
    g_free(source);
    g_debug("vk_driver_send: END");
    return SUCCESS;
}

/**
 * Shutdown driver
 *
 * @return 0
 */
static int vk_driver_shutdown()
{
//maybe remove cookie and logout from server
    g_debug("vk_driver_shutdown");
    return 0;
}
