/*
 * module.h - interface for module developers
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Alexander V. Borodin
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MAS program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MAS program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _MSA_MODULE_H_
#define _MSA_MODULE_H_

#include <glib.h>

#include <libxml/tree.h>
#include <libxml/parser.h>


#define VK_ID "vkontakte"
#define UI_ID "ui"
#define DB_ID "db"
//#define MYSPACE_ID "myspace"
#define DRV_MANAGER_ID "drv_manager"
#define HANDLER_ID "handler"
#define KERNEL_ID "kernel"
#define TEST_ID "test_module" // id test module :))  

#define TARGET_TAG "TargetID"
#define TARGET_TAG_ORDER_ATTR "orderNumber"
#define TARGET_TAG_XPATH "//TransitData/TargetID"
#define SOURCE_TAG_XPATH "//TransitData/SourceID"
#define REQUEST_TAG_XPATH "//TransitData/Content/Request"
#define RESPONSE_TAG_XPATH "//TransitData/Content/Response"
#define REQUEST_PARAMS_TAG_XPATH "//TransitData/Content/Request/Params"
#define RESPONSE_PARAMS_TAG_XPATH "//TransitData/Content/Response/Params"

//FIXME use in ui.c 
#define PARAMS_TAG_XPATH "//TransitData/Content/Response/Params/array"

#define CLASS_PROFILE "profile"
#define GET_PROFILE "getProfile"
#define GET_FRIENDS_PROFILE "getFriendsProfile"
#define SET_PROFILE "setProfile"
#define UPDATE_PROFILE "updateProfile"

#define CLASS_FRIENDS "friends"
#define GET_FRIENDS "getListFriends"
#define UPDATE_FRIENDS "updateListFriends"

#define CLASS_BOX_MESSAGE "messages"
#define UPDATE_INBOX_MESSAGES "updateInboxMessages"
#define UPDATE_OUTBOX_MESSAGES "updateOutboxMessages"
#define GET_INBOX_MESSAGES "getInboxMessages"
#define GET_OUTBOX_MESSAGES "getOutboxMessages"
#define GET_NEW_MESSAGES "getNewInboxMessages"

#define CLASS_MESSAGES "systemMessages"
#define INFO_MESSAGE "infoMessage"
#define ERROR_MESSAGE "errorMessage"

#define CLASS_BINARY_DATA "binaryData"
#define GET_BINARY_DATA "getBinaryData"

#define TARGET_NODE "TargetID"

/* Error Code */
typedef enum error_type
{
    FAILURE = -1,
    NO_ERRORS = 0,
    SUCCESS = 0,
    ERROR_ALLOCATION_OF_MEMORY,
    ERROR_NO_DRIVER_FUNCTION,
    ERROR_INITIALIZATION_ALREADY_PASSED,
    ERROR_DRIVER_IS_BUSY,
    ERROR_CANT_SEND_DATA,
    ERROR_CANT_PARSE_DATA
} error_type ;
/** db message code **/
//#define DB_SAVE_ERROR_PROFILE_CODE "300"
//#define DB_SAVE_MESSAGE_PROFILE_CODE "301"
//#define DB_GET_ERROR_PROFILE_CODE "302"
//#define DB_SAVE_MESSAGE_FRIENDS_CODE "310"
//#define DB_SAVE_ERROR_FRIENDS_CODE "311"
//#define DB_GET_ERROR_FRIENDS_CODE "312"
//#define DB_SAVE_MESSAGE_FRIENDS_PROFILE_CODE "313"
//#define DB_SAVE_ERROR_FRIENDS_PROFILE_CODE "314"
//#define DB_GET_ERROR_BINARY_CODE "321"
//#define DB_SAVE_ERROR_BINARY_CODE "322"
//#define DB_GET_ERROR_INBOX_MESSAGES_CODE "331"
//#define DB_GET_ERROR_OUTBOX_MESSAGES_CODE "332"
//#define DB_UPDATE_MESSAGE_INBOX_MESSAGES_CODE "333"
//#define DB_UPDATE_MESSAGE_OUTBOX_MESSAGES_CODE "334"
//#define DB_GET_ERROR_INBOX_MESSAGE_CODE "335"
//#define DB_NEW_INBOX_MESSAGES_CODE "341"
//#define DB_INIT_ERROR_CODE "351"

/** db message text **/
//#define DB_SAVE_MESSAGE_PROFILE_TEXT "profile updated"
//#define DB_SAVE_ERROR_PROFILE_TEXT "profile wasn't updated"
//#define DB_GET_ERROR_PROFILE_TEXT "profile wasn't found"
//#define DB_SAVE_MESSAGE_FRIENDS_TEXT "friends list updated"
//#define DB_SAVE_ERROR_FRIENDS_TEXT "friends list wasn't updated"
//#define DB_GET_ERROR_FRIENDS_TEXT "friends list wasn't found"
//#define DB_SAVE_MESSAGE_FRIENDS_PROFILE_TEXT "friend's profile updated"
//#define DB_SAVE_ERROR_FRIENDS_PROFILE_TEXT "friend's profile wasn't updated"
//#define DB_GET_ERROR_BINARY_TEXT "image wasn't found"
//#define DB_SAVE_ERROR_BINARY_TEXT "image wasn't updated"
//#define DB_GET_ERROR_INBOX_MESSAGES_TEXT "inbox messages list wasn't saved" 
//#define DB_GET_ERROR_OUTBOX_MESSAGES_TEXT "outbox messages list wasn't saved" 
//#define DB_UPDATE_MESSAGE_INBOX_MESSAGES_TEXT "inbox messages list saved" 
//#define DB_UPDATE_MESSAGE_OUTBOX_MESSAGES_TEXT "outbox messages list was saved" 
//#define DB_GET_ERROR_INBOX_MESSAGE_TEXT "inbox messages list wasn't found"
//#define DB_NEW_INBOX_MESSAGES_TEXT "new messages:"
//#define DB_INIT_ERROR_TEXT "db critical error"

/** Driver message code **/
#define DRV_SETT_ERROR_CODE "409"
#define DRV_SETT_SAVED_CODE "410"
#define DRV_AUTH_ERROR_CODE "407"
#define DRV_REQ_ERROR_CODE "402"
#define DRV_PROF_SAVED_CODE "400"
#define DRV_CAPT_ERROR_CODE "408"
#define DRV_RESP_ERROR_CODE "403"
#define DRV_NETW_ERROR_CODE "404"
#define DRV_MESS_SEND_CODE "401"
#define DRV_MESS_ERROR_CODE "405"
#define DRV_ACCESS_ERROR_CODE "406"
#define DRV_SERVER_ERROR_CODE "411"

/** Driver message text **/
#define DRV_SETT_ERROR "Unable to save settings"
#define DRV_SETT_SAVED "Settings saved"
#define DRV_AUTH_ERROR "Authorization problem"
#define DRV_REQ_ERROR "Unable to perform request"
#define DRV_PROF_SAVED "Profile changed"
#define DRV_CAPT_ERROR "Captcha"
#define DRV_RESP_ERROR "Bad response from server"
#define DRV_NETW_ERROR "Network problem"
#define DRV_MESS_SEND "Message send"
#define DRV_MESS_ERROR "Unable send message"
#define DRV_ACCESS_ERROR "Operation prohibited by privacy"
#define DRV_SERVER_ERROR "Internal Server Error"

/** @enum msa_module_type
 *  @brief List of module types
 *
 *  Currently there are three module types:
 *    UI for user interface modules
 *    SYSTEM for system modules (kernel)
 *    DRIVER for network services connectivity modules
 */
typedef enum _msa_module_type {
    MODULE,
    DRIVER,
    SYSTEM,
    TEST_MODULE
} msa_module_type;

/** @enum status
 *  @brief List of module status
 *
 *  Currently there are two module status:
 *    ON module on
 *    OFF module off
 *    BROKEN module have fatal error!
 */

typedef enum _msa_module_status {
	OFF = 0,
    ON = 1,
    BROKEN = 2,
    BUSY = 3,
	NOT_CON = 4   

} msa_module_status;


/** @enum state
 *  @brief List of status
 *
 *  Currently there are two module status:
 *    ON module on
 *    OFF module off
 */

typedef enum _msa_module_state {
    CONF = 1,
    NOT_CONF = 0
} msa_module_state;

/** @struct msa_module
 *  @brief Id info and interface functions for external modules
 *
 *  Each module should implement function named
 *  int init_module(msa_module *mod)
 *  which fills in the fields of this structure and link
 *  appropriate functions to function pointers
 *  @see msa_module_type
 */
typedef struct _msa_module {
    msa_module_type type;     /** Module type of msa_module_type enum */
    gchar* id;                /** Module id, a null-terminated string*/
    gchar* name;              /** Module name for UI purposes */
    msa_module_status status; /** Module status 0 - not active  **/
    msa_module_status state;  /** Module state 0 - OK Conf 1 - not conf**/
    gchar* pic;               /** Module icon for UI purposes */
    gchar* proxy;
    gint port;

    /** Receives transmitted data to the module
     *
     *  @param data Data in XML, encoded in UTF-8
     *  @param info - information about proxy and port
     *  @return Error code for data transfer operatio
     *  @retval 0 data transfer succeeded
     */
    int (*send)(xmlDocPtr request, xmlDocPtr* response, struct _msa_module* info);

    /** UI start
     *
     *  @param msa_module struct for kernel
     *  @param list_drv GList struct with drivers
     *  @return Error code for data transfer operation
     *  @retval 0 module start succesed
     */
    int (*module_start)(gpointer kernel, gpointer list_drv, int argc, char* argv[]);


    /** Setup new module settings
     *
     *  @param id modules
     *  @param settings in struct msa_driver_info
     *  @return Error code for data transfer operation
     *  @retval 0 data transfer succeeded
     */
    int (*msa_settings)(xmlChar* info, xmlDocPtr request);


     /** Put data with events in hanler 
     *
     *  @param events data in XML, encoded in UTF-8
     *  @return Error code for data transfer operation
     *  @retval 0 data transfer succeeded
     */
    int (*set_events)(xmlChar* data);

    int (*shutdown)();

} msa_module;


#endif
