#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* texture;
	ClutterTimeline* timeline;
	ClutterAnimation* animation;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	texture = tangle_texture_new("test_image_135x100.jpg");
	g_assert(texture != NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), texture);

	timeline = tangle_timeline_new_with_fps(10000, 20);
	clutter_timeline_set_direction(timeline, CLUTTER_TIMELINE_BACKWARD);
	animation = clutter_actor_animate_with_timeline(texture, CLUTTER_LINEAR, timeline, "scale-x", 20.0, "scale-y", 20.0, NULL);
	clutter_animation_set_loop(animation, TRUE);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
