/*
 * tangle-transition.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-transition.h"

/**
 * SECTION:tangle-transition
 * @Short_description: A base class for transitions that are used to animate actors between allocations
 * @Title: TangleTransition
 */

G_DEFINE_ABSTRACT_TYPE(TangleTransition, tangle_transition, G_TYPE_OBJECT);

ClutterTimeline* tangle_transition_animate_actor(TangleTransition* transition, TangleActor* actor, ClutterActorBox* current_box, ClutterActorBox* new_box) {
	ClutterTimeline* timeline = NULL;
	TangleTransitionClass* transition_class;

	g_return_val_if_fail(TANGLE_IS_TRANSITION(transition), NULL);
	
	transition_class = TANGLE_TRANSITION_GET_CLASS(transition);
	if (transition_class->animate_actor) {
		timeline = transition_class->animate_actor(transition, actor, current_box, new_box);
	}

	return timeline;
}

static void tangle_transition_class_init(TangleTransitionClass* klass) {
}

static void tangle_transition_init(TangleTransition* transition) {
}
