/*
 * tangle-grid.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */
#ifndef __TANGLE_GRID_H__
#define __TANGLE_GRID_H__

#include "tangle-actor.h"

#define TANGLE_TYPE_GRID (tangle_grid_get_type())
#define TANGLE_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_GRID, TangleGrid))
#define TANGLE_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_GRID))
#define TANGLE_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_GRID, TangleGridClass))
#define TANGLE_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_GRID))
#define TANGLE_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_GRID, TangleGridClass))

typedef struct _TangleGridPrivate TangleGridPrivate;

typedef struct _TangleGrid {
	TangleActor parent_instance;
	TangleGridPrivate* priv;
} TangleGrid;

typedef struct _TangleGridClass {
	TangleActorClass parent_class;
} TangleGridClass;

GType tangle_grid_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_grid_new(gfloat grid_spacing_x, gfloat grid_spacing_y);
ClutterActor* tangle_grid_new_with_line_color(gfloat grid_spacing_x, gfloat grid_spacing_y, ClutterColor* line_color);

gfloat tangle_grid_get_grid_spacing_x(TangleGrid* grid);
void tangle_grid_set_grid_spacing_x(TangleGrid* grid, gfloat grid_spacing_x);
gfloat tangle_grid_get_grid_spacing_y(TangleGrid* grid);
void tangle_grid_set_grid_spacing_y(TangleGrid* grid, gfloat grid_spacing_y);

guint tangle_grid_get_line_width_x(TangleGrid* grid);
void tangle_grid_set_line_width_x(TangleGrid* grid, guint line_width_x);
guint tangle_grid_get_line_width_y(TangleGrid* grid);
void tangle_grid_set_line_width_y(TangleGrid* grid, guint line_width_y);

void tangle_grid_get_background_color(TangleGrid* grid, ClutterColor* color_return);
void tangle_grid_set_background_color(TangleGrid* grid, const ClutterColor* background_color);

void tangle_grid_get_line_color_x(TangleGrid* grid, ClutterColor* color_return);
void tangle_grid_set_line_color_x(TangleGrid* grid, const ClutterColor* line_color_x);
void tangle_grid_get_line_color_y(TangleGrid* grid, ClutterColor* color_return);
void tangle_grid_set_line_color_y(TangleGrid* grid, const ClutterColor* line_color_y);


#endif
