/*
 * tangle-transition.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TRANSITION_H__
#define __TANGLE_TRANSITION_H__

#define TANGLE_TYPE_TRANSITION (tangle_transition_get_type())
#define TANGLE_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TRANSITION, TangleTransition))
#define TANGLE_IS_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TRANSITION))
#define TANGLE_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TRANSITION, TangleTransitionClass))
#define TANGLE_IS_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TRANSITION))
#define TANGLE_TRANSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TRANSITION, TangleTransitionClass))

typedef struct _TangleTransitionPrivate TangleTransitionPrivate;

typedef struct _TangleTransition TangleTransition;
typedef struct _TangleTransitionClass TangleTransitionClass;

#include "tangle-actor.h"

struct _TangleTransition {
	GObject parent_instance;
};

struct _TangleTransitionClass {
	GObjectClass parent_class;
	ClutterTimeline* (*animate_actor)(TangleTransition* transition, TangleActor* actor, ClutterActorBox* current_box, ClutterActorBox* new_box);
};

GType tangle_transition_get_type(void) G_GNUC_CONST;

ClutterTimeline* tangle_transition_animate_actor(TangleTransition* transition, TangleActor* actor, ClutterActorBox* current_box, ClutterActorBox* new_box);

#endif
