/*
 * tangle-trick.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TRICK_H__
#define __TANGLE_TRICK_H__

#define TANGLE_TYPE_TRICK (tangle_trick_get_type())
#define TANGLE_TRICK(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TRICK, TangleTrick))
#define TANGLE_IS_TRICK(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TRICK))
#define TANGLE_TRICK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TRICK, TangleTrickClass))
#define TANGLE_IS_TRICK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TRICK))
#define TANGLE_TRICK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TRICK, TangleTrickClass))

typedef struct _TangleTrick TangleTrick;
typedef struct _TangleTrickClass TangleTrickClass;
typedef struct _TangleTrickPrivate TangleTrickPrivate;

#include "tangle-object.h"
#include "tangle-widget.h"

struct _TangleTrick {
	TangleObject parent_instance;
	TangleTrickPrivate* priv;
};

struct _TangleTrickClass {
	TangleObjectClass parent_class;
	void (*manipulate_preferred_width)(TangleTrick* trick, TangleWidget* widget, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p);
	void (*manipulate_preferred_height)(TangleTrick* trick, TangleWidget* widget, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p);
	void (*manipulate_allocation)(TangleTrick* trick, TangleWidget* widget, ClutterActorBox* box, ClutterAllocationFlags flags);
	void (*manipulate_child_allocation)(TangleTrick* trick, TangleWidget* widget, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
};

GType tangle_trick_get_type(void) G_GNUC_CONST;

TangleLayout* tangle_trick_get_layout(TangleTrick* trick);
void tangle_trick_set_layout(TangleTrick* trick, TangleLayout* layout);

void tangle_trick_manipulate_preferred_width(TangleTrick* trick, TangleWidget* widget, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p);
void tangle_trick_manipulate_preferred_height(TangleTrick* trick, TangleWidget* widget, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p);
void tangle_trick_manipulate_allocation(TangleTrick* trick, TangleWidget* widget, ClutterActorBox* box, ClutterAllocationFlags flags);
void tangle_trick_manipulate_child_allocation(TangleTrick* trick, TangleWidget* widget, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);

void tangle_trick_layout_changed(TangleTrick* trick);

#endif
