/*
 * tangle-texture.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TEXTURE_H__
#define __TANGLE_TEXTURE_H__

#include "tangle-actor.h"

#define TANGLE_TYPE_TEXTURE (tangle_texture_get_type())
#define TANGLE_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TEXTURE, TangleTexture))
#define TANGLE_IS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TEXTURE))
#define TANGLE_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TEXTURE, TangleTextureClass))
#define TANGLE_IS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TEXTURE))
#define TANGLE_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TEXTURE, TangleTextureClass))

typedef struct _TangleTexturePrivate TangleTexturePrivate;

typedef struct _TangleTexture {
	TangleActor parent_instance;
	TangleTexturePrivate* priv;
} TangleTexture;

typedef struct _TangleTextureClass {
	TangleActorClass parent_class;
	
	void (*size_changed)(TangleTexture* texture, gint width, gint height);
} TangleTextureClass;

GType tangle_texture_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_texture_new(const gchar* filename);

void tangle_texture_set_from_file(TangleTexture* texture, const gchar* filename);
void tangle_texture_get_repeat(TangleTexture* texture, gboolean* repeat_x_return, gboolean* repeat_y_return);
void tangle_texture_set_repeat(TangleTexture* texture, gboolean repeat_x, gboolean repeat_y);

#endif
