/*
 * tangle-draggable-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_CLONE_H__
#define __TANGLE_CLONE_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_CLONE (tangle_clone_get_type())
#define TANGLE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_CLONE, TangleClone))
#define TANGLE_IS_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_CLONE))
#define TANGLE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_CLONE, TangleCloneClass))
#define TANGLE_IS_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_CLONE))
#define TANGLE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_CLONE, TangleCloneClass))

typedef struct _TangleClonePrivate TangleClonePrivate;

typedef struct _TangleClone {
	ClutterClone parent_instance;
	TangleClonePrivate* priv;
} TangleClone;

typedef struct _TangleCloneClass {
	ClutterCloneClass parent_class;
} TangleCloneClass;

GType tangle_clone_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_clone_new(ClutterActor* source);

gboolean tangle_clone_get_source_pickable(TangleClone* clone);
void tangle_clone_set_source_pickable(TangleClone* clone, gboolean source_pickable);

#endif
