#include <tangle/tangle.h>

static void on_clicked(TangleButton* button, gpointer user_data) {
	ClutterActor* view;
	
	view = CLUTTER_ACTOR(user_data);
	
	if (tangle_button_get_selected(button)) {
		clutter_actor_show(view);
	} else {
		clutter_actor_hide(view);
		tangle_view_unload(TANGLE_VIEW(view));
	}
}

static void on_notify_selected(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	g_printf("selected %p\n", tangle_button_group_get_selected_button(TANGLE_BUTTON_GROUP(object)));
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* normal_texture;
	ClutterActor* active_texture;
	ClutterActor* selected_texture;
	ClutterActor* button;
	ClutterActor* view;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	view = tangle_view_new();
	tangle_view_set_filename(TANGLE_VIEW(view), "test-view.json");
	clutter_actor_set_position(view, 200.0, 10.0);

	normal_texture = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	active_texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);
	selected_texture = clutter_texture_new_from_file("test_image_selected_100x74.jpg", NULL);

	button = tangle_button_new_selectable_with_background_actors(normal_texture, active_texture, selected_texture);
	tangle_button_set_selected(TANGLE_BUTTON(button), TRUE);
	clutter_actor_set_position(button, 10.0, 10.0);
	g_signal_connect(button, "clicked", G_CALLBACK(on_clicked), view);

	clutter_container_add(CLUTTER_CONTAINER(stage), button, view, NULL);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
