/*
 * tangle-box-layout.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_BOX_LAYOUT_H__
#define __TANGLE_BOX_LAYOUT_H__

#include <clutter/clutter.h>
#include "tangle-layout.h"

/* TangleBoxLayoutMeta */

#define TANGLE_TYPE_BOX_LAYOUT_META (tangle_box_layout_meta_get_type ())
#define TANGLE_BOX_LAYOUT_META(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_BOX_LAYOUT_META, TangleBoxLayoutMeta))
#define TANGLE_IS_BOX_LAYOUT_META(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_BOX_LAYOUT_META))
#define TANGLE_BOX_LAYOUT_META_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TANGLE_BOX_LAYOUT_META, TangleBoxLayoutMetaClass))
#define TANGLE_IS_BOX_LAYOUT_META_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TANGLE_TYPE_BOX_LAYOUT_META))
#define TANGLE_BOX_LAYOUT_META_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TANGLE_TYPE_BOX_LAYOUT_META, TangleBoxLayoutMetaClass))

typedef struct _TangleBoxLayoutMetaPrivate TangleBoxLayoutMetaPrivate;

typedef struct _TangleBoxLayoutMeta {
	TangleLayoutMeta parent_instance;

	TangleBoxLayoutMetaPrivate* priv;
} TangleBoxLayoutMeta;

typedef struct _TangleBoxLayoutMetaClass {
	TangleLayoutMetaClass parent_class;
} TangleBoxLayoutMetaClass;

GType tangle_box_layout_meta_get_type (void) G_GNUC_CONST;

TangleLayoutMeta* tangle_box_layout_meta_new(TangleLayout* layout, ClutterActor* actor);


/* TangleBoxLayout */

#define TANGLE_TYPE_BOX_LAYOUT (tangle_box_layout_get_type ())
#define TANGLE_BOX_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_BOX_LAYOUT, TangleBoxLayout))
#define TANGLE_IS_BOX_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_BOX_LAYOUT))
#define TANGLE_BOX_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TANGLE_BOX_LAYOUT, TangleBoxLayoutClass))
#define TANGLE_IS_BOX_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TANGLE_TYPE_BOX_LAYOUT))
#define TANGLE_BOX_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TANGLE_TYPE_BOX_LAYOUT, TangleBoxLayoutClass))

typedef struct _TangleBoxLayoutPrivate TangleBoxLayoutPrivate;

typedef struct _TangleBoxLayout {
	TangleLayout parent_instance;

	TangleBoxLayoutPrivate* priv;
} TangleBoxLayout;

typedef struct _TangleBoxLayoutClass {
	TangleLayoutClass parent_class;
} TangleBoxLayoutClass;

GType tangle_box_layout_get_type (void) G_GNUC_CONST;

TangleLayout* tangle_box_layout_new(void);

gfloat tangle_box_layout_get_focus_position(TangleBoxLayout* box_layout);
void tangle_box_layout_set_focus_position(TangleBoxLayout* box_layout, gfloat focus_position);
gfloat tangle_box_layout_get_focus_length(TangleBoxLayout* box_layout);
void tangle_box_layout_set_focus_length(TangleBoxLayout* box_layout, gfloat focus_length);

#endif
