/*
 * tangle-fixed-layout.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_FIXED_LAYOUT_H__
#define __TANGLE_FIXED_LAYOUT_H__

#include "tangle-layout.h"

#define TANGLE_TYPE_FIXED_LAYOUT (tangle_fixed_layout_get_type())
#define TANGLE_FIXED_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_FIXED_LAYOUT, TangleFixedLayout))
#define TANGLE_IS_FIXED_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_FIXED_LAYOUT))
#define TANGLE_FIXED_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_FIXED_LAYOUT, TangleFixedLayoutClass))
#define TANGLE_IS_FIXED_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_FIXED_LAYOUT))
#define TANGLE_FIXED_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_FIXED_LAYOUT, TangleFixedLayoutClass))

typedef struct _TangleFixedLayout {
	TangleLayout parent_instance;
} TangleFixedLayout;

typedef struct _TangleFixedLayoutClass {
	TangleLayoutClass parent_class;
} TangleFixedLayoutClass;

GType tangle_fixed_layout_get_type(void) G_GNUC_CONST;

TangleLayout* tangle_fixed_layout_new(void);

#endif
