#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	TangleLayout* layout;
	ClutterActor* widget;
	TangleTrick* trick;
	ClutterAction* action;
	guint x, y;
	ClutterActor* texture;
	ClutterActor* horizontal_scrollbar;
	ClutterActor* vertical_scrollbar;
	ClutterColor color = { 0, 0, 128, 255 };
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	layout = tangle_box_layout_new();
	tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_TTB_LTR);
	// tangle_layout_set_use_fixed_position(layout, FALSE);
	widget = tangle_widget_new_scrollable(layout);
	trick = tangle_layout_get_trick_by_type(layout, TANGLE_TYPE_SCROLL_TRICK);
	action = tangle_actor_get_action_by_type(widget, TANGLE_TYPE_SCROLL_ACTION);
	tangle_scroll_trick_set_repeat_axis(TANGLE_SCROLL_TRICK(trick), TANGLE_SCROLL_XY_AXIS);
	clutter_actor_set_reactive(widget, TRUE);
//	for (x = 0; x < 20; x++) {
		for (y = 0; y < 10; y++) {
			texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);

			if (y == 2) {
				clutter_actor_set_position(texture, 75.0, 175.0);
			}

			clutter_container_add_actor(CLUTTER_CONTAINER(widget), texture);
		}
//	}
	clutter_actor_set_size(widget, 500.0, 300.0);
//	g_object_set(action, "max-overshoot-x", 250.0, "max-overshoot-y", 150.0, "repeat-x", TRUE, "repeat-y", TRUE, NULL);
	tangle_scroll_action_set_continuous(TANGLE_SCROLL_ACTION(action), TRUE, TRUE);
//	g_signal_connect(scrolling_actor, "clamp-scrolling-offset-x", G_CALLBACK(tangle_scrolling_actor_clamp_page_boundaries), NULL);
	g_signal_connect_swapped(action, "clamp-offset-x", G_CALLBACK(tangle_widget_clamp_child_boundaries), widget);
	g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(tangle_widget_clamp_child_boundaries), widget);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);
	
//	horizontal_scrollbar = tangle_scrollbar_new_rectangle(FALSE, &color);
//	tangle_scrollbar_bind_to_scrolling_actor(TANGLE_SCROLLBAR(horizontal_scrollbar), TANGLE_SCROLLING_ACTOR(scrolling_actor));
//	clutter_actor_set_position(horizontal_scrollbar, 100.0, 350.0);
//	clutter_actor_set_size(horizontal_scrollbar, 500.0, 10.0);
//	clutter_container_add_actor(CLUTTER_CONTAINER(stage), horizontal_scrollbar);

//	vertical_scrollbar = tangle_scrollbar_new_rectangle(TRUE, &color);
//	tangle_scrollbar_bind_to_scrolling_actor(TANGLE_SCROLLBAR(vertical_scrollbar), TANGLE_SCROLLING_ACTOR(scrolling_actor));
//	clutter_actor_set_position(vertical_scrollbar, 600.0, 50.0);
//	clutter_actor_set_size(vertical_scrollbar, 10.0, 300.0);
//	clutter_container_add_actor(CLUTTER_CONTAINER(stage), vertical_scrollbar);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
