#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* grid;
	ClutterColor red = { 255, 0, 0, 255 };
	ClutterColor blue = { 0, 0, 255, 255 };
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	grid = tangle_grid_new(199.0 / 10, 99.0 / 3);
	tangle_grid_set_line_color_x(TANGLE_GRID(grid), &red);
	tangle_grid_set_line_width_x(TANGLE_GRID(grid), 5);
	tangle_grid_set_line_color_y(TANGLE_GRID(grid), &blue);
	tangle_grid_set_line_width_y(TANGLE_GRID(grid), 2);
	clutter_actor_set_size(grid, 200.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), grid);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
