/*
 * tangle-timeline.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TIMELINE_H__
#define __TANGLE_TIMELINE_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_TIMELINE (tangle_timeline_get_type())
#define TANGLE_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TIMELINE, TangleTimeline))
#define TANGLE_IS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TIMELINE))
#define TANGLE_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TIMELINE, TangleTimelineClass))
#define TANGLE_IS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TIMELINE))
#define TANGLE_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TIMELINE, TangleTimelineClass))

typedef struct _TangleTimelinePrivate TangleTimelinePrivate;

typedef struct _TangleTimeline {
	ClutterTimeline parent_instance;
	TangleTimelinePrivate* priv;
} TangleTimeline;

typedef struct _TangleTimelineClass {
	ClutterTimelineClass parent_class;
} TangleTimelineClass;

GType tangle_timeline_get_type(void) G_GNUC_CONST;

ClutterTimeline* tangle_timeline_new(guint msecs);
ClutterTimeline* tangle_timeline_new_with_fps(guint msecs, guint fps);

guint tangle_timeline_get_fps(TangleTimeline* timeline);
void tangle_timeline_set_fps(TangleTimeline* timeline, guint fps);

guint tangle_timeline_get_default_fps(void);
void tangle_timeline_set_default_fps(guint fps);

#endif
