/*
 * tangle-scrollbar.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SCROLLBAR_H__
#define __TANGLE_SCROLLBAR_H__

#include "tangle-widget.h"
#include "tangle-scrolling-actor.h"
#include "tangle-scroller.h"

#define TANGLE_TYPE_SCROLLBAR (tangle_scrollbar_get_type())
#define TANGLE_SCROLLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SCROLLBAR, TangleScrollbar))
#define TANGLE_IS_SCROLLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SCROLLBAR))
#define TANGLE_SCROLLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SCROLLBAR, TangleScrollbarClass))
#define TANGLE_IS_SCROLLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SCROLLBAR))
#define TANGLE_SCROLLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SCROLLBAR, TangleScrollbarClass))

typedef struct _TangleScrollbarPrivate TangleScrollbarPrivate;

typedef struct _TangleScrollbar {
	TangleWidget parent_instance;
	TangleScrollbarPrivate* priv;
} TangleScrollbar;

typedef struct _TangleScrollbarClass {
	TangleWidgetClass parent_class;
} TangleScrollbarClass;

GType tangle_scrollbar_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_scrollbar_new(gboolean vertical);
ClutterActor* tangle_scrollbar_new_rectangle(gboolean vertical, const ClutterColor* color);

gboolean tangle_scrollbar_get_vertical(TangleScrollbar* scrollbar);
ClutterActor* tangle_scrollbar_get_bar_actor(TangleScrollbar* scrollbar);
void tangle_scrollbar_set_bar_actor(TangleScrollbar* scrollbar, ClutterActor* bar_actor);

void tangle_scrollbar_bind_to_scrolling_actor(TangleScrollbar* scrollbar, TangleScrollingActor* scrolling_actor);
void tangle_scrollbar_bind_to_scroller(TangleScrollbar* scrollbar, TangleScroller* scroller);

#endif
