#include <clutter/clutter.h>
#include <tangle/tangle-style.h>
#include <tangle/tangle-stylesheet.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* actor;
	ClutterColor* color;	
	GValue value = { 0 };
	TangleStyle* style;
	TangleStylesheet* stylesheet;

	clutter_init(&argc, &argv);
	stage = clutter_stage_get_default();
	actor = clutter_rectangle_new();
	g_object_set(actor, "x", 10.0, "y", 10.0, "width", 100.0, "height", 100.0, NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	
	color = clutter_color_new(255, 255, 0, 128);
	g_value_init(&value, CLUTTER_TYPE_COLOR);
	clutter_value_set_color(&value, color);
	
	style = tangle_style_new(CLUTTER_TYPE_RECTANGLE);
	tangle_style_set_style_property(style, "color", &value);

	stylesheet = tangle_stylesheet_new();
	tangle_stylesheet_add_style(stylesheet, style);

	tangle_stylesheet_apply(stylesheet, G_OBJECT(actor));

	clutter_actor_show_all(stage);
	
	clutter_main();

	return 0;
}
