/*
 * tangle-curved-transition.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_CURVED_TRANSITION_H__
#define __TANGLE_CURVED_TRANSITION_H__

#include "tangle-easing-transition.h"

#define TANGLE_TYPE_CURVED_TRANSITION (tangle_curved_transition_get_type())
#define TANGLE_CURVED_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_CURVED_TRANSITION, TangleCurvedTransition))
#define TANGLE_IS_CURVED_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_CURVED_TRANSITION))
#define TANGLE_CURVED_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_CURVED_TRANSITION, TangleCurvedTransitionClass))
#define TANGLE_IS_CURVED_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_CURVED_TRANSITION))
#define TANGLE_CURVED_TRANSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_CURVED_TRANSITION, TangleCurvedTransitionClass))

typedef struct _TangleCurvedTransitionPrivate TangleCurvedTransitionPrivate;

typedef struct _TangleCurvedTransition {
	TangleEasingTransition parent_instance;
	TangleCurvedTransitionPrivate* priv;
} TangleCurvedTransition;

typedef struct _TangleCurvedTransitionClass {
	TangleEasingTransitionClass parent_class;
} TangleCurvedTransitionClass;

typedef enum _TangleCurvedTransitionPointMode {
	TANGLE_CURVED_TRANSITION_DISABLED,
	TANGLE_CURVED_TRANSITION_ABSOLUTE,
	TANGLE_CURVED_TRANSITION_RELATIVE
} TangleCurvedTransitionPointMode;

GType tangle_curved_transition_get_type(void) G_GNUC_CONST;

TangleTransition* tangle_curved_transition_new(gulong mode, guint duration);

void tangle_curved_transition_get_show_from(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode* show_from_point_mode_return, gfloat* show_from_x_return, gfloat* show_from_y_return);
void tangle_curved_transition_set_show_from(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode show_from_point_mode, gfloat show_from_x, gfloat show_from_y);
void tangle_curved_transition_get_move_via(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode* move_via_point_mode_return, gfloat* move_via_x_return, gfloat* move_via_y_return);
void tangle_curved_transition_set_move_via(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode move_via_point_mode, gfloat move_via_x, gfloat move_via_y);
void tangle_curved_transition_get_hide_to(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode* hide_to_point_mode_return, gfloat* hide_to_x_return, gfloat* hide_to_y_return);
void tangle_curved_transition_set_hide_to(TangleCurvedTransition* curved_transition, TangleCurvedTransitionPointMode hide_to_point_mode, gfloat hide_to_x, gfloat hide_to_y);

#endif
