#include <tangle/tangle.h>

gboolean on_button_clicked(TangleButton* button) {
	g_print("Clicked\n");
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* widget;
	ClutterActor* texture1;
	ClutterActor* texture2;
	ClutterActor* texture3;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	
	widget = tangle_widget_new();
	clutter_actor_set_position(widget, 100.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);
	
	texture1 = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	clutter_actor_set_position(texture1, 0.0, 0.0);

	/* Texture2 is actually TangleWrapperActor, because we need
	 * tangle_actor_set_depth_position() function.
	 */
	texture2 = tangle_wrapper_actor_new(clutter_texture_new_from_file("test_image_selected_100x74.jpg", NULL));
	clutter_actor_set_position(texture2, 33.0, 33.0);
	tangle_actor_set_depth_position(TANGLE_ACTOR(texture2), -100);

	texture3 = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	clutter_actor_set_position(texture3, 66.0, 66.0);

	clutter_container_add(CLUTTER_CONTAINER(widget), texture1, texture2, texture3, NULL);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
