#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* texture;
	ClutterActor* scrolling_actor;
	ClutterActor* horizontal_scrollbar;
	ClutterActor* vertical_scrollbar;
	ClutterColor color = { 0, 0, 128, 255 };
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);
	scrolling_actor = tangle_scrolling_actor_new(texture);
	clutter_actor_set_position(scrolling_actor, 100.0, 100.0);
	clutter_actor_set_size(scrolling_actor, 50.0, 50.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), scrolling_actor);
	
	horizontal_scrollbar = tangle_scrollbar_new_rectangle(FALSE, &color);
	tangle_scrollbar_bind_to_scrolling_actor(TANGLE_SCROLLBAR(horizontal_scrollbar), TANGLE_SCROLLING_ACTOR(scrolling_actor));
	clutter_actor_set_position(horizontal_scrollbar, 100.0, 150.0);
	clutter_actor_set_size(horizontal_scrollbar, 50.0, 10.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), horizontal_scrollbar);

	vertical_scrollbar = tangle_scrollbar_new_rectangle(TRUE, &color);
	tangle_scrollbar_bind_to_scrolling_actor(TANGLE_SCROLLBAR(vertical_scrollbar), TANGLE_SCROLLING_ACTOR(scrolling_actor));
	clutter_actor_set_position(vertical_scrollbar, 150.0, 100.0);
	clutter_actor_set_size(vertical_scrollbar, 10.0, 50.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), vertical_scrollbar);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
