/*
 * tangle-style.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_VAULT_H__
#define __TANGLE_VAULT_H__

#include <glib-object.h>

typedef struct _TangleVault {
	guint n;
	GValue* values;
} TangleVault;

#define TANGLE_VAULT(p) ((TangleVault*)(p))

TangleVault* tangle_vault_new(guint n, GType first_type, ...);
void tangle_vault_free(TangleVault* vault);
void tangle_vault_get(TangleVault* vault, guint n, GType first_type, ...);

#define tangle_signal_connect_vault(instance, detailed_signal, c_handler, vault) \
	g_signal_connect_data((instance), (detailed_signal), (c_handler), (vault), (GClosureNotify)tangle_vault_free, (GConnectFlags)0)

#endif

