/*
 * tangle-compound-style.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_COMPOUND_STYLE_H__
#define __TANGLE_COMPOUND_STYLE_H__

#include "tangle-style.h"

#define TANGLE_TYPE_COMPOUND_STYLE (tangle_compound_style_get_type())
#define TANGLE_COMPOUND_STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_COMPOUND_STYLE, TangleCompoundStyle))
#define TANGLE_IS_COMPOUND_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_COMPOUND_STYLE))
#define TANGLE_COMPOUND_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_COMPOUND_STYLE, TangleCompoundStyleClass))
#define TANGLE_IS_COMPOUND_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_COMPOUND_STYLE))
#define TANGLE_COMPOUND_STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_COMPOUND_STYLE, TangleCompoundStyleClass))

typedef struct _TangleCompoundStylePrivate TangleCompoundStylePrivate;

typedef struct _TangleCompoundStyle {
	TangleStyle parent_instance;
	TangleCompoundStylePrivate* priv;
} TangleCompoundStyle;

typedef struct _TangleCompoundStyleClass {
	TangleStyleClass parent_class;
} TangleCompoundStyleClass;

GType tangle_compound_style_get_type(void) G_GNUC_CONST;

#include "tangle-stylesheet.h"

TangleCompoundStyle* tangle_compound_style_new(void);
TangleCompoundStyle* tangle_compound_style_new_with_stylesheet(TangleStylesheet* stylesheet);

void tangle_compound_style_add_style(TangleCompoundStyle* compound_style, TangleStyle* style);
void tangle_compound_style_remove_style(TangleCompoundStyle* compound_style, TangleStyle* style);

#endif
