
#include <clutter/clutter.h>

#include "tangle/tangle-button.h"
#include "tangle/tangle-widget.h"
#include "tangle/tangle-box-layout.h"
#include "tangle/tangle-linear-gradient.h"

static ClutterActor* create_item(const gchar* image, const gchar* message) {
	ClutterActor* actor;
	TangleSpacing spacing;
	ClutterActor* texture;
	ClutterActor* text;
	ClutterColor* color0;
	ClutterColor* color1;
	ClutterColor* color2;
	
	actor = tangle_widget_new();
	spacing.left = spacing.right = spacing.top = spacing.bottom = 2.0;
	tangle_actor_set_margin(TANGLE_ACTOR(actor), &spacing);
	tangle_widget_set_layout(TANGLE_WIDGET(actor), tangle_box_layout_new());
//	texture = clutter_texture_new_from_file(image, NULL);
color0 = clutter_color_new(255, 0, 0, 128);
tangle_widget_set_background_color(TANGLE_WIDGET(actor), color0);
color1 = clutter_color_new(0, 0, 255, 255);
color2 = clutter_color_new(0, 0, 0, 0);
texture = tangle_linear_gradient_new(color1, color2);
tangle_actor_animate(TANGLE_ACTOR(texture), CLUTTER_EASE_IN_SINE, 5000, "angle", 6.28);
g_object_set(actor, "width", 44.0, "height", 99.0, NULL);
	tangle_widget_set_background_actor(TANGLE_WIDGET(actor), texture);
clutter_actor_show(texture);

	text = clutter_text_new_with_text("Sans 10pt", message);
//	clutter_container_add(CLUTTER_CONTAINER(actor), text, NULL);
	
	return CLUTTER_ACTOR(actor);
}

static gboolean animate_transition(TangleActor* actor, ClutterActorBox* current_box, ClutterActorBox* new_box) {
	gboolean handled = FALSE;
	gdouble move_x, move_y, scale_x, scale_y;
	gulong mode;
	guint duration;
	
	if (!current_box) {
		g_object_get(actor,
		             "transition-move-x", &move_x, "transition-move-y", &move_y,
		             "transition-scale-x", &scale_x, "transition-scale-y", &scale_y,
			     "transition-mode", &mode, "transition-duration", &duration,
			     NULL);
		move_x = move_y = 0.0;
		scale_x = scale_y = 5.0;
		g_object_set(actor,
		             "transition-move-x", move_x, "transition-move-y", move_y,
			     "transition-scale-x", scale_x, "transition-scale-y", scale_y,
			     "opacity", 0,
			     NULL);
		tangle_actor_animate(actor, mode, duration,
		                      "transition-move-x", 0.0, "transition-move-y", 0.0,
				      "transition-scale-x", 1.0, "transition-scale-y", 1.0,
				      NULL);
		tangle_actor_animate(actor, CLUTTER_EASE_OUT_SINE, duration,
				      "opacity", 255,
				      NULL);
		handled = TRUE;
	}
	
	return handled;
}

static gboolean add_actor(ClutterActor* stage, ClutterEvent* event, gpointer user_data) {
	static int i = 0;
	static int j = 0;
	static int k = 0;
	ClutterContainer* container;
	ClutterActor* actor;

	container = CLUTTER_CONTAINER(user_data);
 	if (clutter_event_get_source(event) == stage) {
		if (clutter_event_get_button(event) == 1) {
			actor = create_item("test_image_100x74.jpg", "Test item");
			j += 1;
			if (j == 3) {
				g_signal_connect(actor, "animate-transition", G_CALLBACK(animate_transition), NULL);
				j = 0;
			}
			clutter_container_add_actor(container, actor);
		} else if (clutter_event_get_button(event) == 2) {
			i += 100;
			if (i > 400) {
				i = 50;
			}
			clutter_actor_set_position(CLUTTER_ACTOR(container), i, i);
			
		} else {
			TangleLayout* layout;
			
			layout = tangle_widget_get_layout(TANGLE_WIDGET(container));
			k += 1;
			if (k == 0) {
				tangle_layout_set_direction(layout, 0);
			} else if (k == 1) {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_VERTICAL_FIRST | TANGLE_LAYOUT_DIRECTION_BTT);
			} else if (k == 2) {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_RTL);
			} else {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_VERTICAL_FIRST);
				k = -1;
			}
		}
	}
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* box;
	
	clutter_init(&argc, &argv);
	
//	tangle_actor_set_default_transition_mode(CLUTTER_EASE_OUT_SINE);
//	tangle_actor_set_default_transition_duration(250);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

	box = tangle_widget_new();
	tangle_widget_set_layout(TANGLE_WIDGET(box), tangle_box_layout_new());
//	g_object_set(G_OBJECT(box), "width", 600.0, "height", 100.0, NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), CLUTTER_ACTOR(box));

	g_signal_connect(stage, "button_press_event", G_CALLBACK(add_actor), box);

	clutter_actor_show_all(stage);

	clutter_main();

	return 0;
}
