/*
 * tangle-layout-meta.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-layout-meta.h"

/**
 * SECTION:tangle-layout-meta
 * @Short_description: 	A base class for meta information about relation of an actor and a layout manager
 * @Title: TangleLayoutMeta
 */

G_DEFINE_ABSTRACT_TYPE(TangleLayoutMeta, tangle_layout_meta, G_TYPE_OBJECT);

enum {
	PROP_0,
	PROP_LAYOUT,
	PROP_ACTOR
};

struct _TangleLayoutMetaPrivate {
	TangleLayout* layout;
	ClutterActor* actor;
};

TangleLayout* tangle_layout_meta_get_layout(TangleLayoutMeta* layout_meta) {

	return layout_meta->priv->layout;
}

ClutterActor* tangle_layout_meta_get_actor(TangleLayoutMeta* layout_meta) {

	return layout_meta->priv->actor;
}


static void tangle_layout_meta_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	TangleLayoutMeta* layout_meta;
	
	layout_meta = TANGLE_LAYOUT_META(object);

	switch (prop_id) {
		case PROP_LAYOUT:
			layout_meta->priv->layout = g_value_get_object(value);
			g_object_add_weak_pointer(G_OBJECT(layout_meta->priv->layout), (gpointer*)&layout_meta->priv->layout);
			break;
		case PROP_ACTOR:
			layout_meta->priv->actor = g_value_get_object(value);
			g_object_add_weak_pointer(G_OBJECT(layout_meta->priv->actor), (gpointer*)&layout_meta->priv->actor);
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void tangle_layout_meta_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
        TangleLayoutMeta* layout_meta;

	layout_meta = TANGLE_LAYOUT_META(object);

        switch (prop_id) {
		PROP_LAYOUT:
			g_value_set_object(value, layout_meta->priv->layout);
			break;
		PROP_ACTOR:
			g_value_set_object(value, layout_meta->priv->actor);
			break;
	        default:
		        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		        break;
        }
}

static void tangle_layout_meta_dispose(GObject* object) {
	TangleLayoutMeta* layout_meta;
	
	layout_meta = TANGLE_LAYOUT_META(object);

	g_object_remove_weak_pointer(G_OBJECT(layout_meta->priv->layout), (gpointer*)&layout_meta->priv->layout);
	g_object_remove_weak_pointer(G_OBJECT(layout_meta->priv->actor), (gpointer*)&layout_meta->priv->actor);
	G_OBJECT_CLASS(tangle_layout_meta_parent_class)->dispose(object);
}

static void tangle_layout_meta_class_init(TangleLayoutMetaClass* klass) {
	GObjectClass* gobject_class = G_OBJECT_CLASS(klass);

	gobject_class->dispose = tangle_layout_meta_dispose;
	gobject_class->set_property = tangle_layout_meta_set_property;
	gobject_class->get_property = tangle_layout_meta_get_property;

	/**
	 * TangleLayoutMeta:layout:
	 */
	g_object_class_install_property(gobject_class, PROP_LAYOUT,
	                                g_param_spec_object("layout",
	                                "Layout",
	                                "The layout that has instantiated this object",
	                                TANGLE_TYPE_LAYOUT,
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK |G_PARAM_STATIC_BLURB));
	/**
	 * TangleLayoutMeta:actor:
	 */
	g_object_class_install_property(gobject_class, PROP_ACTOR,
	                                g_param_spec_object("actor",
	                                "Actor",
	                                "The actor that is connected to this object",
	                                CLUTTER_TYPE_ACTOR,
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK |G_PARAM_STATIC_BLURB));

	g_type_class_add_private (gobject_class, sizeof (TangleLayoutMetaPrivate));
}

static void tangle_layout_meta_init(TangleLayoutMeta* layout_meta) {
	layout_meta->priv = G_TYPE_INSTANCE_GET_PRIVATE(layout_meta, TANGLE_TYPE_LAYOUT_META, TangleLayoutMetaPrivate);
}

