/*
 * tangle-view.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_VIEW_H__
#define __TANGLE_VIEW_H__

#include "tangle-widget.h"

#define TANGLE_TYPE_VIEW (tangle_view_get_type ())
#define TANGLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_VIEW, TangleView))
#define TANGLE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_VIEW))
#define TANGLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TANGLE_TYPE_VIEW, TangleViewClass))
#define TANGLE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TANGLE_TYPE_VIEW))
#define TANGLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TANGLE_TYPE_VIEW, TangleViewClass))

typedef struct _TangleViewPrivate TangleViewPrivate;

typedef struct _TangleView {
	TangleWidget parent_instance;
	TangleViewPrivate* priv;
} TangleView;

typedef struct _TangleViewClass {
	TangleWidgetClass parent_class;
} TangleViewClass;

GType tangle_view_get_type(void);

ClutterActor* tangle_view_new();
ClutterActor* tangle_view_new_with_parent(TangleWidget* parent);
ClutterActor* tangle_view_new_with_layout(TangleLayout* layout);

void tangle_view_set_filename(TangleView* view, const gchar* filename);
const gchar* tangle_view_get_filename(TangleView* view);
ClutterScript* tangle_view_get_script(TangleView* view);

void tangle_view_load_now(TangleView* view);

void tangle_view_start_timelines(TangleView* view);
void tangle_view_stop_timelines(TangleView* view);

#endif
