/*
 * tangle-widget.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_WIDGET_H__
#define __TANGLE_WIDGET_H__

#include "tangle-actor.h"

#define TANGLE_TYPE_WIDGET (tangle_widget_get_type())
#define TANGLE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_WIDGET, TangleWidget))
#define TANGLE_IS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_WIDGET))
#define TANGLE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_WIDGET, TangleWidgetClass))
#define TANGLE_IS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_WIDGET))
#define TANGLE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_WIDGET, TangleWidgetClass))

typedef struct _TangleWidgetPrivate TangleWidgetPrivate;
typedef struct _TangleWidget TangleWidget;
typedef struct _TangleWidgetClass TangleWidgetClass;

#include "tangle-event.h"

struct _TangleWidget {
	TangleActor parent_instance;
	TangleWidgetPrivate* priv;
};

struct _TangleWidgetClass {
	TangleActorClass parent_class;
};

typedef void (*TangleSwappedCallback)(gpointer data, ClutterActor* actor);
#define TANGLE_SWAPPED_CALLBACK(f) ((TangleSwappedCallback)(f))

GType tangle_widget_get_type(void) G_GNUC_CONST;

#include "tangle-style.h"
#include "tangle-layout.h"

ClutterActor* tangle_widget_new(void);
ClutterActor* tangle_widget_new_with_layout(TangleLayout* layout);
ClutterActor* tangle_widget_new_with_parent(TangleWidget* parent);

guint tangle_widget_get_n_children(TangleWidget* widget);
ClutterActor* tangle_widget_get_nth_child(TangleWidget* widget, guint n);
gboolean tangle_widget_has_child(TangleWidget* widget, ClutterActor* actor);
GList* tangle_widget_get_children_readonly(TangleWidget* widget);
void tangle_widget_foreach_swapped(TangleWidget* widget, TangleSwappedCallback swapped_callback, gpointer user_data);
void tangle_widget_foreach_type(TangleWidget* widget, GType type, ClutterCallback callback, gpointer user_data);
void tangle_widget_foreach_type(TangleWidget* widget, GType type, ClutterCallback callback, gpointer user_data);
void tangle_widget_foreach_type_swapped(TangleWidget* widget, GType type, TangleSwappedCallback swapped_callback, gpointer user_data);

void tangle_widget_add_before(TangleWidget* widget, ClutterActor* actor, ClutterActor* existing, const gchar* first_property, ...) G_GNUC_NULL_TERMINATED;
void tangle_widget_add_after(TangleWidget* widget, ClutterActor* actor, ClutterActor* existing, const gchar* first_property, ...) G_GNUC_NULL_TERMINATED;

void tangle_widget_set_layout(TangleWidget* widget, TangleLayout* layout);
TangleLayout* tangle_widget_get_layout(TangleWidget* widget);

void tangle_widget_get_padding(TangleWidget* widget, TangleSpacing* spacing);
void tangle_widget_set_padding(TangleWidget* widget, const TangleSpacing* spacing);
gboolean tangle_widget_get_padding_set(TangleWidget* widget);
void tangle_widget_set_padding_set(TangleWidget* widget, gboolean is_set);

void tangle_widget_get_background_color(TangleWidget* widget, ClutterColor* color);
gboolean tangle_widget_get_background_color_set(TangleWidget* widget);
void tangle_widget_set_background_color(TangleWidget* widget, const ClutterColor* color);

ClutterActor* tangle_widget_get_background_actor(TangleWidget* widget);
void tangle_widget_set_background_actor(TangleWidget* widget, ClutterActor* actor);

gboolean tangle_widget_get_prefer_background_size(TangleWidget* widget);
void tangle_widget_set_prefer_background_size(TangleWidget* widget, gboolean prefer_background_size);



#endif
