/*
 * tangle-linear-gradient.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_LINEAR_GRADIENT_H__
#define __TANGLE_LINEAR_GRADIENT_H__

#include "tangle-actor.h"

#define TANGLE_TYPE_LINEAR_GRADIENT (tangle_linear_gradient_get_type())
#define TANGLE_LINEAR_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_LINEAR_GRADIENT, TangleLinearGradient))
#define TANGLE_IS_LINEAR_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_LINEAR_GRADIENT))
#define TANGLE_LINEAR_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_LINEAR_GRADIENT, TangleLinearGradientClass))
#define TANGLE_IS_LINEAR_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_LINEAR_GRADIENT))
#define TANGLE_LINEAR_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_LINEAR_GRADIENT, TangleLinearGradientClass))

typedef struct _TangleLinearGradientPrivate TangleLinearGradientPrivate;

typedef struct _TangleLinearGradient {
	TangleActor parent_instance;
	TangleLinearGradientPrivate* priv;
} TangleLinearGradient;

typedef struct _TangleLinearGradientClass {
	TangleActorClass parent_class;
} TangleLinearGradientClass;

GType tangle_linear_gradient_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_linear_gradient_new(ClutterColor* start_color, ClutterColor* end_color);

void tangle_linear_gradient_get_start_color(TangleLinearGradient* linear_gradient, ClutterColor* color);
void tangle_linear_gradient_set_start_color(TangleLinearGradient* linear_gradient, const ClutterColor* color);
void tangle_linear_gradient_get_end_color(TangleLinearGradient* linear_gradient, ClutterColor* color);
void tangle_linear_gradient_set_end_color(TangleLinearGradient* linear_gradient, const ClutterColor* color);

gfloat tangle_linear_gradient_get_angle(TangleLinearGradient* linear_gradient);
void tangle_linear_gradient_set_angle(TangleLinearGradient* linear_gradient, gfloat angle);
/*
guint tangle_linear_gradient_add_stop(TangleLinearGradient* linear_gradient, gfloat offset, ClutterColor* color);
void tangle_linear_gradient_remove_stop(TangleLinearGradient* linear_gradient, guint stop_id);
*/

#endif
