/*
 * tangle-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_ACTION_H__
#define __TANGLE_ACTION_H__

#include <glib-object.h>
#include "tangle-properties.h"

#define TANGLE_TYPE_ACTION (tangle_action_get_type ())
#define TANGLE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_ACTION, TangleAction))
#define TANGLE_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_ACTION))
#define TANGLE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TANGLE_TYPE_ACTION, TangleActionClass))
#define TANGLE_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TANGLE_TYPE_ACTION))
#define TANGLE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TANGLE_TYPE_ACTION, TangleActionClass))

typedef struct _TangleActionPrivate TangleActionPrivate;

typedef struct _TangleAction {
	GObject parent_instance;
	
	TangleActionPrivate* priv;
} TangleAction;

typedef struct _TangleActionClass {
	GObjectClass parent_class;
	
	void (*execute)(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties);
} TangleActionClass;

GType tangle_action_get_type(void);

typedef void (*TangleActionFunction)(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties);

#include "tangle-actor.h"

void tangle_action_execute(TangleAction* action);
void tangle_action_execute_full(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties);
void tangle_action_set_next_action(TangleAction* action, TangleAction* next_action);
TangleAction* tangle_action_get_next_action(TangleAction* action);
void tangle_action_add(TangleAction* action, GObject* object, const char* name);
void tangle_action_remove(TangleAction* action, GObject* object, const char* name);



#endif
