/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedAdapter;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int V_SCROLL_RATE = 50;
    static final int H_SCROLL_RATE = 10;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    static final int PaintObject = 3008;
    static final int WordNext = 3009;
    static final int WordPrevious = 3010;
    static final int CaretMoved = 3011;
    static final int PREVIOUS_OFFSET_TRAILING = 0;
    static final int OFFSET_LEADING = 1;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent content;
    StyledTextRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int topIndexY;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int tabLength = 4;
    int[] tabs;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    Color marginColor;
    int columnX;
    int caretOffset;
    int caretAlignment;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    int clickCount;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    int lastCharCount = 0;
    int lastLineBottom;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    int caretWidth = 0;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    boolean fixedLineHeight;
    boolean dragDetect = true;
    IME ime;
    Cursor cursor;
    int alignment;
    boolean justify;
    int indent;
    int wrapIndent;
    int lineSpacing;
    int alignmentMargin;
    int newOrientation = 0;
    int accCaretOffset;
    boolean blockSelection;
    int blockXAnchor = -1;
    int blockYAnchor = -1;
    int blockXLocation = -1;
    int blockYLocation = -1;
    static final boolean IS_MAC;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;

    public StyledText(Composite composite, int n) {
        super(composite, StyledText.checkStyle(n));
        super.setForeground(this.getForeground());
        super.setDragDetect(false);
        Display display = this.getDisplay();
        this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        this.fixedLineHeight = true;
        if ((n & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((n & 4) != 0 && (n & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.alignment = n & 0x1024000;
        if (this.alignment == 0) {
            this.alignment = 16384;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.renderer = new StyledTextRenderer(this.getDisplay(), this);
        this.renderer.setContent(this.content);
        this.renderer.setFont(this.getFont(), this.tabLength);
        this.ime = new IME(this, 0);
        this.defaultCaret = new Caret(this, 0);
        if ((n & 0x40) != 0) {
            this.setWordWrap(true);
        }
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n;
                    int n2 = n = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                    if (n == StyledText.this.caretDirection) {
                        return;
                    }
                    if (StyledText.this.getCaret() != StyledText.this.defaultCaret) {
                        return;
                    }
                    Point point = StyledText.this.getPointAtOffset(StyledText.this.caretOffset);
                    StyledText.this.setCaretLocation(point, n);
                }
            };
            BidiUtil.addLanguageListener(this, runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        super.setCursor(display.getSystemCursor(19));
        this.installListeners();
        this.initializeAccessible();
        this.setData("DEFAULT_DROP_TARGET_EFFECT", new StyledTextDropTargetEffect(this));
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.addListener(3007, new StyledTextListener(bidiSegmentListener));
    }

    public void addCaretListener(CaretListener caretListener) {
        this.checkWidget();
        if (caretListener == null) {
            SWT.error(4);
        }
        this.addListener(3011, new StyledTextListener(caretListener));
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3001)) {
            this.renderer.clearLineBackground(0, this.content.getLineCount());
        }
        this.addListener(3001, new StyledTextListener(lineBackgroundListener));
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3002)) {
            this.setStyleRanges(0, 0, null, null, true);
            this.renderer.clearLineStyle(0, this.content.getLineCount());
        }
        this.addListener(3002, new StyledTextListener(lineStyleListener));
        this.setCaretLocation();
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.addListener(24, new TypedListener(modifyListener));
    }

    public void addPaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.addListener(3008, new StyledTextListener(paintObjectListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.addListener(13, new TypedListener(selectionListener));
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.addListener(3005, new StyledTextListener(verifyKeyListener));
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.addListener(25, new TypedListener(verifyListener));
    }

    public void addWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (this.listener == null) {
            SWT.error(4);
        }
        this.addListener(3009, new StyledTextListener(movementListener));
        this.addListener(3010, new StyledTextListener(movementListener));
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n, 0, string);
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars(true);
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex(int n) {
        int n2 = this.topIndex;
        int n3 = this.topIndexY;
        if (this.isFixedLineHeight()) {
            int n4 = this.getVerticalIncrement();
            if (n4 == 0) {
                return;
            }
            this.topIndex = Compatibility.ceil(this.getVerticalScrollOffset(), n4);
            if (this.topIndex > 0) {
                if (this.clientAreaHeight > 0) {
                    int n5;
                    int n6 = this.getVerticalScrollOffset() + this.clientAreaHeight;
                    int n7 = n6 - (n5 = this.topIndex * n4);
                    if (n7 < n4) {
                        --this.topIndex;
                    }
                } else if (this.topIndex >= this.content.getLineCount()) {
                    this.topIndex = this.content.getLineCount() - 1;
                }
            }
        } else if (n >= 0) {
            n -= this.topIndexY;
            int n8 = this.topIndex;
            int n9 = this.content.getLineCount();
            while (n8 < n9 && n > 0) {
                n -= this.renderer.getLineHeight(n8++);
            }
            if (n8 < n9 && -n + this.renderer.getLineHeight(n8) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n8;
                this.topIndexY = -n;
            } else {
                this.topIndex = n8 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n;
            }
        } else {
            int n10;
            int n11;
            n -= this.topIndexY;
            for (n11 = this.topIndex; n11 > 0 && n + (n10 = this.renderer.getLineHeight(n11 - 1)) <= 0; --n11) {
                n += n10;
            }
            if (n11 == 0 || -n + this.renderer.getLineHeight(n11) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n11;
                this.topIndexY = -n;
            } else {
                this.topIndex = n11 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n;
            }
        }
        if (this.topIndex != n2 || n3 != this.topIndexY) {
            this.renderer.calculateClientArea();
            this.setScrollBars(false);
        }
    }

    static int checkStyle(int n) {
        if ((n & 4) != 0) {
            n &= 0xFFFFFCBD;
        } else if (((n |= 2) & 0x40) != 0) {
            n &= 0xFFFFFEFF;
        }
        return (n |= 0x20140000) & 0xFEFFFFFF;
    }

    void claimBottomFreeSpace() {
        if (this.ime.getCompositionOffset() != -1) {
            return;
        }
        if (this.isFixedLineHeight()) {
            int n = Math.max(0, this.renderer.getHeight() - this.clientAreaHeight);
            if (n < this.getVerticalScrollOffset()) {
                this.scrollVertical(n - this.getVerticalScrollOffset(), true);
            }
        } else {
            int n = this.getPartialBottomIndex();
            int n2 = this.getLinePixel(n + 1);
            if (this.clientAreaHeight > n2) {
                this.scrollVertical(-this.getAvailableHeightAbove(this.clientAreaHeight - n2), true);
            }
        }
    }

    void claimRightFreeSpace() {
        int n = Math.max(0, this.renderer.getWidth() - this.clientAreaWidth);
        if (n < this.horizontalScrollOffset) {
            this.scrollHorizontal(n - this.horizontalScrollOffset, true);
        }
    }

    void clearBlockSelection(boolean bl, boolean bl2) {
        if (bl) {
            this.resetSelection();
        }
        this.blockYAnchor = -1;
        this.blockXAnchor = -1;
        this.blockYLocation = -1;
        this.blockXLocation = -1;
        this.caretDirection = 0;
        this.updateCaretVisibility();
        super.redraw();
        if (bl2) {
            this.sendSelectionEvent();
        }
    }

    void clearSelection(boolean bl) {
        int n = this.selection.x;
        int n2 = this.selection.y;
        this.resetSelection();
        if (n2 - n > 0) {
            int n3 = this.content.getCharCount();
            int n4 = Math.min(n, n3);
            int n5 = Math.min(n2, n3);
            if (n5 - n4 > 0) {
                this.internalRedrawRange(n4, n5 - n4);
            }
            if (bl) {
                this.sendSelectionEvent();
            }
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = (this.getStyle() & 4) != 0 ? 1 : this.content.getLineCount();
        int n5 = 0;
        int n6 = 0;
        if (n == -1 || n2 == -1) {
            Display display = this.getDisplay();
            n3 = display.getClientArea().height;
            for (int i = 0; i < n4; ++i) {
                TextLayout textLayout = this.renderer.getTextLayout(i);
                int n7 = textLayout.getWidth();
                if (this.wordWrap) {
                    textLayout.setWidth(n == 0 ? 1 : n);
                }
                Rectangle rectangle = textLayout.getBounds();
                n5 = Math.max(n5, rectangle.width);
                textLayout.setWidth(n7);
                this.renderer.disposeTextLayout(textLayout);
                if (this.isFixedLineHeight() && (n6 += rectangle.height) > n3) break;
            }
            if (this.isFixedLineHeight()) {
                n6 = n4 * this.renderer.getLineHeight();
            }
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        int n8 = this.leftMargin + this.rightMargin + this.getCaretWidth();
        n3 = this.topMargin + this.bottomMargin;
        Rectangle rectangle = this.computeTrim(0, 0, n5 + n8, n6 + n3);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        this.copySelection(1);
    }

    public void copy(int n) {
        this.checkWidget();
        this.copySelection(n);
    }

    boolean copySelection(int n) {
        block7: {
            if (n != 1 && n != 2) {
                return false;
            }
            try {
                if (this.blockSelection && this.blockXLocation != -1) {
                    String string = this.getBlockSelectionText(PlatformLineDelimiter);
                    if (string.length() > 0) {
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        Object[] objectArray = new Object[]{string};
                        Transfer[] transferArray = new Transfer[]{textTransfer};
                        this.clipboard.setContents(objectArray, transferArray, n);
                        return true;
                    }
                } else {
                    int n2 = this.selection.y - this.selection.x;
                    if (n2 > 0) {
                        this.setClipboardContent(this.selection.x, n2, n);
                        return true;
                    }
                }
            }
            catch (SWTError sWTError) {
                if (sWTError.code == 2002) break block7;
                throw sWTError;
            }
        }
        return false;
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    int getAvailableHeightAbove(int n) {
        int n2 = this.verticalScrollOffset;
        if (n2 == -1) {
            int n3 = this.topIndex - 1;
            n2 = -this.topIndexY;
            if (this.topIndexY > 0) {
                n2 += this.renderer.getLineHeight(n3--);
            }
            while (n > n2 && n3 >= 0) {
                n2 += this.renderer.getLineHeight(n3--);
            }
        }
        return Math.min(n, n2);
    }

    int getAvailableHeightBellow(int n) {
        int n2 = this.getPartialBottomIndex();
        int n3 = this.getLinePixel(n2);
        int n4 = this.renderer.getLineHeight(n2);
        int n5 = 0;
        int n6 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n3 + n4 > n6) {
            n5 = n4 - (n6 - n3);
        }
        int n7 = n2 + 1;
        int n8 = this.content.getLineCount();
        while (n > n5 && n7 < n8) {
            n5 += this.renderer.getLineHeight(n7++);
        }
        return Math.min(n, n5);
    }

    public Color getMarginColor() {
        this.checkWidget();
        return this.marginColor != null ? this.marginColor : this.getBackground();
    }

    String getModelDelimitedText(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        String string2 = this.getLineDelimiter();
        while (n4 < n) {
            if (n2 != -1) {
                n2 = string.indexOf(13, n4);
            }
            if (n3 != -1) {
                n3 = string.indexOf(10, n4);
            }
            if (n3 == -1 && n2 == -1) break;
            if (n2 < n3 && n2 != -1 || n3 == -1) {
                stringBuffer.append(string.substring(n4, n2));
                n4 = n3 == n2 + 1 ? n3 + 1 : n2 + 1;
            } else {
                stringBuffer.append(string.substring(n4, n3));
                n4 = n3 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n4 >= n || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    boolean checkDragDetect(Event event) {
        if (!this.isListening(29)) {
            return false;
        }
        if (IS_MOTIF ? event.button != 2 : event.button != 1) {
            return false;
        }
        if (this.blockSelection && this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionRectangle();
            if (rectangle.contains(event.x, event.y)) {
                return this.dragDetect(event);
            }
        } else {
            if (this.selection.x == this.selection.y) {
                return false;
            }
            int n = this.getOffsetAtPoint(event.x, event.y, null, true);
            if (this.selection.x <= n && n < this.selection.y) {
                return this.dragDetect(event);
            }
        }
        return false;
    }

    void createKeyBindings() {
        int n = this.isMirrored() ? 0x1000003 : 0x1000004;
        int n2 = this.isMirrored() ? 0x1000004 : 0x1000003;
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        if (IS_MAC) {
            this.setKeyBinding(n2 | SWT.MOD1, 0x1000007);
            this.setKeyBinding(n | SWT.MOD1, 0x1000008);
            this.setKeyBinding(0x1000007, 17039367);
            this.setKeyBinding(0x1000008, 17039368);
            this.setKeyBinding(0x1000001 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000002 | SWT.MOD1, 17039368);
            this.setKeyBinding(n | SWT.MOD3, 0x1040004);
            this.setKeyBinding(n2 | SWT.MOD3, 17039363);
        } else {
            this.setKeyBinding(0x1000007, 0x1000007);
            this.setKeyBinding(0x1000008, 0x1000008);
            this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
            this.setKeyBinding(n | SWT.MOD1, 0x1040004);
            this.setKeyBinding(n2 | SWT.MOD1, 17039363);
        }
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        this.setKeyBinding(n, 0x1000004);
        this.setKeyBinding(n2, 0x1000003);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        if (IS_MAC) {
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 16908295);
            this.setKeyBinding(n | SWT.MOD1 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 17170440);
            this.setKeyBinding(0x1000001 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000002 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n | SWT.MOD2 | SWT.MOD3, 17170436);
            this.setKeyBinding(n2 | SWT.MOD2 | SWT.MOD3, 17170435);
        } else {
            this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 17170435);
        }
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        this.setKeyBinding(n | SWT.MOD2, 16908292);
        this.setKeyBinding(n2 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        if (IS_MAC) {
            this.setKeyBinding(0x7F | SWT.MOD2, 127);
            this.setKeyBinding(8 | SWT.MOD3, 262152);
            this.setKeyBinding(0x7F | SWT.MOD3, 262271);
        } else {
            this.setKeyBinding(0x7F | SWT.MOD2, 131199);
            this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
            this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        }
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        int n2 = this.renderer.getLineHeight();
        this.leftCaretBitmap = new Image((Device)display, n, n2);
        GC gC = new GC(this.leftCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, n2);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, n, n2);
        gC = new GC(this.rightCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n - 1, 0, n - 1, n2);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(n - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        if (this.copySelection(1)) {
            if (this.blockSelection && this.blockXLocation != -1) {
                this.insertBlockSelectionText('\u0000', 0);
            } else {
                this.doDelete();
            }
        }
    }

    void doAutoScroll(Event event) {
        int n = this.getCaretLine();
        if (event.y > this.clientAreaHeight - this.bottomMargin && n != this.content.getLineCount() - 1) {
            this.doAutoScroll(1024, event.y - (this.clientAreaHeight - this.bottomMargin));
        } else if (event.y < this.topMargin && n != 0) {
            this.doAutoScroll(128, this.topMargin - event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > this.clientAreaWidth - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (this.clientAreaWidth - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n, int n2) {
        this.autoScrollDistance = n2;
        if (this.autoScrollDirection == n) {
            return;
        }
        Runnable runnable = null;
        final Display display = this.getDisplay();
        if (n == 128) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        if (StyledText.this.blockSelection) {
                            int n = StyledText.this.getVerticalScrollOffset();
                            int n2 = StyledText.this.blockYLocation - n;
                            int n3 = Math.max(-StyledText.this.autoScrollDistance, -n);
                            if (n3 != 0) {
                                StyledText.this.setBlockSelectionLocation(StyledText.this.blockXLocation - StyledText.this.horizontalScrollOffset, n2 + n3, true);
                                StyledText.this.scrollVertical(n3, true);
                            }
                        } else {
                            StyledText.this.doSelectionPageUp(StyledText.this.autoScrollDistance);
                        }
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(50, runnable);
        } else if (n == 1024) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        if (StyledText.this.blockSelection) {
                            int n = StyledText.this.getVerticalScrollOffset();
                            int n2 = StyledText.this.blockYLocation - n;
                            int n3 = StyledText.this.renderer.getHeight() - n - StyledText.this.clientAreaHeight;
                            int n4 = Math.min(StyledText.this.autoScrollDistance, Math.max(0, n3));
                            if (n4 != 0) {
                                StyledText.this.setBlockSelectionLocation(StyledText.this.blockXLocation - StyledText.this.horizontalScrollOffset, n2 + n4, true);
                                StyledText.this.scrollVertical(n4, true);
                            }
                        } else {
                            StyledText.this.doSelectionPageDown(StyledText.this.autoScrollDistance);
                        }
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(50, runnable);
        } else if (n == 0x1000004) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        if (StyledText.this.blockSelection) {
                            int n = StyledText.this.blockXLocation - StyledText.this.horizontalScrollOffset;
                            int n2 = StyledText.this.renderer.getWidth() - StyledText.this.horizontalScrollOffset - StyledText.this.clientAreaWidth;
                            int n3 = Math.min(StyledText.this.autoScrollDistance, Math.max(0, n2));
                            if (n3 != 0) {
                                StyledText.this.setBlockSelectionLocation(n + n3, StyledText.this.blockYLocation - StyledText.this.getVerticalScrollOffset(), true);
                                StyledText.this.scrollHorizontal(n3, true);
                            }
                        } else {
                            StyledText.this.doVisualNext();
                            StyledText.this.setMouseWordSelectionAnchor();
                            StyledText.this.doMouseSelection();
                        }
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(10, runnable);
        } else if (n == 0x1000003) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        if (StyledText.this.blockSelection) {
                            int n = StyledText.this.blockXLocation - StyledText.this.horizontalScrollOffset;
                            int n2 = Math.max(-StyledText.this.autoScrollDistance, -StyledText.this.horizontalScrollOffset);
                            if (n2 != 0) {
                                StyledText.this.setBlockSelectionLocation(n + n2, StyledText.this.blockYLocation - StyledText.this.getVerticalScrollOffset(), true);
                                StyledText.this.scrollHorizontal(n2, true);
                            }
                        } else {
                            StyledText.this.doVisualPrevious();
                            StyledText.this.setMouseWordSelectionAnchor();
                            StyledText.this.doMouseSelection();
                        }
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(10, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n = this.content.getLineAtOffset(this.caretOffset);
            int n2 = this.content.getOffsetAtLine(n);
            if (this.caretOffset == n2) {
                n2 = this.content.getOffsetAtLine(n - 1);
                event.start = n2 + this.content.getLine(n - 1).length();
                event.end = this.caretOffset;
            } else {
                boolean bl = false;
                String string = this.content.getLine(n);
                char c = string.charAt(this.caretOffset - n2 - 1);
                if ('\udc00' <= c && c <= '\udfff' && this.caretOffset - n2 - 2 >= 0) {
                    c = string.charAt(this.caretOffset - n2 - 2);
                    bl = '\ud800' <= c && c <= '\udbff';
                }
                TextLayout textLayout = this.renderer.getTextLayout(n);
                int n3 = textLayout.getPreviousOffset(this.caretOffset - n2, bl ? 2 : 1);
                this.renderer.disposeTextLayout(textLayout);
                event.start = n3 + n2;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doBlockColumn(boolean bl) {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        int n5;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        if ((n5 = this.getOffsetAtPoint(n4 = this.blockXLocation - this.horizontalScrollOffset, n3 = this.blockYLocation - this.getVerticalScrollOffset(), nArray = new int[1], true)) != -1) {
            n2 = this.content.getLineAtOffset(n5 += nArray[0]);
            n = bl ? this.getClusterNext(n5, n2) : this.getClusterPrevious(n5, n2);
            int n6 = n5 = n != n5 ? n : -1;
        }
        if (n5 != -1) {
            this.setBlockSelectionOffset(n5, true);
            this.showCaret();
        } else {
            n2 = bl ? this.renderer.averageCharWidth : -this.renderer.averageCharWidth;
            n = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n4 = Math.max(0, Math.min(this.blockXLocation + n2, n)) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n4, n3, true);
            Rectangle rectangle = new Rectangle(n4, n3, 0, 0);
            this.showLocation(rectangle, true);
        }
    }

    void doBlockWord(boolean bl) {
        Object object;
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        int n5;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        if ((n5 = this.getOffsetAtPoint(n4 = this.blockXLocation - this.horizontalScrollOffset, n3 = this.blockYLocation - this.getVerticalScrollOffset(), nArray = new int[1], true)) != -1) {
            n2 = this.content.getLineAtOffset(n5 += nArray[0]);
            n = this.content.getOffsetAtLine(n2);
            object = this.content.getLine(n2);
            int n6 = ((String)object).length();
            int n7 = n5;
            if (bl) {
                if (n5 < n + n6) {
                    n7 = this.getWordNext(n5, 4);
                }
            } else if (n5 > n) {
                n7 = this.getWordPrevious(n5, 4);
            }
            int n8 = n5 = n7 != n5 ? n7 : -1;
        }
        if (n5 != -1) {
            this.setBlockSelectionOffset(n5, true);
            this.showCaret();
        } else {
            n2 = (bl ? this.renderer.averageCharWidth : -this.renderer.averageCharWidth) * 6;
            n = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n4 = Math.max(0, Math.min(this.blockXLocation + n2, n)) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n4, n3, true);
            object = new Rectangle(n4, n3, 0, 0);
            this.showLocation((Rectangle)object, true);
        }
    }

    void doBlockLineVertical(boolean bl) {
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        int n = this.blockYLocation - this.getVerticalScrollOffset();
        int n2 = this.getLineIndex(n);
        if (bl) {
            if (n2 > 0) {
                n = this.getLinePixel(n2 - 1);
                this.setBlockSelectionLocation(this.blockXLocation - this.horizontalScrollOffset, n, true);
                if (n < this.topMargin) {
                    this.scrollVertical(n - this.topMargin, true);
                }
            }
        } else {
            int n3 = this.content.getLineCount();
            if (n2 + 1 < n3) {
                n = this.getLinePixel(n2 + 2) - 1;
                this.setBlockSelectionLocation(this.blockXLocation - this.horizontalScrollOffset, n, true);
                int n4 = this.clientAreaHeight - this.bottomMargin;
                if (n > n4) {
                    this.scrollVertical(n - n4, true);
                }
            }
        }
    }

    void doBlockLineHorizontal(boolean bl) {
        int n;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        int n2 = this.blockXLocation - this.horizontalScrollOffset;
        int n3 = this.blockYLocation - this.getVerticalScrollOffset();
        int n4 = this.getLineIndex(n3);
        int n5 = this.content.getOffsetAtLine(n4);
        String string = this.content.getLine(n4);
        int n6 = string.length();
        int[] nArray = new int[1];
        int n7 = this.getOffsetAtPoint(n2, n3, nArray, true);
        if (n7 != -1) {
            n = n7 += nArray[0];
            if (bl) {
                if (n7 < n5 + n6) {
                    n = n5 + n6;
                }
            } else if (n7 > n5) {
                n = n5;
            }
            n7 = n != n7 ? n : -1;
        } else if (!bl) {
            n7 = n5 + n6;
        }
        if (n7 != -1) {
            this.setBlockSelectionOffset(n7, true);
            this.showCaret();
        } else {
            n = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n2 = (bl ? n : 0) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n2, n3, true);
            Rectangle rectangle = new Rectangle(n2, n3, 0, 0);
            this.showLocation(rectangle, true);
        }
    }

    void doBlockSelection(boolean bl) {
        if (this.caretOffset > this.selectionAnchor) {
            this.selection.x = this.selectionAnchor;
            this.selection.y = this.caretOffset;
        } else {
            this.selection.x = this.caretOffset;
            this.selection.y = this.selectionAnchor;
        }
        this.updateCaretVisibility();
        this.setCaretLocation();
        super.redraw();
        if (bl) {
            this.sendSelectionEvent();
        }
        this.sendAccessibleTextCaretMoved();
    }

    void doContent(char c) {
        if (this.blockSelection && this.blockXLocation != -1) {
            this.insertBlockSelectionText(c, 0);
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c == '\r' || c == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c != '\t') {
            String string;
            int n = this.content.getLineAtOffset(event.end);
            int n2 = this.content.getOffsetAtLine(n);
            if (event.end < n2 + (string = this.content.getLine(n)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c});
        } else {
            event.text = new String(new char[]{c});
        }
        if (event.text != null) {
            if (this.textLimit > 0 && this.content.getCharCount() - (event.end - event.start) >= this.textLimit) {
                return;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n = this.content.getCharCount();
            if (this.caretOffset < n) {
                this.setCaretOffset(n, -1);
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.setCaretOffset(0, -1);
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.x, 1);
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.y, 0);
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n;
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3 + (n = this.content.getLine(n2).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n2 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, n2);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordNext(this.caretOffset, 4);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordPrevious(this.caretOffset, 4);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    void doLineDown(boolean bl) {
        int n;
        int n2;
        int n3 = this.getCaretLine();
        int n4 = this.content.getLineCount();
        int n5 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            int n6;
            n2 = this.content.getOffsetAtLine(n3);
            n = this.caretOffset - n2;
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n7 = this.getVisualLineIndex(textLayout, n);
            if (n7 == (n6 = textLayout.getLineCount()) - 1) {
                bl2 = n3 == n4 - 1;
                ++n3;
            } else {
                n5 = textLayout.getLineBounds((int)(n7 + 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n3 == n4 - 1;
            ++n3;
        }
        if (bl2) {
            if (bl) {
                this.setCaretOffset(this.content.getCharCount(), -1);
            }
        } else {
            int[] nArray = new int[1];
            n = this.getOffsetAtPoint(this.columnX, n5, n3, nArray);
            this.setCaretOffset(n, nArray[0]);
        }
        n2 = this.columnX;
        n = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
            this.doSelection(0x1000004);
        }
        this.showCaret();
        int n8 = n - this.horizontalScrollOffset;
        this.columnX = n2 + n8;
    }

    void doLineEnd() {
        int n;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            int n4 = this.caretOffset - n3;
            int n5 = this.getVisualLineIndex(textLayout, n4);
            int[] nArray = textLayout.getLineOffsets();
            n = n3 + nArray[n5 + 1];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            int n6 = this.content.getLine(n2).length();
            n = n3 + n6;
        }
        if (this.caretOffset < n) {
            this.setCaretOffset(n, 0);
            this.showCaret();
        }
    }

    void doLineStart() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n);
            int n3 = this.caretOffset - n2;
            int n4 = this.getVisualLineIndex(textLayout, n3);
            int[] nArray = textLayout.getLineOffsets();
            n2 += nArray[n4];
            this.renderer.disposeTextLayout(textLayout);
        }
        if (this.caretOffset > n2) {
            this.setCaretOffset(n2, 1);
            this.showCaret();
        }
    }

    void doLineUp(boolean bl) {
        int n;
        int n2;
        int n3 = this.getCaretLine();
        int n4 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            n2 = this.content.getOffsetAtLine(n3);
            n = this.caretOffset - n2;
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n5 = this.getVisualLineIndex(textLayout, n);
            if (n5 == 0) {
                boolean bl3 = bl2 = n3 == 0;
                if (!bl2) {
                    n4 = this.renderer.getLineHeight(--n3) - 1;
                }
            } else {
                n4 = textLayout.getLineBounds((int)(n5 - 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n3 == 0;
            --n3;
        }
        if (bl2) {
            if (bl) {
                this.setCaretOffset(0, -1);
            }
        } else {
            int[] nArray = new int[1];
            n = this.getOffsetAtPoint(this.columnX, n4, n3, nArray);
            this.setCaretOffset(n, nArray[0]);
        }
        n2 = this.columnX;
        n = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
        }
        this.showCaret();
        if (bl) {
            this.doSelection(0x1000003);
        }
        int n6 = n - this.horizontalScrollOffset;
        this.columnX = n2 + n6;
    }

    void doMouseLinkCursor() {
        Display display = this.getDisplay();
        Point point = display.getCursorLocation();
        point = display.map(null, (Control)this, point);
        this.doMouseLinkCursor(point.x, point.y);
    }

    void doMouseLinkCursor(int n, int n2) {
        int n3 = this.getOffsetAtPoint(n, n2, null, true);
        Display display = this.getDisplay();
        Cursor cursor = this.cursor;
        if (this.renderer.hasLink(n3)) {
            cursor = display.getSystemCursor(21);
        } else if (this.cursor == null) {
            int n4 = this.blockSelection ? 2 : 19;
            cursor = display.getSystemCursor(n4);
        }
        if (cursor != this.getCursor()) {
            super.setCursor(cursor);
        }
    }

    void doMouseLocationChange(int n, int n2, boolean bl) {
        boolean bl2;
        int[] nArray;
        int n3;
        int n4 = this.getLineIndex(n2);
        this.updateCaretDirection = true;
        if (this.blockSelection) {
            n = Math.max(this.leftMargin, Math.min(n, this.clientAreaWidth - this.rightMargin));
            n2 = Math.max(this.topMargin, Math.min(n2, this.clientAreaHeight - this.bottomMargin));
            if (this.doubleClickEnabled && this.clickCount > 1) {
                boolean bl3;
                boolean bl4 = bl3 = (this.clickCount & 1) == 0;
                if (bl3) {
                    Point point = this.getPointAtOffset(this.doubleClickSelection.x);
                    int[] nArray2 = new int[1];
                    int n5 = this.getOffsetAtPoint(n, n2, nArray2, true);
                    if (n5 != -1) {
                        if (n > point.x) {
                            n5 = this.getWordNext(n5 + nArray2[0], 8);
                            this.setBlockSelectionOffset(this.doubleClickSelection.x, n5, true);
                        } else {
                            n5 = this.getWordPrevious(n5 + nArray2[0], 16);
                            this.setBlockSelectionOffset(this.doubleClickSelection.y, n5, true);
                        }
                    } else if (n > point.x) {
                        this.setBlockSelectionLocation(point.x, point.y, n, n2, true);
                    } else {
                        Point point2 = this.getPointAtOffset(this.doubleClickSelection.y);
                        this.setBlockSelectionLocation(point2.x, point2.y, n, n2, true);
                    }
                } else {
                    this.setBlockSelectionLocation(this.blockXLocation, n2, true);
                }
                return;
            }
            if (bl) {
                if (this.blockXLocation == -1) {
                    this.setBlockSelectionOffset(this.caretOffset, false);
                }
            } else {
                this.clearBlockSelection(true, false);
            }
            if ((n3 = this.getOffsetAtPoint(n, n2, nArray = new int[1], true)) != -1) {
                if (bl) {
                    this.setBlockSelectionOffset(n3 + nArray[0], true);
                    return;
                }
            } else {
                if (this.isFixedLineHeight() && this.renderer.fixedPitch) {
                    int n6 = this.renderer.averageCharWidth;
                    n = (n + n6 / 2 - this.leftMargin + this.horizontalScrollOffset) / n6 * n6 + this.leftMargin - this.horizontalScrollOffset;
                }
                this.setBlockSelectionLocation(n, n2, true);
                return;
            }
        }
        if (n4 < 0 || this.isSingleLine() && n4 > 0) {
            return;
        }
        nArray = new int[1];
        n3 = this.getOffsetAtPoint(n, n2, nArray);
        int n7 = nArray[0];
        if (this.doubleClickEnabled && this.clickCount > 1) {
            n3 = this.doMouseWordSelect(n, n3, n4);
        }
        int n8 = this.content.getLineAtOffset(n3);
        boolean bl5 = 0 <= n2 && n2 < this.clientAreaHeight || n8 == 0 || n8 == this.content.getLineCount() - 1;
        boolean bl6 = bl2 = 0 <= n && n < this.clientAreaWidth || this.wordWrap || n8 != this.content.getLineAtOffset(this.caretOffset);
        if (bl5 && bl2 && (n3 != this.caretOffset || n7 != this.caretAlignment)) {
            this.setCaretOffset(n3, n7);
            if (bl) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl) {
            this.setCaretOffset(n3, n7);
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n, int n2, int n3) {
        if (n2 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n2 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (0 <= n && n < this.clientAreaWidth) {
            boolean bl;
            boolean bl2 = bl = (this.clickCount & 1) == 0;
            if (this.caretOffset == this.selection.x) {
                n2 = bl ? this.getWordPrevious(n2, 16) : this.content.getOffsetAtLine(n3);
            } else if (bl) {
                n2 = this.getWordNext(n2, 8);
            } else {
                int n4 = this.content.getCharCount();
                if (n3 + 1 < this.content.getLineCount()) {
                    n4 = this.content.getOffsetAtLine(n3 + 1);
                }
                n2 = n4;
            }
        }
        return n2;
    }

    void doPageDown(boolean bl, int n) {
        int n2;
        if (this.isSingleLine()) {
            return;
        }
        int n3 = this.columnX;
        int n4 = this.horizontalScrollOffset;
        if (this.isFixedLineHeight()) {
            n2 = this.content.getLineCount();
            int n5 = this.getCaretLine();
            if (n5 < n2 - 1) {
                int n6 = this.renderer.getLineHeight();
                int n7 = (n == -1 ? this.clientAreaHeight : n) / n6;
                int n8 = Math.min(n2 - n5 - 1, n7);
                n8 = Math.max(1, n8);
                int[] nArray = new int[1];
                int n9 = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n5 + n8), nArray);
                this.setCaretOffset(n9, nArray[0]);
                if (bl) {
                    this.doSelection(0x1000004);
                }
                int n10 = n2 * this.getVerticalIncrement();
                int n11 = this.clientAreaHeight;
                int n12 = this.getVerticalScrollOffset();
                int n13 = n12 + n8 * this.getVerticalIncrement();
                if (n13 + n11 > n10) {
                    n13 = n10 - n11;
                }
                if (n13 > n12) {
                    this.scrollVertical(n13 - n12, true);
                }
            }
        } else {
            Rectangle rectangle;
            int n14;
            int n15;
            Object object;
            int n16;
            int n17;
            int n18;
            n2 = this.content.getLineCount();
            int n19 = this.getCaretLine();
            if (n == -1) {
                n18 = this.getPartialBottomIndex();
                n17 = this.getLinePixel(n18);
                n16 = this.renderer.getLineHeight(n18);
                n = n17;
                if (n17 + n16 <= this.clientAreaHeight) {
                    n += n16;
                } else if (this.wordWrap) {
                    object = this.renderer.getTextLayout(n18);
                    n15 = this.clientAreaHeight - n17;
                    for (n14 = 0; n14 < ((TextLayout)object).getLineCount(); ++n14) {
                        rectangle = ((TextLayout)object).getLineBounds(n14);
                        if (!rectangle.contains(rectangle.x, n15)) continue;
                        n += rectangle.y;
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                }
            } else {
                n18 = this.getLineIndex(n);
                n17 = this.getLinePixel(n18);
                if (this.wordWrap) {
                    object = this.renderer.getTextLayout(n18);
                    n15 = n - n17;
                    for (n14 = 0; n14 < ((TextLayout)object).getLineCount(); ++n14) {
                        rectangle = ((TextLayout)object).getLineBounds(n14);
                        if (!rectangle.contains(rectangle.x, n15)) continue;
                        n = n17 + rectangle.y + rectangle.height;
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                } else {
                    n = n17 + this.renderer.getLineHeight(n18);
                }
            }
            n17 = n;
            if (this.wordWrap) {
                object = this.renderer.getTextLayout(n19);
                n15 = this.caretOffset - this.content.getOffsetAtLine(n19);
                n18 = this.getVisualLineIndex((TextLayout)object, n15);
                n17 += ((TextLayout)object).getLineBounds((int)n18).y;
                this.renderer.disposeTextLayout((TextLayout)object);
            }
            n18 = n19;
            n16 = this.renderer.getLineHeight(n18);
            while (n17 - n16 >= 0 && n18 < n2 - 1) {
                n17 -= n16;
                n16 = this.renderer.getLineHeight(++n18);
            }
            object = new int[1];
            n15 = this.getOffsetAtPoint(this.columnX, n17, n18, (int[])object);
            this.setCaretOffset(n15, (int)object[0]);
            if (bl) {
                this.doSelection(0x1000004);
            }
            n = this.getAvailableHeightBellow(n);
            this.scrollVertical(n, true);
            if (n == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n2 = n4 - this.horizontalScrollOffset;
        this.columnX = n3 + n2;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n;
            if (this.wordWrap) {
                int n2;
                int n3 = this.getPartialBottomIndex();
                TextLayout textLayout = this.renderer.getTextLayout(n3);
                int n4 = this.clientAreaHeight - this.bottomMargin - this.getLinePixel(n3);
                for (n2 = textLayout.getLineCount() - 1; n2 >= 0; --n2) {
                    Rectangle rectangle = textLayout.getLineBounds(n2);
                    if (n4 >= rectangle.y + rectangle.height) break;
                }
                n = n2 == -1 && n3 > 0 ? this.content.getOffsetAtLine(n3 - 1) + this.content.getLine(n3 - 1).length() : this.content.getOffsetAtLine(n3) + Math.max(0, textLayout.getLineOffsets()[n2 + 1] - 1);
                this.renderer.disposeTextLayout(textLayout);
            } else {
                int n5 = this.getBottomIndex();
                n = this.content.getOffsetAtLine(n5) + this.content.getLine(n5).length();
            }
            if (this.caretOffset < n) {
                this.setCaretOffset(n, 1);
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n;
        if (this.wordWrap) {
            int n2;
            int n3;
            int n4;
            if (this.topIndexY > 0) {
                n4 = this.topIndex - 1;
                n3 = this.renderer.getLineHeight(n4) - this.topIndexY;
            } else {
                n4 = this.topIndex;
                n3 = -this.topIndexY;
            }
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n5 = textLayout.getLineCount();
            for (n2 = 0; n2 < n5; ++n2) {
                Rectangle rectangle = textLayout.getLineBounds(n2);
                if (n3 <= rectangle.y) break;
            }
            n = n2 == n5 ? this.content.getOffsetAtLine(n4 + 1) : this.content.getOffsetAtLine(n4) + textLayout.getLineOffsets()[n2];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            n = this.content.getOffsetAtLine(this.topIndex);
        }
        if (this.caretOffset > n) {
            this.setCaretOffset(n, 1);
            this.showCaret();
        }
    }

    void doPageUp(boolean bl, int n) {
        int n2;
        if (this.isSingleLine()) {
            return;
        }
        int n3 = this.horizontalScrollOffset;
        int n4 = this.columnX;
        if (this.isFixedLineHeight()) {
            n2 = this.getCaretLine();
            if (n2 > 0) {
                int n5;
                int n6;
                int n7 = this.renderer.getLineHeight();
                int n8 = (n == -1 ? this.clientAreaHeight : n) / n7;
                int n9 = Math.max(1, Math.min(n2, n8));
                int[] nArray = new int[1];
                int n10 = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n2 -= n9), nArray);
                this.setCaretOffset(n10, nArray[0]);
                if (bl) {
                    this.doSelection(0x1000003);
                }
                if ((n6 = Math.max(0, (n5 = this.getVerticalScrollOffset()) - n9 * this.getVerticalIncrement())) < n5) {
                    this.scrollVertical(n6 - n5, true);
                }
            }
        } else {
            int n11;
            Object object;
            int n12;
            int n13;
            int n14;
            n2 = this.getCaretLine();
            if (n == -1) {
                if (this.topIndexY == 0) {
                    n = this.clientAreaHeight;
                } else {
                    if (this.topIndex > 0) {
                        n14 = this.topIndex - 1;
                        n13 = this.renderer.getLineHeight(n14);
                        n = this.clientAreaHeight - this.topIndexY;
                        n12 = n13 - this.topIndexY;
                    } else {
                        n14 = this.topIndex;
                        n13 = this.renderer.getLineHeight(n14);
                        n = this.clientAreaHeight - (n13 + this.topIndexY);
                        n12 = -this.topIndexY;
                    }
                    if (this.wordWrap) {
                        object = this.renderer.getTextLayout(n14);
                        for (n11 = 0; n11 < ((TextLayout)object).getLineCount(); ++n11) {
                            Rectangle rectangle = ((TextLayout)object).getLineBounds(n11);
                            if (!rectangle.contains(rectangle.x, n12)) continue;
                            n += n13 - (rectangle.y + rectangle.height);
                            break;
                        }
                        this.renderer.disposeTextLayout((TextLayout)object);
                    }
                }
            } else {
                n14 = this.getLineIndex(this.clientAreaHeight - n);
                n12 = this.getLinePixel(n14);
                if (this.wordWrap) {
                    object = this.renderer.getTextLayout(n14);
                    n11 = n12;
                    for (int i = 0; i < ((TextLayout)object).getLineCount(); ++i) {
                        Rectangle rectangle = ((TextLayout)object).getLineBounds(i);
                        if (!rectangle.contains(rectangle.x, n11)) continue;
                        n = this.clientAreaHeight - (n12 + rectangle.y);
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                } else {
                    n = this.clientAreaHeight - n12;
                }
            }
            n12 = n;
            if (this.wordWrap) {
                object = this.renderer.getTextLayout(n2);
                n11 = this.caretOffset - this.content.getOffsetAtLine(n2);
                n14 = this.getVisualLineIndex((TextLayout)object, n11);
                n12 += ((TextLayout)object).getBounds().height - ((TextLayout)object).getLineBounds((int)n14).y;
                this.renderer.disposeTextLayout((TextLayout)object);
            }
            n14 = n2;
            n13 = this.renderer.getLineHeight(n14);
            while (n12 - n13 >= 0 && n14 > 0) {
                n12 -= n13;
                n13 = this.renderer.getLineHeight(--n14);
            }
            n13 = this.renderer.getLineHeight(n14);
            object = new int[1];
            n11 = this.getOffsetAtPoint(this.columnX, n13 - n12, n14, (int[])object);
            this.setCaretOffset(n11, (int)object[0]);
            if (bl) {
                this.doSelection(0x1000003);
            }
            n = this.getAvailableHeightAbove(n);
            this.scrollVertical(-n, true);
            if (n == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n2 = n3 - this.horizontalScrollOffset;
        this.columnX = n4 + n2;
    }

    void doSelection(int n) {
        int n2 = -1;
        int n3 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n3 = this.selection.x;
                n2 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n3 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n3 = this.selection.y;
                n2 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n2 = this.selection.y;
            n3 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n2 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n2 = this.selection.x;
            n3 = this.selection.x = this.caretOffset;
        }
        if (n2 != -1 && n3 != -1) {
            this.internalRedrawRange(n2, n3 - n2);
            this.sendSelectionEvent();
        }
        this.sendAccessibleTextCaretMoved();
    }

    void doSelectionCursorNext() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (n3 < this.content.getLine(n).length()) {
            TextLayout textLayout = this.renderer.getTextLayout(n);
            n3 = textLayout.getNextOffset(n3, 2);
            int n4 = textLayout.getLineOffsets()[textLayout.getLineIndex(n3)];
            this.renderer.disposeTextLayout(textLayout);
            int n5 = n3 + n2;
            int n6 = n3 == n4 ? 1 : 0;
            this.setCaretOffset(n5, n6);
            this.showCaret();
        } else if (n < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            int n7 = this.content.getOffsetAtLine(++n);
            int n8 = 0;
            this.setCaretOffset(n7, n8);
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (n3 > 0) {
            int n4 = this.getClusterPrevious(this.caretOffset, n);
            this.setCaretOffset(n4, 1);
            this.showCaret();
        } else if (n > 0) {
            n2 = this.content.getOffsetAtLine(--n);
            int n5 = n2 + this.content.getLine(n).length();
            this.setCaretOffset(n5, 1);
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        int n = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineDown(true);
        this.columnX = n;
    }

    void doSelectionLineUp() {
        int n = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineUp(true);
        this.columnX = n;
    }

    void doSelectionPageDown(int n) {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageDown(true, n);
        this.columnX = n2;
    }

    void doSelectionPageUp(int n) {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageUp(true, n);
        this.columnX = n2;
    }

    void doSelectionWordNext() {
        int n = this.getWordNext(this.caretOffset, 4);
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n)) {
            this.setCaretOffset(n, 1);
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        int n = this.getWordPrevious(this.caretOffset, 4);
        this.setCaretOffset(n, 1);
        this.showCaret();
    }

    void doVisualPrevious() {
        int n = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.setCaretOffset(n, -1);
        this.showCaret();
    }

    void doVisualNext() {
        int n = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.setCaretOffset(n, -1);
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.y, -1);
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.x, -1);
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    @Override
    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public int getBaseline(int n) {
        this.checkWidget();
        if (0 > n || n > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getBaseline();
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n4 = textLayout.getLineIndex(Math.min(n - n3, textLayout.getText().length()));
        FontMetrics fontMetrics = textLayout.getLineMetrics(n4);
        this.renderer.disposeTextLayout(textLayout);
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    public boolean getBlockSelection() {
        this.checkWidget();
        return this.blockSelection;
    }

    Rectangle getBlockSelectionPosition() {
        int n;
        int n2;
        int n3;
        int n4 = this.getLineIndex(this.blockYAnchor - this.getVerticalScrollOffset());
        if (n4 > (n3 = this.getLineIndex(this.blockYLocation - this.getVerticalScrollOffset()))) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        if ((n2 = this.blockXAnchor) > (n = this.blockXLocation)) {
            n2 = this.blockXLocation;
            n = this.blockXAnchor;
        }
        return new Rectangle(n2 - this.horizontalScrollOffset, n4, n - this.horizontalScrollOffset, n3);
    }

    public Rectangle getBlockSelectionBounds() {
        Rectangle rectangle;
        if (this.blockSelection && this.blockXLocation != -1) {
            rectangle = this.getBlockSelectionRectangle();
        } else {
            Point point = this.getPointAtOffset(this.selection.x);
            Point point2 = this.getPointAtOffset(this.selection.y);
            int n = this.getLineHeight(this.selection.y);
            rectangle = new Rectangle(point.x, point.y, point2.x - point.x, point2.y + n - point.y);
            if (this.selection.x == this.selection.y) {
                rectangle.width = this.getCaretWidth();
            }
        }
        rectangle.x += this.horizontalScrollOffset;
        rectangle.y += this.getVerticalScrollOffset();
        return rectangle;
    }

    Rectangle getBlockSelectionRectangle() {
        Rectangle rectangle = this.getBlockSelectionPosition();
        rectangle.y = this.getLinePixel(rectangle.y);
        rectangle.width -= rectangle.x;
        rectangle.height = this.getLinePixel(rectangle.height + 1) - rectangle.y;
        return rectangle;
    }

    String getBlockSelectionText(String string) {
        Rectangle rectangle = this.getBlockSelectionPosition();
        int n = rectangle.y;
        int n2 = rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.width;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            int n5;
            int n6 = this.getOffsetAtPoint(n3, 0, i, null);
            if (n6 > (n5 = this.getOffsetAtPoint(n4, 0, i, null))) {
                int n7 = n6;
                n6 = n5;
                n5 = n7;
            }
            String string2 = this.content.getTextRange(n6, n5 - n6);
            stringBuffer.append(string2);
            if (i >= n2) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    int getBottomIndex() {
        int n;
        if (this.isFixedLineHeight()) {
            int n2 = 1;
            int n3 = this.renderer.getLineHeight();
            if (n3 != 0) {
                int n4 = this.topIndex * n3 - this.getVerticalScrollOffset();
                n2 = (this.clientAreaHeight - n4) / n3;
            }
            n = Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n2 - 1));
        } else {
            int n5;
            int n6;
            int n7 = this.clientAreaHeight - this.bottomMargin;
            n = this.getLineIndex(n7);
            if (n > 0 && (n6 = this.getLinePixel(n)) + (n5 = this.renderer.getLineHeight(n)) > n7 && this.getLinePixel(n - 1) >= this.topMargin) {
                --n;
            }
        }
        return n;
    }

    public int getBottomMargin() {
        this.checkWidget();
        return this.bottomMargin;
    }

    Rectangle getBoundsAtOffset(int n) {
        Rectangle rectangle;
        int n2;
        int n3 = this.content.getLineAtOffset(n);
        int n4 = this.content.getOffsetAtLine(n3);
        String string = this.content.getLine(n3);
        if (string.length() != 0) {
            n2 = n - n4;
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            rectangle = textLayout.getBounds(n2, n2);
            this.renderer.disposeTextLayout(textLayout);
        } else {
            rectangle = new Rectangle(0, 0, 0, this.renderer.getLineHeight());
        }
        if (n == this.caretOffset && !this.wordWrap && n == (n2 = n4 + string.length())) {
            rectangle.width += this.getCaretWidth();
        }
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        rectangle.y += this.getLinePixel(n3);
        return rectangle;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int n) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents(textTransfer, n);
    }

    int getClusterNext(int n, int n2) {
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        n -= n3;
        n = textLayout.getNextOffset(n, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n += n3;
    }

    int getClusterPrevious(int n, int n2) {
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        n -= n3;
        n = textLayout.getPreviousOffset(n, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n += n3;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.content;
    }

    @Override
    public boolean getDragDetect() {
        this.checkWidget();
        return this.dragDetect;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        return this.renderer.averageCharWidth;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getIndent() {
        this.checkWidget();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkWidget();
        return this.justify;
    }

    public int getKeyBinding(int n) {
        this.checkWidget();
        Integer n2 = (Integer)this.keyActionMap.get(new Integer(n));
        return n2 == null ? 0 : n2;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public String getLine(int n) {
        this.checkWidget();
        if (n < 0 || n > 0 && n >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getLine(n);
    }

    public int getLineAlignment(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.renderer.getLineAlignment(n, this.alignment);
    }

    public int getLineAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        return this.content.getLineAtOffset(n);
    }

    public Color getLineBackground(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3001) ? null : this.renderer.getLineBackground(n, null);
    }

    public Bullet getLineBullet(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? null : this.renderer.getLineBullet(n, null);
    }

    StyledTextEvent getLineBackgroundData(int n, String string) {
        return this.sendLineEvent(3001, n, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.content.getLineCount();
    }

    int getLineCountWhole() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            return n != 0 ? this.clientAreaHeight / n : 1;
        }
        return this.getBottomIndex() - this.topIndex + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.renderer.getLineHeight();
    }

    public int getLineHeight(int n) {
        this.checkWidget();
        if (0 > n || n > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getLineHeight();
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n4 = textLayout.getLineIndex(Math.min(n - n3, textLayout.getText().length()));
        int n5 = textLayout.getLineBounds((int)n4).height;
        this.renderer.disposeTextLayout(textLayout);
        return n5;
    }

    public int getLineIndent(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineIndent(n, this.indent);
    }

    public boolean getLineJustify(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? false : this.renderer.getLineJustify(n, this.justify);
    }

    public int getLineSpacing() {
        this.checkWidget();
        return this.lineSpacing;
    }

    StyledTextEvent getLineStyleData(int n, String string) {
        return this.sendLineEvent(3002, n, string);
    }

    public int getLinePixel(int n) {
        this.checkWidget();
        int n2 = this.content.getLineCount();
        n = Math.max(0, Math.min(n2, n));
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            return n * n3 - this.getVerticalScrollOffset() + this.topMargin;
        }
        if (n == this.topIndex) {
            return this.topIndexY + this.topMargin;
        }
        int n4 = this.topIndexY;
        if (n > this.topIndex) {
            for (int i = this.topIndex; i < n; ++i) {
                n4 += this.renderer.getLineHeight(i);
            }
        } else {
            for (int i = this.topIndex - 1; i >= n; --i) {
                n4 -= this.renderer.getLineHeight(i);
            }
        }
        return n4 + this.topMargin;
    }

    public int getLineIndex(int n) {
        this.checkWidget();
        n -= this.topMargin;
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = (n + this.getVerticalScrollOffset()) / n2;
            int n4 = this.content.getLineCount();
            n3 = Math.max(0, Math.min(n4 - 1, n3));
            return n3;
        }
        if (n == this.topIndexY) {
            return this.topIndex;
        }
        int n5 = this.topIndex;
        if (n < this.topIndexY) {
            while (n < this.topIndexY && n5 > 0) {
                n += this.renderer.getLineHeight(--n5);
            }
        } else {
            int n6 = this.content.getLineCount();
            int n7 = this.renderer.getLineHeight(n5);
            while (n - n7 >= this.topIndexY && n5 < n6 - 1) {
                n -= n7;
                n7 = this.renderer.getLineHeight(++n5);
            }
        }
        return n5;
    }

    public int[] getLineTabStops(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (this.isListening(3002)) {
            return null;
        }
        int[] nArray = this.renderer.getLineTabStops(n, null);
        if (nArray == null) {
            nArray = this.tabs;
        }
        if (nArray == null) {
            return new int[]{this.renderer.tabWidth};
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public int getLineWrapIndent(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineWrapIndent(n, this.wrapIndent);
    }

    public int getLeftMargin() {
        this.checkWidget();
        return this.leftMargin - this.alignmentMargin;
    }

    public Point getLocationAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        return this.getPointAtOffset(n);
    }

    public int getOffsetAtLine(int n) {
        this.checkWidget();
        if (n < 0 || n > 0 && n >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getOffsetAtLine(n);
    }

    public int getOffsetAtLocation(Point point) {
        int[] nArray;
        int n;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if ((n = this.getOffsetAtPoint(point.x, point.y, nArray = new int[1], true)) == -1) {
            SWT.error(5);
        }
        return n + nArray[0];
    }

    int getOffsetAtPoint(int n, int n2, int[] nArray) {
        int n3 = this.getLineIndex(n2);
        return this.getOffsetAtPoint(n, n2 -= this.getLinePixel(n3), n3, nArray);
    }

    int getOffsetAtPoint(int n, int n2, int n3, int[] nArray) {
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int[] nArray2 = new int[1];
        int n4 = textLayout.getOffset(n += this.horizontalScrollOffset - this.leftMargin, n2, nArray2);
        if (nArray != null) {
            nArray[0] = 1;
        }
        if (nArray2[0] != 0) {
            int n5 = textLayout.getLineIndex(n4 + nArray2[0]);
            int n6 = textLayout.getLineOffsets()[n5];
            if (n4 + nArray2[0] == n6) {
                n4 += nArray2[0];
                if (nArray != null) {
                    nArray[0] = 0;
                }
            } else {
                int n7;
                String string = this.content.getLine(n3);
                int n8 = 0;
                if (nArray != null) {
                    for (n7 = n4; n7 > 0 && Character.isDigit(string.charAt(n7)); --n7) {
                    }
                    n8 = n7 == 0 && Character.isDigit(string.charAt(n7)) ? (this.isMirrored() ? 1 : 0) : textLayout.getLevel(n7) & 1;
                }
                n4 += nArray2[0];
                if (nArray != null) {
                    n7 = textLayout.getLevel(n4) & 1;
                    nArray[0] = (n8 ^ n7) != 0 ? 0 : 1;
                }
            }
        }
        this.renderer.disposeTextLayout(textLayout);
        return n4 + this.content.getOffsetAtLine(n3);
    }

    int getOffsetAtPoint(int n, int n2, int[] nArray, boolean bl) {
        if (bl && n2 + this.getVerticalScrollOffset() < 0 || n + this.horizontalScrollOffset < 0) {
            return -1;
        }
        int n3 = this.getPartialBottomIndex();
        int n4 = this.getLinePixel(n3 + 1);
        if (bl && n2 > n4) {
            return -1;
        }
        int n5 = this.getLineIndex(n2);
        int n6 = this.content.getOffsetAtLine(n5);
        TextLayout textLayout = this.renderer.getTextLayout(n5);
        int n7 = textLayout.getOffset(n += this.horizontalScrollOffset - this.leftMargin, n2 -= this.getLinePixel(n5), nArray);
        Rectangle rectangle = textLayout.getLineBounds(textLayout.getLineIndex(n7));
        this.renderer.disposeTextLayout(textLayout);
        if (bl && (rectangle.x > n || n > rectangle.x + rectangle.width)) {
            return -1;
        }
        return n7 + n6;
    }

    public int getOrientation() {
        this.checkWidget();
        if (IS_MAC) {
            int n = super.getStyle();
            return n & 0x6000000;
        }
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            int n2 = Compatibility.ceil(this.clientAreaHeight, n);
            return Math.max(0, Math.min(this.content.getLineCount(), this.topIndex + n2) - 1);
        }
        return this.getLineIndex(this.clientAreaHeight - this.bottomMargin);
    }

    int getPartialTopIndex() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            return this.getVerticalScrollOffset() / n;
        }
        return this.topIndexY <= 0 ? this.topIndex : this.topIndex - 1;
    }

    String getPlatformDelimitedText(TextWriter textWriter) {
        int n = textWriter.getStart() + textWriter.getCharCount();
        int n2 = this.content.getLineAtOffset(textWriter.getStart());
        int n3 = this.content.getLineAtOffset(n);
        String string = this.content.getLine(n3);
        int n4 = this.content.getOffsetAtLine(n3);
        for (int i = n2; i <= n3; ++i) {
            textWriter.writeLine(this.content.getLine(i), this.content.getOffsetAtLine(i));
            if (i >= n3) continue;
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        if (n > n4 + string.length()) {
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        textWriter.close();
        return textWriter.toString();
    }

    public int[] getRanges() {
        int[] nArray;
        this.checkWidget();
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(0, this.content.getCharCount())) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int[] getRanges(int n, int n2) {
        int[] nArray;
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(n, n2)) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int getRightMargin() {
        this.checkWidget();
        return this.rightMargin;
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public int[] getSelectionRanges() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionPosition();
            int n = rectangle.y;
            int n2 = rectangle.height;
            int n3 = rectangle.x;
            int n4 = rectangle.width;
            int[] nArray = new int[(n2 - n + 1) * 2];
            int n5 = 0;
            for (int i = n; i <= n2; ++i) {
                int n6;
                int n7 = this.getOffsetAtPoint(n3, 0, i, null);
                if (n7 > (n6 = this.getOffsetAtPoint(n4, 0, i, null))) {
                    int n8 = n7;
                    n7 = n6;
                    n6 = n8;
                }
                nArray[n5++] = n7;
                nArray[n5++] = n6 - n7;
            }
            return nArray;
        }
        return new int[]{this.selection.x, this.selection.y - this.selection.x};
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            return this.getBlockSelectionText(this.content.getLineDelimiter()).length();
        }
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            return this.getBlockSelectionText(this.content.getLineDelimiter());
        }
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    @Override
    public int getStyle() {
        int n = super.getStyle();
        n &= 0xF1FFFFFF;
        n |= this.getOrientation();
        if (this.isMirrored()) {
            n |= 0x8000000;
        }
        return n;
    }

    StyledTextEvent getBidiSegments(int n, String string) {
        if (!this.isBidi()) {
            return null;
        }
        if (!this.isListening(3007)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.segments = this.getBidiSegmentsCompatibility(string, n);
            return styledTextEvent;
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n, string);
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            return null;
        }
        int n2 = string.length();
        int[] nArray = styledTextEvent.segments;
        int n3 = nArray.length;
        if (styledTextEvent.segmentsChars == null) {
            if (nArray[0] != 0) {
                SWT.error(5);
            }
            for (int i = 1; i < n3; ++i) {
                if (nArray[i] > nArray[i - 1] && nArray[i] <= n2) continue;
                SWT.error(5);
            }
            if (nArray[n3 - 1] != n2) {
                nArray = new int[n3 + 1];
                System.arraycopy(styledTextEvent.segments, 0, nArray, 0, n3);
                nArray[n3] = n2;
            }
            styledTextEvent.segments = nArray;
        } else {
            for (int i = 1; i < n3; ++i) {
                if (styledTextEvent.segments[i] >= styledTextEvent.segments[i - 1] && styledTextEvent.segments[i] <= n2) continue;
                SWT.error(5);
            }
        }
        return styledTextEvent;
    }

    int[] getBidiSegmentsCompatibility(String string, int n) {
        int n2;
        int n3 = string.length();
        if (!this.bidiColoring) {
            return new int[]{0, n3};
        }
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n, string);
        styleRangeArray = styledTextEvent != null ? styledTextEvent.styles : this.renderer.getStyleRanges(n, n3, true);
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            return new int[]{0, n3};
        }
        int n4 = 1;
        for (n2 = 0; n2 < styleRangeArray.length && styleRangeArray[n2].start == 0 && styleRangeArray[n2].length == n3; ++n2) {
        }
        int[] nArray = new int[(styleRangeArray.length - n2) * 2 + 2];
        for (int i = n2; i < styleRangeArray.length; ++i) {
            StyleRange styleRange = styleRangeArray[i];
            int n5 = Math.max(styleRange.start - n, 0);
            int n6 = Math.max(styleRange.start + styleRange.length - n, n5);
            n6 = Math.min(n6, string.length());
            if (i > 0 && n4 > 1 && (n5 >= nArray[n4 - 2] && n5 <= nArray[n4 - 1] || n6 >= nArray[n4 - 2] && n6 <= nArray[n4 - 1]) && styleRange.similarTo(styleRangeArray[i - 1])) {
                nArray[n4 - 2] = Math.min(nArray[n4 - 2], n5);
                nArray[n4 - 1] = Math.max(nArray[n4 - 1], n6);
                continue;
            }
            if (n5 > nArray[n4 - 1]) {
                nArray[n4] = n5;
                ++n4;
            }
            nArray[n4] = n6;
            ++n4;
        }
        if (n3 > nArray[n4 - 1]) {
            nArray[n4] = n3;
            ++n4;
        }
        if (n4 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        if (n < 0 || n >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n, 1, true)) != null) {
            return styleRangeArray[0];
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), true);
    }

    public StyleRange[] getStyleRanges(boolean bl) {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), bl);
    }

    public StyleRange[] getStyleRanges(int n, int n2) {
        this.checkWidget();
        return this.getStyleRanges(n, n2, true);
    }

    public StyleRange[] getStyleRanges(int n, int n2, boolean bl) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n, n2, bl)) != null) {
            return styleRangeArray;
        }
        return new StyleRange[0];
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public int[] getTabStops() {
        this.checkWidget();
        if (this.tabs == null) {
            return new int[]{this.renderer.tabWidth};
        }
        int[] nArray = new int[this.tabs.length];
        System.arraycopy(this.tabs, 0, nArray, 0, this.tabs.length);
        return nArray;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3 || n > n2) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2 - n + 1);
    }

    public Rectangle getTextBounds(int n, int n2) {
        Rectangle rectangle;
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3 || n > n2) {
            SWT.error(6);
        }
        int n4 = this.content.getLineAtOffset(n);
        int n5 = this.content.getLineAtOffset(n2);
        int n6 = this.getLinePixel(n4);
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        for (int i = n4; i <= n5; ++i) {
            int n10 = this.content.getOffsetAtLine(i);
            TextLayout textLayout = this.renderer.getTextLayout(i);
            int n11 = textLayout.getText().length();
            if (n11 > 0) {
                if (i == n4) {
                    rectangle = i == n5 ? textLayout.getBounds(n - n10, n2 - n10) : textLayout.getBounds(n - n10, n11);
                    n6 += rectangle.y;
                } else {
                    rectangle = i == n5 ? textLayout.getBounds(0, n2 - n10) : textLayout.getBounds();
                }
                n8 = Math.min(n8, rectangle.x);
                n9 = Math.max(n9, rectangle.x + rectangle.width);
                n7 += rectangle.height;
            } else {
                n7 += this.renderer.getLineHeight();
            }
            this.renderer.disposeTextLayout(textLayout);
        }
        rectangle = new Rectangle(n8, n6, n9 - n8, n7);
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        return rectangle;
    }

    public String getTextRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public int getTopMargin() {
        this.checkWidget();
        return this.topMargin;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getVerticalScrollOffset();
    }

    int getVerticalIncrement() {
        return this.renderer.getLineHeight();
    }

    int getVerticalScrollOffset() {
        if (this.verticalScrollOffset == -1) {
            this.renderer.calculate(0, this.topIndex);
            int n = 0;
            for (int i = 0; i < this.topIndex; ++i) {
                n += this.renderer.getLineHeight(i);
            }
            this.verticalScrollOffset = n -= this.topIndexY;
        }
        return this.verticalScrollOffset;
    }

    int getVisualLineIndex(TextLayout textLayout, int n) {
        int n2;
        int n3;
        int n4 = textLayout.getLineIndex(n);
        int[] nArray = textLayout.getLineOffsets();
        if (n4 != 0 && n == nArray[n4] && (n3 = textLayout.getLineBounds((int)n4).y) > (n2 = this.getCaret().getLocation().y - this.topMargin - this.getLinePixel(this.getCaretLine()))) {
            --n4;
        }
        return n4;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (this.ime.getCompositionOffset() != -1) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        String string = this.content.getLine(n);
        int n3 = this.caretOffset - n2;
        int n4 = string.length();
        if (n4 == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.caretAlignment == 0 && n3 > 0) {
            --n3;
        }
        if (n3 == n4 && n3 > 0) {
            --n3;
        }
        while (n3 > 0 && Character.isDigit(string.charAt(n3))) {
            --n3;
        }
        if (n3 == 0 && Character.isDigit(string.charAt(n3))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout textLayout = this.renderer.getTextLayout(n);
        int n5 = textLayout.getLevel(n3);
        this.renderer.disposeTextLayout(textLayout);
        return (n5 & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        return this.content.getLineAtOffset(this.caretOffset);
    }

    int getWrapWidth() {
        if (this.wordWrap && !this.isSingleLine()) {
            int n = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            return n > 0 ? n : 1;
        }
        return -1;
    }

    int getWordNext(int n, int n2) {
        return this.getWordNext(n, n2, false);
    }

    int getWordNext(int n, int n2, boolean bl) {
        String string;
        int n3;
        int n4;
        if (n >= this.getCharCount()) {
            n4 = n;
            int n5 = this.content.getLineCount() - 1;
            n3 = this.content.getOffsetAtLine(n5);
            string = this.content.getLine(n5);
        } else {
            int n6;
            int n7 = this.content.getLineAtOffset(n);
            n3 = this.content.getOffsetAtLine(n7);
            if (n >= n3 + (n6 = (string = this.content.getLine(n7)).length())) {
                n4 = this.content.getOffsetAtLine(n7 + 1);
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                n4 = n3 + textLayout.getNextOffset(n - n3, n2);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        if (bl) {
            return n4;
        }
        return this.sendWordBoundaryEvent(3009, n2, n, n4, string, n3);
    }

    int getWordPrevious(int n, int n2) {
        return this.getWordPrevious(n, n2, false);
    }

    int getWordPrevious(int n, int n2, boolean bl) {
        String string;
        int n3;
        int n4;
        if (n <= 0) {
            n4 = 0;
            int n5 = this.content.getLineAtOffset(n4);
            n3 = this.content.getOffsetAtLine(n5);
            string = this.content.getLine(n5);
        } else {
            int n6 = this.content.getLineAtOffset(n);
            n3 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
            if (n == n3) {
                String string2 = this.content.getLine(n6 - 1);
                int n7 = this.content.getOffsetAtLine(n6 - 1);
                n4 = n7 + string2.length();
            } else {
                int n8 = Math.min(n - n3, string.length());
                TextLayout textLayout = this.renderer.getTextLayout(n6);
                n4 = n3 + textLayout.getPreviousOffset(n8, n2);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        if (bl) {
            return n4;
        }
        return this.sendWordBoundaryEvent(3010, n2, n, n4, string, n3);
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    public int getWrapIndent() {
        this.checkWidget();
        return this.wrapIndent;
    }

    Point getPointAtOffset(int n) {
        Point point;
        int n2 = this.content.getLineAtOffset(n);
        String string = this.content.getLine(n2);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        int n5 = string.length();
        if (n2 < this.content.getLineCount() - 1) {
            int n6 = this.content.getOffsetAtLine(n2 + 1) - 1;
            if (n5 < n4 && n4 <= n6) {
                n4 = n5;
            }
        }
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        if (n5 != 0 && n4 <= n5) {
            if (n4 == n5) {
                point = textLayout.getLocation(n4 - 1, true);
            } else {
                switch (this.caretAlignment) {
                    case 1: {
                        point = textLayout.getLocation(n4, false);
                        break;
                    }
                    default: {
                        if (n4 == 0) {
                            point = textLayout.getLocation(n4, false);
                            break;
                        }
                        point = textLayout.getLocation(n4 - 1, true);
                        break;
                    }
                }
            }
        } else {
            point = new Point(textLayout.getIndent(), 0);
        }
        this.renderer.disposeTextLayout(textLayout);
        point.x += this.leftMargin - this.horizontalScrollOffset;
        point.y += this.getLinePixel(n2);
        return point;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (this.blockSelection) {
            this.insertBlockSelectionText(string, false);
        } else {
            Point point = this.getSelectionRange();
            this.replaceTextRange(point.x, point.y, string);
        }
    }

    int insertBlockSelectionText(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        for (int i = 0; i < string.length(); ++i) {
            n6 = string.charAt(i);
            if (n6 != 10 && n6 != 13) continue;
            ++n7;
            if (n6 != 13 || i + 1 >= string.length() || string.charAt(i + 1) != '\n') continue;
            ++i;
        }
        String[] stringArray = new String[n7];
        n6 = 0;
        n7 = 0;
        for (n5 = 0; n5 < string.length(); ++n5) {
            n4 = string.charAt(n5);
            if (n4 != 10 && n4 != 13) continue;
            stringArray[n7++] = string.substring(n6, n5);
            if (n4 == 13 && n5 + 1 < string.length() && string.charAt(n5 + 1) == '\n') {
                ++n5;
            }
            n6 = n5 + 1;
        }
        stringArray[n7++] = string.substring(n6);
        if (bl) {
            n5 = 0;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                int n8 = stringArray[n4].length();
                n5 = Math.max(n5, n8);
            }
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                String string2 = stringArray[n4];
                n3 = string2.length();
                if (n3 >= n5) continue;
                int n9 = n5 - n3;
                StringBuffer stringBuffer = new StringBuffer(n3 + n9);
                stringBuffer.append(string2);
                for (n2 = 0; n2 < n9; ++n2) {
                    stringBuffer.append(' ');
                }
                stringArray[n4] = stringBuffer.toString();
            }
        }
        if (this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionPosition();
            n5 = rectangle.y;
            n4 = rectangle.height;
            n = rectangle.x;
            n3 = rectangle.width;
        } else {
            n5 = n4 = this.getCaretLine();
            n = n3 = this.getPointAtOffset((int)this.caretOffset).x;
        }
        n6 = this.caretOffset;
        int n10 = this.getCaretLine();
        int n11 = 0;
        for (n2 = n5; n2 <= n4; ++n2) {
            String string3 = n11 < n7 ? stringArray[n11++] : "";
            int n12 = this.sendTextEvent(n, n3, n2, string3, bl);
            if (n2 != n10) continue;
            n6 = n12;
        }
        while (n11 < n7) {
            int n13 = this.sendTextEvent(n, n, n2, stringArray[n11++], bl);
            if (n2 == n10) {
                n6 = n13;
            }
            ++n2;
        }
        return n6;
    }

    void insertBlockSelectionText(char c, int n) {
        int n2;
        if (c == '\r' || c == '\n') {
            return;
        }
        Rectangle rectangle = this.getBlockSelectionPosition();
        int n3 = rectangle.y;
        int n4 = rectangle.height;
        int n5 = rectangle.x;
        int n6 = rectangle.width;
        int[] nArray = new int[1];
        int n7 = 0;
        int n8 = 0;
        String string = c != '\u0000' ? new String(new char[]{c}) : "";
        int n9 = string.length();
        for (n2 = n3; n2 <= n4; ++n2) {
            boolean bl;
            String string2 = this.content.getLine(n2);
            int n10 = this.content.getOffsetAtLine(n2);
            int n11 = n10 + string2.length();
            int n12 = this.getLinePixel(n2);
            int n13 = this.getOffsetAtPoint(n5, n12, nArray, true);
            boolean bl2 = bl = n13 == -1;
            n13 = bl ? (n5 < this.leftMargin ? n10 : n11) : (n13 += nArray[0]);
            int n14 = this.getOffsetAtPoint(n6, n12, nArray, true);
            n14 = n14 == -1 ? (n6 < this.leftMargin ? n10 : n11) : (n14 += nArray[0]);
            if (n13 > n14) {
                int n15 = n13;
                n13 = n14;
                n14 = n15;
            }
            if (n13 == n14 && !bl) {
                switch (n) {
                    case 8: {
                        if (n13 <= n10) break;
                        n13 = this.getClusterPrevious(n13, n2);
                        break;
                    }
                    case 127: {
                        if (n14 >= n11) break;
                        n14 = this.getClusterNext(n14, n2);
                    }
                }
            }
            if (bl) {
                if (string2.length() >= n8) {
                    n8 = string2.length();
                    n7 = n11 + n9;
                }
            } else {
                n7 = n13 + n9;
                n8 = this.content.getCharCount();
            }
            Event event = new Event();
            event.text = string;
            event.start = n13;
            event.end = n14;
            this.sendKeyEvent(event);
        }
        n2 = this.getPointAtOffset((int)n7).x;
        int n16 = this.getVerticalScrollOffset();
        this.setBlockSelectionLocation(n2, this.blockYAnchor - n16, n2, this.blockYLocation - n16, false);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            @Override
            public void textChanging(TextChangingEvent textChangingEvent) {
                StyledText.this.handleTextChanging(textChangingEvent);
            }

            @Override
            public void textChanged(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextChanged(textChangedEvent);
            }

            @Override
            public void textSet(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextSet(textChangedEvent);
            }
        };
        this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        StyledText.this.handleDispose(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        StyledText.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        StyledText.this.handleMouseUp(event);
                        break;
                    }
                    case 5: {
                        StyledText.this.handleMouseMove(event);
                        break;
                    }
                    case 9: {
                        StyledText.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        StyledText.this.handleResize(event);
                        break;
                    }
                    case 31: {
                        StyledText.this.handleTraverse(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        this.ime.addListener(43, new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 3: {
                        StyledText.this.handleCompositionSelection(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleCompositionChanged(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleCompositionOffset(event);
                    }
                }
            }
        });
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    void internalRedrawRange(int n, int n2) {
        int n3;
        Rectangle rectangle;
        if (n2 <= 0) {
            return;
        }
        int n4 = n + n2;
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n4);
        int n7 = this.getPartialBottomIndex();
        int n8 = this.getPartialTopIndex();
        if (n5 > n7 || n6 < n8) {
            return;
        }
        if (n8 > n5) {
            n5 = n8;
            n = 0;
        } else {
            n -= this.content.getOffsetAtLine(n5);
        }
        if (n7 < n6) {
            n6 = n7 + 1;
            n4 = 0;
        } else {
            n4 -= this.content.getOffsetAtLine(n6);
        }
        TextLayout textLayout = this.renderer.getTextLayout(n5);
        int n9 = this.leftMargin - this.horizontalScrollOffset;
        int n10 = this.getLinePixel(n5);
        int[] nArray = textLayout.getLineOffsets();
        int n11 = textLayout.getLineIndex(Math.min(n, textLayout.getText().length()));
        if (this.wordWrap && n11 > 0 && nArray[n11] == n) {
            rectangle = textLayout.getLineBounds(n11 - 1);
            rectangle.x = rectangle.width;
            rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
            rectangle.x += n9;
            rectangle.y += n10;
            super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
        if (n5 == n6 && n11 == (n3 = textLayout.getLineIndex(Math.min(n4, textLayout.getText().length())))) {
            Rectangle rectangle2 = textLayout.getBounds(n, n4 - 1);
            rectangle2.x += n9;
            rectangle2.y += n10;
            super.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
            this.renderer.disposeTextLayout(textLayout);
            return;
        }
        rectangle = textLayout.getBounds(n, nArray[n11 + 1] - 1);
        if (rectangle.height == 0) {
            Rectangle rectangle3 = textLayout.getLineBounds(n11);
            rectangle.x = rectangle3.width;
            rectangle.y = rectangle3.y;
            rectangle.height = rectangle3.height;
        }
        rectangle.x += n9;
        rectangle.y += n10;
        rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
        super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (n5 != n6) {
            this.renderer.disposeTextLayout(textLayout);
            textLayout = this.renderer.getTextLayout(n6);
            nArray = textLayout.getLineOffsets();
        }
        int n12 = textLayout.getLineIndex(Math.min(n4, textLayout.getText().length()));
        Rectangle rectangle4 = textLayout.getBounds(nArray[n12], n4 - 1);
        if (rectangle4.height == 0) {
            Rectangle rectangle5 = textLayout.getLineBounds(n12);
            rectangle4.y = rectangle5.y;
            rectangle4.height = rectangle5.height;
        }
        rectangle4.x += n9;
        rectangle4.y += this.getLinePixel(n6);
        super.redraw(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, false);
        this.renderer.disposeTextLayout(textLayout);
        int n13 = rectangle.y + rectangle.height;
        if (rectangle4.y > n13) {
            super.redraw(this.leftMargin, n13, this.clientAreaWidth - this.rightMargin - this.leftMargin, rectangle4.y - n13, false);
        }
    }

    void handleCompositionOffset(Event event) {
        int[] nArray = new int[1];
        event.index = this.getOffsetAtPoint(event.x, event.y, nArray, true);
        event.count = nArray[0];
    }

    void handleCompositionSelection(Event event) {
        event.start = this.selection.x;
        event.end = this.selection.y;
        event.text = this.getSelectionText();
    }

    void handleCompositionChanged(Event event) {
        String string = event.text;
        int n = event.start;
        int n2 = event.end;
        int n3 = string.length();
        if (n3 == this.ime.getCommitCount()) {
            this.content.replaceTextRange(n, n2 - n, "");
            this.setCaretOffset(this.ime.getCompositionOffset(), -1);
            this.caretWidth = 0;
            this.caretDirection = 0;
        } else {
            this.content.replaceTextRange(n, n2 - n, string);
            int n4 = -1;
            if (this.ime.getWideCaret()) {
                n = this.ime.getCompositionOffset();
                int n5 = this.getCaretLine();
                int n6 = this.content.getOffsetAtLine(n5);
                TextLayout textLayout = this.renderer.getTextLayout(n5);
                this.caretWidth = textLayout.getBounds((int)(n - n6), (int)(n + n3 - 1 - n6)).width;
                this.renderer.disposeTextLayout(textLayout);
                n4 = 1;
            }
            this.setCaretOffset(this.ime.getCaretOffset(), n4);
        }
        this.showCaret();
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener(this);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.marginColor = null;
        this.textChangeListener = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
        this.tabs = null;
    }

    void handleHorizontalScroll(Event event) {
        int n = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n, false);
    }

    void handleKey(Event event) {
        int n;
        int n2;
        this.caretAlignment = 0;
        if (event.keyCode != 0) {
            n2 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n2 = this.getKeyBinding(event.character | event.stateMask);
            if (n2 == 0 && (event.stateMask & 0x40000) != 0 && event.character <= '\u001f') {
                n = event.character + 64;
                n2 = this.getKeyBinding(n | event.stateMask);
            }
        }
        if (n2 == 0) {
            n = 0;
            if (IS_MAC) {
                n = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0 ? 1 : 0;
            } else if (IS_MOTIF) {
                n = (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            } else {
                int n3 = n = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            }
            if (n == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
                this.update();
            }
        } else {
            this.invokeAction(n2);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        this.newOrientation = 0;
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.keyLocation = event.keyLocation;
        event2.stateMask = event.stateMask;
        event2.doit = true;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            if ((event.stateMask & SWT.MODIFIER_MASK) == 262144 && event.keyCode == 131072 && this.isBidiCaret()) {
                this.newOrientation = event.keyLocation == 16384 ? 0x2000000 : 0x4000000;
            }
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
            this.copySelection(2);
        }
        this.clipboardSelection = null;
        if (this.newOrientation != 0) {
            if (this.newOrientation != this.getOrientation()) {
                Event event2 = new Event();
                event2.doit = true;
                this.notifyListeners(44, event2);
                if (event2.doit) {
                    this.setOrientation(this.newOrientation);
                }
            }
            this.newOrientation = 0;
        }
    }

    void handleMouseDown(Event event) {
        String string;
        this.forceFocus();
        if (this.dragDetect && this.checkDragDetect(event)) {
            return;
        }
        if (event.button == 2 && (string = (String)this.getClipboardContent(2)) != null && string.length() > 0) {
            this.doMouseLocationChange(event.x, event.y, false);
            Event event2 = new Event();
            event2.start = this.selection.x;
            event2.end = this.selection.y;
            event2.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event2);
        }
        if (event.button != 1 || IS_MAC && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        this.clickCount = event.count;
        if (this.clickCount == 1) {
            boolean bl = (event.stateMask & SWT.MOD2) != 0;
            this.doMouseLocationChange(event.x, event.y, bl);
        } else if (this.doubleClickEnabled) {
            boolean bl = (this.clickCount & 1) == 0;
            int n = this.getOffsetAtPoint(event.x, event.y, null);
            int n2 = this.content.getLineAtOffset(n);
            int n3 = this.content.getOffsetAtLine(n2);
            if (bl) {
                int n4 = this.blockSelection ? n3 : 0;
                int n5 = this.blockSelection ? n3 + this.content.getLine(n2).length() : this.content.getCharCount();
                int n6 = Math.max(n4, this.getWordPrevious(n, 16));
                int n7 = Math.min(n5, this.getWordNext(n6, 8));
                this.setSelection(n6, n7 - n6, false, true);
                this.sendSelectionEvent();
            } else if (this.blockSelection) {
                this.setBlockSelectionLocation(this.leftMargin, event.y, this.clientAreaWidth - this.rightMargin, event.y, true);
            } else {
                int n8 = this.content.getCharCount();
                if (n2 + 1 < this.content.getLineCount()) {
                    n8 = this.content.getOffsetAtLine(n2 + 1);
                }
                this.setSelection(n3, n8 - n3, false, false);
                this.sendSelectionEvent();
            }
            this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
            this.showCaret();
        }
    }

    void handleMouseMove(Event event) {
        if (this.clickCount > 0) {
            this.update();
            this.doAutoScroll(event);
            this.doMouseLocationChange(event.x, event.y, true);
        }
        if (this.renderer.hasLinks) {
            this.doMouseLinkCursor(event.x, event.y);
        }
    }

    void handleMouseUp(Event event) {
        this.clickCount = 0;
        this.endAutoScroll();
        if (event.button == 1) {
            this.copySelection(2);
        }
    }

    void handlePaint(Event event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        if (this.clientAreaWidth == 0 || this.clientAreaHeight == 0) {
            return;
        }
        int n = this.getLineIndex(event.y);
        int n2 = this.getLinePixel(n);
        int n3 = event.y + event.height;
        GC gC = event.gc;
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (n3 > 0) {
            int n4 = this.isSingleLine() ? 1 : this.content.getLineCount();
            int n5 = this.leftMargin - this.horizontalScrollOffset;
            for (int i = n; n2 < n3 && i < n4; n2 += this.renderer.drawLine(i, n5, n2, gC, color, color2), ++i) {
            }
            if (n2 < n3) {
                gC.setBackground(color);
                this.drawBackground(gC, 0, n2, this.clientAreaWidth, n3 - n2);
            }
        }
        if (this.blockSelection && this.blockXLocation != -1) {
            gC.setBackground(this.getSelectionBackground());
            Rectangle rectangle = this.getBlockSelectionRectangle();
            gC.drawRectangle(rectangle.x, rectangle.y, Math.max(1, rectangle.width - 1), Math.max(1, rectangle.height - 1));
            gC.setAdvanced(true);
            if (gC.getAdvanced()) {
                gC.setAlpha(100);
                gC.fillRectangle(rectangle);
                gC.setAdvanced(false);
            }
        }
        gC.setBackground(this.marginColor != null ? this.marginColor : color);
        if (this.topMargin > 0) {
            this.drawBackground(gC, 0, 0, this.clientAreaWidth, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            this.drawBackground(gC, 0, this.clientAreaHeight - this.bottomMargin, this.clientAreaWidth, this.bottomMargin);
        }
        if (this.leftMargin - this.alignmentMargin > 0) {
            this.drawBackground(gC, 0, 0, this.leftMargin - this.alignmentMargin, this.clientAreaHeight);
        }
        if (this.rightMargin > 0) {
            this.drawBackground(gC, this.clientAreaWidth - this.rightMargin, 0, this.rightMargin, this.clientAreaHeight);
        }
    }

    void handleResize(Event event) {
        int n;
        int n2 = this.clientAreaHeight;
        int n3 = this.clientAreaWidth;
        Rectangle rectangle = this.getClientArea();
        this.clientAreaHeight = rectangle.height;
        this.clientAreaWidth = rectangle.width;
        if (n3 != this.clientAreaWidth && this.rightMargin > 0) {
            n = (n3 < this.clientAreaWidth ? n3 : this.clientAreaWidth) - this.rightMargin;
            super.redraw(n, 0, this.rightMargin, n2, false);
        }
        if (n2 != this.clientAreaHeight && this.bottomMargin > 0) {
            n = (n2 < this.clientAreaHeight ? n2 : this.clientAreaHeight) - this.bottomMargin;
            super.redraw(0, n, n3, this.bottomMargin, false);
        }
        if (this.wordWrap) {
            if (n3 != this.clientAreaWidth) {
                this.renderer.reset(0, this.content.getLineCount());
                this.verticalScrollOffset = -1;
                this.renderer.calculateIdle();
                super.redraw();
            }
            if (n2 != this.clientAreaHeight) {
                if (n2 == 0) {
                    this.topIndexY = 0;
                }
                this.setScrollBars(true);
            }
            this.setCaretLocation();
        } else {
            ScrollBar scrollBar;
            this.renderer.calculateClientArea();
            this.setScrollBars(true);
            this.claimRightFreeSpace();
            if (this.clientAreaWidth != 0 && (scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible() && this.horizontalScrollOffset != scrollBar.getSelection()) {
                scrollBar.setSelection(this.horizontalScrollOffset);
                this.horizontalScrollOffset = scrollBar.getSelection();
            }
        }
        this.updateCaretVisibility();
        this.claimBottomFreeSpace();
        this.setAlignment();
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        int n = this.ime.getCompositionOffset();
        if (n != -1 && this.lastTextChangeStart < n) {
            this.ime.setCompositionOffset(n + this.lastTextChangeNewCharCount - this.lastTextChangeReplaceCharCount);
        }
        int n2 = this.content.getLineAtOffset(this.lastTextChangeStart);
        this.resetCache(n2, 0);
        if (!this.isFixedLineHeight() && this.topIndex > n2) {
            this.topIndex = n2;
            this.topIndexY = 0;
            super.redraw();
        } else {
            int n3 = n2 + this.lastTextChangeNewLineCount;
            int n4 = this.getLinePixel(n2);
            int n5 = this.getLinePixel(n3 + 1);
            if (this.lastLineBottom != n5) {
                super.redraw();
            } else {
                super.redraw(0, n4, this.clientAreaWidth, n5 - n4, false);
                this.redrawLinesBullet(this.renderer.redrawLines);
            }
        }
        this.renderer.redrawLines = null;
        if (!this.blockSelection || this.blockXLocation == -1) {
            this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        }
        if (this.lastTextChangeReplaceLineCount > 0 || this.wordWrap) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
        this.sendAccessibleTextChanged(this.lastTextChangeStart, this.lastTextChangeNewCharCount, 0);
        this.lastCharCount += this.lastTextChangeNewCharCount;
        this.lastCharCount -= this.lastTextChangeReplaceCharCount;
        this.setAlignment();
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n2 = this.content.getLineAtOffset(textChangingEvent.start);
        int n3 = this.getLinePixel(n2 + textChangingEvent.replaceLineCount + 1);
        this.lastLineBottom = n = this.getLinePixel(n2 + 1) + textChangingEvent.newLineCount * this.renderer.getLineHeight();
        if (n3 < 0 && n < 0) {
            this.lastLineBottom += n3 - n;
            this.verticalScrollOffset += n - n3;
            this.calculateTopIndex(n - n3);
            this.setScrollBars(true);
        } else {
            this.scrollText(n3, n);
        }
        this.sendAccessibleTextChanged(this.lastTextChangeStart, 0, this.lastTextChangeReplaceCharCount);
        this.renderer.textChanging(textChangingEvent);
        int n4 = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount;
        if (this.caretOffset > n4) {
            this.setCaretOffset(n4, -1);
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
        int n = this.getCharCount();
        this.sendAccessibleTextChanged(0, n, this.lastCharCount);
        this.lastCharCount = n;
        this.setAlignment();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        int n = this.getVerticalBar().getSelection() - this.getVerticalScrollOffset();
        this.scrollVertical(n, false);
    }

    void initializeAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                String string2 = StyledText.this.getAssociatedLabel();
                if (string2 != null) {
                    string = StyledText.this.stripMnemonic(string2);
                }
                accessibleEvent.result = string;
            }

            @Override
            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = StyledText.this.getToolTipText();
            }

            @Override
            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string = null;
                String string2 = StyledText.this.getAssociatedLabel();
                if (string2 != null && (c = StyledText.this._findMnemonic(string2)) != '\u0000') {
                    string = "Alt+" + c;
                }
                accessibleEvent.result = string;
            }
        });
        accessible.addAccessibleTextListener(new AccessibleTextExtendedAdapter(){

            @Override
            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = StyledText.this.getCaretOffset();
            }

            @Override
            public void setCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                StyledText.this.setCaretOffset(accessibleTextEvent.offset);
                accessibleTextEvent.result = "OK";
            }

            @Override
            public void getSelectionRange(AccessibleTextEvent accessibleTextEvent) {
                Point point = StyledText.this.getSelectionRange();
                accessibleTextEvent.offset = point.x;
                accessibleTextEvent.length = point.y;
            }

            @Override
            public void addSelection(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                Point point = styledText.getSelection();
                if (point.x == point.y) {
                    int n = accessibleTextEvent.end;
                    if (n == -1) {
                        n = styledText.getCharCount();
                    }
                    styledText.setSelection(accessibleTextEvent.start, n);
                    accessibleTextEvent.result = "OK";
                }
            }

            @Override
            public void getSelection(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                if (styledText.blockSelection && styledText.blockXLocation != -1) {
                    Rectangle rectangle = styledText.getBlockSelectionPosition();
                    int n = rectangle.y + accessibleTextEvent.index;
                    int n2 = styledText.getLinePixel(n);
                    accessibleTextEvent.ranges = this.getRanges(rectangle.x, n2, rectangle.width, n2);
                    if (accessibleTextEvent.ranges.length > 0) {
                        accessibleTextEvent.start = accessibleTextEvent.ranges[0];
                        accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
                    }
                } else if (accessibleTextEvent.index == 0) {
                    Point point = styledText.getSelection();
                    accessibleTextEvent.start = point.x;
                    accessibleTextEvent.end = point.y;
                    if (accessibleTextEvent.start > accessibleTextEvent.end) {
                        int n = accessibleTextEvent.start;
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n;
                    }
                }
            }

            @Override
            public void getSelectionCount(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                if (styledText.blockSelection && styledText.blockXLocation != -1) {
                    Rectangle rectangle = styledText.getBlockSelectionPosition();
                    accessibleTextEvent.count = rectangle.height - rectangle.y + 1;
                } else {
                    Point point = styledText.getSelection();
                    accessibleTextEvent.count = point.x == point.y ? 0 : 1;
                }
            }

            @Override
            public void removeSelection(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                if (accessibleTextEvent.index == 0) {
                    if (styledText.blockSelection) {
                        styledText.clearBlockSelection(true, false);
                    } else {
                        styledText.clearSelection(false);
                    }
                    accessibleTextEvent.result = "OK";
                }
            }

            @Override
            public void setSelection(AccessibleTextEvent accessibleTextEvent) {
                if (accessibleTextEvent.index != 0) {
                    return;
                }
                StyledText styledText = StyledText.this;
                Point point = styledText.getSelection();
                if (point.x == point.y) {
                    return;
                }
                int n = accessibleTextEvent.end;
                if (n == -1) {
                    n = styledText.getCharCount();
                }
                styledText.setSelection(accessibleTextEvent.start, n);
                accessibleTextEvent.result = "OK";
            }

            @Override
            public void getCharacterCount(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.count = StyledText.this.getCharCount();
            }

            @Override
            public void getOffsetAtPoint(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
                Display display = styledText.getDisplay();
                point = display.map(null, (Control)styledText, point);
                accessibleTextEvent.offset = styledText.getOffsetAtPoint(point.x, point.y, null, true);
            }

            @Override
            public void getTextBounds(AccessibleTextEvent accessibleTextEvent) {
                int n;
                StyledText styledText = StyledText.this;
                int n2 = accessibleTextEvent.start;
                int n3 = accessibleTextEvent.end;
                int n4 = styledText.getCharCount();
                if ((n2 = Math.max(0, Math.min(n2, n4))) > (n3 = Math.max(0, Math.min(n3, n4)))) {
                    n = n2;
                    n2 = n3;
                    n3 = n;
                }
                n = styledText.getLineAtOffset(n2);
                int n5 = styledText.getLineAtOffset(n3);
                Rectangle[] rectangleArray = new Rectangle[n5 - n + 1];
                Rectangle rectangle = null;
                int n6 = 0;
                Display display = styledText.getDisplay();
                for (int i = n; i <= n5; ++i) {
                    Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
                    rectangle2.y = styledText.getLinePixel(i);
                    rectangle2.height = styledText.renderer.getLineHeight(i);
                    rectangle2.x = i == n ? styledText.getPointAtOffset((int)n2).x : styledText.leftMargin - styledText.horizontalScrollOffset;
                    if (i == n5) {
                        rectangle2.width = styledText.getPointAtOffset((int)n3).x - rectangle2.x;
                    } else {
                        TextLayout textLayout = styledText.renderer.getTextLayout(i);
                        rectangle2.width = textLayout.getBounds().width - rectangle2.x;
                        styledText.renderer.disposeTextLayout(textLayout);
                    }
                    rectangleArray[n6++] = rectangle2 = display.map((Control)styledText, null, rectangle2);
                    if (rectangle == null) {
                        rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    rectangle.add(rectangle2);
                }
                accessibleTextEvent.rectangles = rectangleArray;
                if (rectangle != null) {
                    accessibleTextEvent.x = rectangle.x;
                    accessibleTextEvent.y = rectangle.y;
                    accessibleTextEvent.width = rectangle.width;
                    accessibleTextEvent.height = rectangle.height;
                }
            }

            int[] getRanges(int n, int n2, int n3, int n4) {
                StyledText styledText = StyledText.this;
                int n5 = styledText.getLineIndex(n2);
                int n6 = styledText.getLineIndex(n4);
                int n7 = n6 - n5 + 1;
                int[] nArray = new int[n7 * 2];
                int n8 = 0;
                for (int i = n5; i <= n6; ++i) {
                    int[] nArray2;
                    int n9;
                    String string = styledText.content.getLine(i);
                    int n10 = styledText.content.getOffsetAtLine(i);
                    int n11 = n10 + string.length();
                    int n12 = styledText.getLinePixel(i);
                    int n13 = styledText.getOffsetAtPoint(n, n12, null, true);
                    if (n13 == -1) {
                        int n14 = n13 = n < styledText.leftMargin ? n10 : n11;
                    }
                    n9 = (n9 = styledText.getOffsetAtPoint(n3, n12, nArray2 = new int[1], true)) == -1 ? (n3 < styledText.leftMargin ? n10 : n11) : (n9 += nArray2[0]);
                    if (n13 > n9) {
                        int n15 = n13;
                        n13 = n9;
                        n9 = n15;
                    }
                    nArray[n8++] = n13;
                    nArray[n8++] = n9;
                }
                return nArray;
            }

            @Override
            public void getRanges(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
                Display display = styledText.getDisplay();
                point = display.map(null, (Control)styledText, point);
                accessibleTextEvent.ranges = this.getRanges(point.x, point.y, point.x + accessibleTextEvent.width, point.y + accessibleTextEvent.height);
                if (accessibleTextEvent.ranges.length > 0) {
                    accessibleTextEvent.start = accessibleTextEvent.ranges[0];
                    accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
                }
            }

            @Override
            public void getText(AccessibleTextEvent accessibleTextEvent) {
                int n;
                StyledText styledText = StyledText.this;
                int n2 = accessibleTextEvent.start;
                int n3 = accessibleTextEvent.end;
                int n4 = styledText.getCharCount();
                if (n3 == -1) {
                    n3 = n4;
                }
                if ((n2 = Math.max(0, Math.min(n2, n4))) > (n3 = Math.max(0, Math.min(n3, n4)))) {
                    n = n2;
                    n2 = n3;
                    n3 = n;
                }
                n = accessibleTextEvent.count;
                switch (accessibleTextEvent.type) {
                    case 5: {
                        break;
                    }
                    case 0: {
                        int n5 = 0;
                        if (n > 0) {
                            int n6;
                            while (n-- > 0 && (n6 = styledText.getWordNext(n3, 2)) != n4 && n6 != n3) {
                                n3 = n6;
                                ++n5;
                            }
                            n2 = n3;
                            n3 = styledText.getWordNext(n3, 2);
                        } else {
                            int n7;
                            while (n++ < 0 && (n7 = styledText.getWordPrevious(n2, 2)) != n2) {
                                n2 = n7;
                                --n5;
                            }
                            n3 = styledText.getWordNext(n2, 2);
                        }
                        n = n5;
                        break;
                    }
                    case 1: {
                        int n8 = 0;
                        if (n > 0) {
                            int n9;
                            while (n-- > 0 && (n9 = styledText.getWordNext(n3, 16, true)) != n3) {
                                ++n8;
                                n3 = n9;
                            }
                            n2 = n3;
                            n3 = styledText.getWordNext(n2, 8, true);
                        } else {
                            int n10;
                            if (styledText.getWordPrevious(Math.min(n2 + 1, n4), 16, true) == n2) {
                                ++n;
                            }
                            while (n <= 0 && (n10 = styledText.getWordPrevious(n2, 16, true)) != n2) {
                                n2 = n10;
                                if (++n == 0) continue;
                                --n8;
                            }
                            n3 = n <= 0 && n2 == 0 ? n2 : styledText.getWordNext(n2, 8, true);
                        }
                        n = n8;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        int n11 = n > 0 ? n3 : n2;
                        int n12 = styledText.getLineAtOffset(n11) + n;
                        n12 = Math.max(0, Math.min(n12, styledText.getLineCount() - 1));
                        n2 = styledText.getOffsetAtLine(n12);
                        String string = styledText.getLine(n12);
                        n3 = n2 + string.length();
                        n = n12 - styledText.getLineAtOffset(n11);
                        break;
                    }
                }
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n3;
                accessibleTextEvent.count = n;
                accessibleTextEvent.result = styledText.content.getTextRange(n2, n3 - n2);
            }

            @Override
            public void getVisibleRanges(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.ranges = this.getRanges(StyledText.this.leftMargin, StyledText.this.topMargin, StyledText.this.clientAreaWidth - StyledText.this.rightMargin, StyledText.this.clientAreaHeight - StyledText.this.bottomMargin);
                if (accessibleTextEvent.ranges.length > 0) {
                    accessibleTextEvent.start = accessibleTextEvent.ranges[0];
                    accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
                }
            }

            @Override
            public void scrollText(AccessibleTextEvent accessibleTextEvent) {
                StyledText styledText = StyledText.this;
                int n = StyledText.this.getTopPixel();
                int n2 = styledText.getHorizontalPixel();
                switch (accessibleTextEvent.type) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.start);
                        if (accessibleTextEvent.type != 2) {
                            n2 = n2 + rectangle.x - styledText.leftMargin;
                        }
                        if (accessibleTextEvent.type == 4) break;
                        n = n + rectangle.y - styledText.topMargin;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.end - 1);
                        if (accessibleTextEvent.type != 3) {
                            n2 = n2 - styledText.clientAreaWidth + rectangle.x + rectangle.width + styledText.rightMargin;
                        }
                        if (accessibleTextEvent.type == 5) break;
                        n = n - styledText.clientAreaHeight + rectangle.y + rectangle.height + styledText.bottomMargin;
                        break;
                    }
                    case 7: {
                        Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
                        Display display = styledText.getDisplay();
                        point = display.map(null, (Control)styledText, point);
                        Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.start);
                        n = n - point.y + rectangle.y;
                        n2 = n2 - point.x + rectangle.x;
                        break;
                    }
                }
                styledText.setTopPixel(n);
                styledText.setHorizontalPixel(n2);
                accessibleTextEvent.result = "OK";
            }
        });
        accessible.addAccessibleAttributeListener(new AccessibleAttributeAdapter(){

            @Override
            public void getAttributes(AccessibleAttributeEvent accessibleAttributeEvent) {
                StyledText styledText = StyledText.this;
                accessibleAttributeEvent.leftMargin = styledText.getLeftMargin();
                accessibleAttributeEvent.topMargin = styledText.getTopMargin();
                accessibleAttributeEvent.rightMargin = styledText.getRightMargin();
                accessibleAttributeEvent.bottomMargin = styledText.getBottomMargin();
                accessibleAttributeEvent.tabStops = styledText.getTabStops();
                accessibleAttributeEvent.justify = styledText.getJustify();
                accessibleAttributeEvent.alignment = styledText.getAlignment();
                accessibleAttributeEvent.indent = styledText.getIndent();
            }

            @Override
            public void getTextAttributes(AccessibleTextAttributeEvent accessibleTextAttributeEvent) {
                Object object;
                StyledText styledText = StyledText.this;
                int n = styledText.getCharCount();
                if (!StyledText.this.isListening(3002) && styledText.renderer.styleCount == 0) {
                    accessibleTextAttributeEvent.start = 0;
                    accessibleTextAttributeEvent.end = n;
                    accessibleTextAttributeEvent.textStyle = new TextStyle(styledText.getFont(), styledText.foreground, styledText.background);
                    return;
                }
                int n2 = Math.max(0, Math.min(accessibleTextAttributeEvent.offset, n - 1));
                int n3 = styledText.getLineAtOffset(n2);
                int n4 = styledText.getOffsetAtLine(n3);
                int n5 = styledText.getLineCount();
                n2 -= n4;
                TextLayout textLayout = styledText.renderer.getTextLayout(n3);
                int n6 = textLayout.getText().length();
                if (n6 > 0) {
                    accessibleTextAttributeEvent.textStyle = textLayout.getStyle(Math.max(0, Math.min(n2, n6 - 1)));
                }
                if (accessibleTextAttributeEvent.textStyle == null) {
                    accessibleTextAttributeEvent.textStyle = new TextStyle(styledText.getFont(), styledText.foreground, styledText.background);
                } else if (accessibleTextAttributeEvent.textStyle.foreground == null || accessibleTextAttributeEvent.textStyle.background == null || accessibleTextAttributeEvent.textStyle.font == null) {
                    object = new TextStyle(accessibleTextAttributeEvent.textStyle);
                    if (((TextStyle)object).foreground == null) {
                        ((TextStyle)object).foreground = styledText.foreground;
                    }
                    if (((TextStyle)object).background == null) {
                        ((TextStyle)object).background = styledText.background;
                    }
                    if (((TextStyle)object).font == null) {
                        ((TextStyle)object).font = styledText.getFont();
                    }
                    accessibleTextAttributeEvent.textStyle = object;
                }
                if (n2 >= n6) {
                    accessibleTextAttributeEvent.start = n4 + n6;
                    accessibleTextAttributeEvent.end = n3 + 1 < n5 ? styledText.getOffsetAtLine(n3 + 1) : n;
                    return;
                }
                object = textLayout.getRanges();
                styledText.renderer.disposeTextLayout(textLayout);
                int n7 = 0;
                Object object2 = 0;
                while (n7 < ((Object)object).length) {
                    Object object3 = object[n7++];
                    Object object4 = object[n7++];
                    if (object3 <= n2 && n2 <= object4) {
                        accessibleTextAttributeEvent.start = n4 + object3;
                        accessibleTextAttributeEvent.end = n4 + object4 + 1;
                        return;
                    }
                    if (object3 > n2) {
                        accessibleTextAttributeEvent.start = n4 + object2;
                        accessibleTextAttributeEvent.end = n4 + object3;
                        return;
                    }
                    object2 = object4 + true;
                }
                if (n7 == ((Object)object).length) {
                    accessibleTextAttributeEvent.start = n4 + object2;
                    accessibleTextAttributeEvent.end = n3 + 1 < n5 ? styledText.getOffsetAtLine(n3 + 1) : n;
                }
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 42;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                if (StyledText.this.isEnabled()) {
                    n |= 0x100000;
                }
                if (StyledText.this.isFocusControl()) {
                    n |= 4;
                }
                if (!StyledText.this.isVisible()) {
                    n |= 0x8000;
                }
                if (!StyledText.this.getEditable()) {
                    n |= 0x40;
                }
                n = StyledText.this.isSingleLine() ? (n |= 0x8000000) : (n |= 0x10000000);
                accessibleControlEvent.detail = n;
            }

            @Override
            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = StyledText.this.getText();
            }
        });
        this.addListener(15, new Listener(){

            @Override
            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    String getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] != this) continue;
            if (i <= 0) break;
            Control control = controlArray[i - 1];
            if (control instanceof Label) {
                return ((Label)control).getText();
            }
            if (!(control instanceof CLabel)) break;
            return ((CLabel)control).getText();
        }
        return null;
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return string.substring(0, n - 1) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    public void invokeAction(int n) {
        this.checkWidget();
        if (this.blockSelection && this.invokeBlockAction(n)) {
            return;
        }
        this.updateCaretDirection = true;
        switch (n) {
            case 0x1000001: {
                this.doLineUp(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, -1);
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, -1);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(-1);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(-1);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
                break;
            }
            case 0x100000A: {
                this.setBlockSelection(!this.blockSelection);
            }
        }
    }

    boolean invokeBlockAction(int n) {
        switch (n) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 17039363: 
            case 0x1040004: 
            case 17039365: 
            case 17039366: 
            case 17039367: 
            case 17039368: {
                this.clearBlockSelection(false, false);
                return false;
            }
            case 0x1020001: {
                this.doBlockLineVertical(true);
                return true;
            }
            case 0x1020002: {
                this.doBlockLineVertical(false);
                return true;
            }
            case 16908295: {
                this.doBlockLineHorizontal(false);
                return true;
            }
            case 16908296: {
                this.doBlockLineHorizontal(true);
                return false;
            }
            case 16908291: {
                this.doBlockColumn(false);
                return true;
            }
            case 16908292: {
                this.doBlockColumn(true);
                return true;
            }
            case 17170435: {
                this.doBlockWord(false);
                return true;
            }
            case 17170436: {
                this.doBlockWord(true);
                return true;
            }
            case 262209: {
                return false;
            }
            case 16908293: 
            case 16908294: 
            case 17170437: 
            case 0x1060006: 
            case 17170439: 
            case 17170440: {
                return true;
            }
            case 131199: 
            case 16908297: 
            case 17039369: {
                return false;
            }
            case 8: 
            case 127: {
                if (this.blockXLocation != -1) {
                    this.insertBlockSelectionText('\u0000', n);
                    return true;
                }
                return false;
            }
            case 262152: 
            case 262271: {
                return this.blockXLocation != -1;
            }
        }
        return false;
    }

    boolean isBidi() {
        return IS_GTK || IS_MAC || BidiUtil.isBidiPlatform() || this.isMirrored;
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    boolean isFixedLineHeight() {
        return this.fixedLineHeight;
    }

    boolean isLineDelimiter(int n) {
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        return n4 > this.content.getLine(n2).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean bl) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n);
            }
            if (bl && event.text.length() == 0) {
                int n2 = this.content.getLineAtOffset(event.start);
                int n3 = this.content.getOffsetAtLine(n2);
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n4 = textLayout.getLevel(event.start - n3);
                int n5 = this.content.getLineAtOffset(event.end);
                if (n2 != n5) {
                    this.renderer.disposeTextLayout(textLayout);
                    n3 = this.content.getOffsetAtLine(n5);
                    textLayout = this.renderer.getTextLayout(n5);
                }
                int n6 = textLayout.getLevel(event.end - n3);
                this.renderer.disposeTextLayout(textLayout);
                this.caretAlignment = n4 != n6 ? 0 : 1;
            }
            this.content.replaceTextRange(event.start, n, event.text);
            if (bl && (!this.blockSelection || this.blockXLocation == -1)) {
                this.setSelection(event.start + event.text.length(), 0, true, false);
                this.showCaret();
            }
            this.notifyListeners(24, event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    void paintObject(GC gC, int n, int n2, int n3, int n4, StyleRange styleRange, Bullet bullet, int n5) {
        if (this.isListening(3008)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.gc = gC;
            styledTextEvent.x = n;
            styledTextEvent.y = n2;
            styledTextEvent.ascent = n3;
            styledTextEvent.descent = n4;
            styledTextEvent.style = styleRange;
            styledTextEvent.bullet = bullet;
            styledTextEvent.bulletIndex = n5;
            this.notifyListeners(3008, styledTextEvent);
        }
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            if (this.blockSelection) {
                boolean bl = this.isFixedLineHeight() && this.renderer.fixedPitch;
                int n = this.insertBlockSelectionText(string, bl);
                this.setCaretOffset(n, -1);
                this.clearBlockSelection(true, true);
                this.setCaretLocation();
                return;
            }
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new Printing(this, printer, styledTextPrintOptions);
    }

    @Override
    public void redraw() {
        super.redraw();
        int n = this.getPartialBottomIndex() - this.topIndex + 1;
        this.renderer.reset(this.topIndex, n);
        this.renderer.calculate(this.topIndex, n);
        this.setScrollBars(false);
        this.doMouseLinkCursor();
    }

    @Override
    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, bl);
        if (n4 > 0) {
            int n5 = this.getLineIndex(n2);
            int n6 = this.getLineIndex(n2 + n4);
            this.resetCache(n5, n6 - n5 + 1);
            this.doMouseLinkCursor();
        }
    }

    void redrawLines(int n, int n2, boolean bl) {
        int n3 = n + n2 - 1;
        int n4 = this.getPartialBottomIndex();
        int n5 = this.getPartialTopIndex();
        if (n > n4 || n3 < n5) {
            return;
        }
        if (n < n5) {
            n = n5;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        int n6 = this.getLinePixel(n);
        int n7 = this.getLinePixel(n3 + 1);
        if (bl) {
            n7 = this.clientAreaHeight - this.bottomMargin;
        }
        int n8 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        super.redraw(this.leftMargin, n6, n8, n7 - n6, true);
    }

    void redrawLinesBullet(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = this.getPartialTopIndex();
        int n2 = this.getPartialBottomIndex();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n > n3 || n3 > n2) continue;
            int n4 = -1;
            Bullet bullet = this.renderer.getLineBullet(n3, null);
            if (bullet != null) {
                StyleRange styleRange = bullet.style;
                GlyphMetrics glyphMetrics = styleRange.metrics;
                n4 = glyphMetrics.width;
            }
            if (n4 == -1) {
                n4 = this.getClientArea().width;
            }
            int n5 = this.renderer.getLineHeight(n3);
            int n6 = this.getLinePixel(n3);
            super.redraw(0, n6, n4, n5, false);
        }
    }

    public void redrawRange(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n + n2;
        int n4 = this.content.getCharCount();
        if (n > n3 || n < 0 || n3 > n4) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n3);
        this.resetCache(n5, n6 - n5 + 1);
        this.internalRedrawRange(n, n2);
        this.doMouseLinkCursor();
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.checkWidget();
        if (caretListener == null) {
            SWT.error(4);
        }
        this.removeListener(3011, caretListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
        this.setCaretLocation();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removePaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.removeListener(3008, paintObjectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void removeWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (movementListener == null) {
            SWT.error(4);
        }
        this.removeListener(3009, movementListener);
        this.removeListener(3010, movementListener);
    }

    public void replaceStyleRanges(int n, int n2, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(n, n2, null, styleRangeArray, false);
    }

    public void replaceTextRange(int n, int n2, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        Event event = new Event();
        event.start = n;
        event.end = n4;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.setCaretOffset(0, -1);
        this.topIndex = 0;
        this.topIndexY = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        this.renderer.setContent(this.content);
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.resetCache(0, 0);
        this.setCaretLocation();
        super.redraw();
    }

    void resetCache(int n, int n2) {
        int n3 = this.renderer.maxWidthLineIndex;
        this.renderer.reset(n, n2);
        this.renderer.calculateClientArea();
        if (0 <= n3 && n3 < this.content.getLineCount()) {
            this.renderer.calculate(n3, 1);
        }
        this.setScrollBars(true);
        if (!this.isFixedLineHeight()) {
            if (this.topIndex > n) {
                this.verticalScrollOffset = -1;
            }
            this.renderer.calculateIdle();
        }
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
        this.sendAccessibleTextCaretMoved();
    }

    @Override
    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super.scroll(n, n2, n3, n4, n5, n6, false);
        if (bl) {
            int n7 = n - n3;
            int n8 = n2 - n4;
            Control[] controlArray = this.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x + n7, rectangle.y + n8);
            }
        }
    }

    boolean scrollHorizontal(int n, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (this.wordWrap) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && bl) {
            scrollBar.setSelection(this.horizontalScrollOffset + n);
        }
        int n2 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n > 0) {
            int n3 = this.leftMargin + n;
            int n4 = this.clientAreaWidth - n3 - this.rightMargin;
            if (n4 > 0) {
                this.scroll(this.leftMargin, this.topMargin, n3, this.topMargin, n4, n2, true);
            }
            if (n3 > n4) {
                super.redraw(this.leftMargin + n4, this.topMargin, n - n4, n2, true);
            }
        } else {
            int n5 = this.leftMargin - n;
            int n6 = this.clientAreaWidth - n5 - this.rightMargin;
            if (n6 > 0) {
                this.scroll(n5, this.topMargin, this.leftMargin, this.topMargin, n6, n2, true);
            }
            if (n5 > n6) {
                super.redraw(this.leftMargin + n6, this.topMargin, -n - n6, n2, true);
            }
        }
        this.horizontalScrollOffset += n;
        this.setCaretLocation();
        return true;
    }

    boolean scrollVertical(int n, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (this.verticalScrollOffset != -1) {
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null && bl) {
                scrollBar.setSelection(this.verticalScrollOffset + n);
            }
            int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            if (n > 0) {
                int n3 = this.topMargin + n;
                int n4 = this.clientAreaHeight - n3 - this.bottomMargin;
                if (n4 > 0) {
                    this.scroll(this.leftMargin, this.topMargin, this.leftMargin, n3, n2, n4, true);
                }
                if (n3 > n4) {
                    int n5 = Math.max(0, this.topMargin + n4);
                    int n6 = Math.min(this.clientAreaHeight, n - n4);
                    super.redraw(this.leftMargin, n5, n2, n6, true);
                }
            } else {
                int n7 = this.topMargin - n;
                int n8 = this.clientAreaHeight - n7 - this.bottomMargin;
                if (n8 > 0) {
                    this.scroll(this.leftMargin, n7, this.leftMargin, this.topMargin, n2, n8, true);
                }
                if (n7 > n8) {
                    int n9 = Math.max(0, this.topMargin + n8);
                    int n10 = Math.min(this.clientAreaHeight, -n - n8);
                    super.redraw(this.leftMargin, n9, n2, n10, true);
                }
            }
            this.verticalScrollOffset += n;
            this.calculateTopIndex(n);
        } else {
            this.calculateTopIndex(n);
            super.redraw();
        }
        this.setCaretLocation();
        return true;
    }

    void scrollText(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = n2 - n;
        int n4 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n5 = n3 > 0 ? this.clientAreaHeight - n - this.bottomMargin : this.clientAreaHeight - n2 - this.bottomMargin;
        this.scroll(this.leftMargin, n2, this.leftMargin, n, n4, n5, true);
        if (0 < n + n5 && this.topMargin > n) {
            super.redraw(this.leftMargin, n3, n4, this.topMargin, false);
        }
        if (0 < n2 + n5 && this.topMargin > n2) {
            super.redraw(this.leftMargin, 0, n4, this.topMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n + n5 && this.clientAreaHeight > n) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin + n3, n4, this.bottomMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n2 + n5 && this.clientAreaHeight > n2) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin, n4, this.bottomMargin, false);
        }
    }

    void sendAccessibleTextCaretMoved() {
        if (this.caretOffset != this.accCaretOffset) {
            this.accCaretOffset = this.caretOffset;
            this.getAccessible().textCaretMoved(this.caretOffset);
        }
    }

    void sendAccessibleTextChanged(int n, int n2, int n3) {
        Accessible accessible = this.getAccessible();
        if (n3 != 0) {
            accessible.textChanged(1, n, n3);
        }
        if (n2 != 0) {
            accessible.textChanged(0, n, n2);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if (this.blockSelection) {
            this.renderer.calculate(0, this.content.getLineCount());
            this.setScrollBars(false);
            int n = this.getVerticalScrollOffset();
            int n2 = this.leftMargin - this.horizontalScrollOffset;
            int n3 = this.topMargin - n;
            int n4 = this.renderer.getWidth() - this.rightMargin - this.horizontalScrollOffset;
            int n5 = this.renderer.getHeight() - this.bottomMargin - n;
            this.setBlockSelectionLocation(n2, n3, n4, n5, false);
            return;
        }
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (this.editable) {
            this.modifyContent(event, true);
        }
    }

    StyledTextEvent sendLineEvent(int n, int n2, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n)) {
            styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n2;
            styledTextEvent.text = string;
            styledTextEvent.alignment = this.alignment;
            styledTextEvent.indent = this.indent;
            styledTextEvent.wrapIndent = this.wrapIndent;
            styledTextEvent.justify = this.justify;
            this.notifyListeners(n, styledTextEvent);
        }
        return styledTextEvent;
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    int sendTextEvent(int n, int n2, int n3, String string, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 < this.content.getLineCount()) {
            object = new int[1];
            n7 = this.getOffsetAtPoint(n, this.getLinePixel(n3), (int[])object, true);
            if (n7 == -1) {
                n6 = this.content.getOffsetAtLine(n3);
                n5 = this.content.getLine(n3).length();
                n7 = n4 = n6 + n5;
                if (bl) {
                    TextLayout textLayout = this.renderer.getTextLayout(n3);
                    n8 = textLayout.getBounds().width;
                    this.renderer.disposeTextLayout(textLayout);
                }
            } else {
                n4 = n == n2 ? (n7 += object[0]) : this.getOffsetAtPoint(n2, 0, n3, null);
                bl = false;
            }
        } else {
            n7 = n4 = this.content.getCharCount();
            stringBuffer.append(this.content.getLineDelimiter());
        }
        if (n7 > n4) {
            int n9 = n7;
            n7 = n4;
            n4 = n9;
        }
        if (bl) {
            int n10 = n - n8 + this.horizontalScrollOffset - this.leftMargin;
            n6 = n10 / this.renderer.averageCharWidth;
            for (n5 = 0; n5 < n6; ++n5) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(string);
        object = new Event();
        object.start = n7;
        object.end = n4;
        object.text = stringBuffer.toString();
        this.sendKeyEvent((Event)object);
        return object.start + object.text.length();
    }

    int sendWordBoundaryEvent(int n, int n2, int n3, int n4, String string, int n5) {
        if (this.isListening(n)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n5;
            styledTextEvent.text = string;
            styledTextEvent.count = n2;
            styledTextEvent.start = n3;
            styledTextEvent.end = n4;
            this.notifyListeners(n, styledTextEvent);
            n3 = styledTextEvent.end;
            if (n3 != n4) {
                int n6 = this.getCharCount();
                if (n3 < 0) {
                    n3 = 0;
                } else if (n3 > n6) {
                    n3 = n6;
                } else if (this.isLineDelimiter(n3)) {
                    SWT.error(5);
                }
            }
            return n3;
        }
        return n4;
    }

    void setAlignment() {
        if ((this.getStyle() & 4) == 0) {
            return;
        }
        int n = this.renderer.getLineAlignment(0, this.alignment);
        int n2 = 0;
        if (n != 16384) {
            this.renderer.calculate(0, 1);
            int n3 = this.renderer.getWidth() - this.alignmentMargin;
            n2 = this.clientAreaWidth - n3;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n == 0x1000000) {
                n2 /= 2;
            }
        }
        if (this.alignmentMargin != n2) {
            this.leftMargin -= this.alignmentMargin;
            this.leftMargin += n2;
            this.alignmentMargin = n2;
            this.resetCache(0, 1);
            this.setCaretLocation();
            super.redraw();
        }
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n &= 0x1024000) == 0 || this.alignment == n) {
            return;
        }
        this.alignment = n;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.setAlignment();
        super.redraw();
    }

    @Override
    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.setBackground(color);
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setBlockSelection(boolean bl) {
        int n;
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (bl == this.blockSelection) {
            return;
        }
        if (this.wordWrap) {
            return;
        }
        this.blockSelection = bl;
        if (this.cursor == null) {
            Display display = this.getDisplay();
            n = bl ? 2 : 19;
            super.setCursor(display.getSystemCursor(n));
        }
        if (bl) {
            int n2 = this.selection.x;
            n = this.selection.y;
            if (n2 != n) {
                this.setBlockSelectionOffset(n2, n, false);
            }
        } else {
            this.clearBlockSelection(false, false);
        }
    }

    public void setBlockSelectionBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            SWT.error(4);
        }
        this.setBlockSelectionBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBlockSelectionBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getVerticalScrollOffset();
        if (!this.blockSelection) {
            int n6 = this.getOffsetAtPoint(n -= this.horizontalScrollOffset, n2 -= n5, null);
            int n7 = this.getOffsetAtPoint(n + n3 - 1, n2 + n4 - 1, null);
            this.setSelection(n6, n7 - n6, false, false);
            this.setCaretLocation();
            return;
        }
        int n8 = this.topMargin;
        int n9 = this.leftMargin;
        int n10 = this.renderer.getHeight() - this.bottomMargin;
        int n11 = Math.max(this.clientAreaWidth, this.renderer.getWidth()) - this.rightMargin;
        int n12 = Math.max(n9, Math.min(n11, n)) - this.horizontalScrollOffset;
        int n13 = Math.max(n8, Math.min(n10, n2)) - n5;
        int n14 = Math.max(n9, Math.min(n11, n + n3)) - this.horizontalScrollOffset;
        int n15 = Math.max(n8, Math.min(n10, n2 + n4 - 1)) - n5;
        if (this.isFixedLineHeight() && this.renderer.fixedPitch) {
            int n16 = this.renderer.averageCharWidth;
            n12 = (n12 - this.leftMargin + this.horizontalScrollOffset) / n16 * n16 + this.leftMargin - this.horizontalScrollOffset;
            n14 = (n14 + n16 / 2 - this.leftMargin + this.horizontalScrollOffset) / n16 * n16 + this.leftMargin - this.horizontalScrollOffset;
        }
        this.setBlockSelectionLocation(n12, n13, n14, n15, false);
    }

    void setBlockSelectionLocation(int n, int n2, boolean bl) {
        int n3 = this.getVerticalScrollOffset();
        this.blockXLocation = n + this.horizontalScrollOffset;
        this.blockYLocation = n2 + n3;
        int[] nArray = new int[1];
        int n4 = this.getOffsetAtPoint(n, n2, nArray);
        this.setCaretOffset(n4, nArray[0]);
        if (this.blockXAnchor == -1) {
            this.blockXAnchor = this.blockXLocation;
            this.blockYAnchor = this.blockYLocation;
            this.selectionAnchor = this.caretOffset;
        }
        this.doBlockSelection(bl);
    }

    void setBlockSelectionLocation(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.getVerticalScrollOffset();
        this.blockXAnchor = n + this.horizontalScrollOffset;
        this.blockYAnchor = n2 + n5;
        this.selectionAnchor = this.getOffsetAtPoint(n, n2, null);
        this.setBlockSelectionLocation(n3, n4, bl);
    }

    void setBlockSelectionOffset(int n, boolean bl) {
        Point point = this.getPointAtOffset(n);
        int n2 = this.getVerticalScrollOffset();
        this.blockXLocation = point.x + this.horizontalScrollOffset;
        this.blockYLocation = point.y + n2;
        this.setCaretOffset(n, -1);
        if (this.blockXAnchor == -1) {
            this.blockXAnchor = this.blockXLocation;
            this.blockYAnchor = this.blockYLocation;
            this.selectionAnchor = this.caretOffset;
        }
        this.doBlockSelection(bl);
    }

    void setBlockSelectionOffset(int n, int n2, boolean bl) {
        int n3 = this.getVerticalScrollOffset();
        Point point = this.getPointAtOffset(n);
        this.blockXAnchor = point.x + this.horizontalScrollOffset;
        this.blockYAnchor = point.y + n3;
        this.selectionAnchor = n;
        this.setBlockSelectionOffset(n2, bl);
    }

    @Override
    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBidiColoring(boolean bl) {
        this.checkWidget();
        this.bidiColoring = bl;
    }

    public void setBottomMargin(int n) {
        this.checkWidget();
        this.setMargins(this.leftMargin, this.topMargin, this.rightMargin, n);
    }

    void setCaretLocation() {
        Point point = this.getPointAtOffset(this.caretOffset);
        this.setCaretLocation(point, this.getCaretDirection());
    }

    void setCaretLocation(Point point, int n) {
        Caret caret = this.getCaret();
        if (caret != null) {
            int n2;
            boolean bl = caret == this.defaultCaret;
            int n3 = n2 = this.renderer.getLineHeight();
            if (!this.isFixedLineHeight() && bl && (n3 = this.getBoundsAtOffset((int)this.caretOffset).height) != n2) {
                n = -1;
            }
            int n4 = n;
            if (this.isMirrored()) {
                if (n4 == 16384) {
                    n4 = 131072;
                } else if (n4 == 131072) {
                    n4 = 16384;
                }
            }
            if (bl && n4 == 131072) {
                point.x -= caret.getSize().x - 1;
            }
            if (bl) {
                caret.setBounds(point.x, point.y, this.caretWidth, n3);
            } else {
                caret.setLocation(point);
            }
            if (n != this.caretDirection) {
                this.caretDirection = n;
                if (bl) {
                    if (n4 == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (n4 == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (n4 == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage(0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage(1);
                }
            }
            this.updateCaretVisibility();
        }
        this.columnX = point.x;
    }

    public void setCaretOffset(int n) {
        this.checkWidget();
        int n2 = this.getCharCount();
        if (n2 > 0 && n != this.caretOffset) {
            if (n < 0) {
                n = 0;
            } else if (n > n2) {
                n = n2;
            } else if (this.isLineDelimiter(n)) {
                SWT.error(5);
            }
            this.setCaretOffset(n, 0);
            if (this.blockSelection) {
                this.clearBlockSelection(true, false);
            } else {
                this.clearSelection(false);
            }
        }
        this.setCaretLocation();
    }

    void setCaretOffset(int n, int n2) {
        if (this.caretOffset != n) {
            this.caretOffset = n;
            if (this.isListening(3011)) {
                StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.end = this.caretOffset;
                this.notifyListeners(3011, styledTextEvent);
            }
        }
        if (n2 != -1) {
            this.caretAlignment = n2;
        }
    }

    void setClipboardContent(int n, int n2, int n3) throws SWTError {
        Transfer[] transferArray;
        Object[] objectArray;
        if (n3 == 2 && !IS_MOTIF && !IS_GTK) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        TextWriter textWriter = new TextWriter(n, n2);
        String string = this.getPlatformDelimitedText(textWriter);
        if (n3 == 2) {
            objectArray = new Object[]{string};
            transferArray = new Transfer[]{textTransfer};
        } else {
            RTFTransfer rTFTransfer = RTFTransfer.getInstance();
            RTFWriter rTFWriter = new RTFWriter(n, n2);
            String string2 = this.getPlatformDelimitedText(rTFWriter);
            objectArray = new Object[]{string2, string};
            transferArray = new Transfer[]{rTFTransfer, textTransfer};
        }
        this.clipboard.setContents(objectArray, transferArray, n3);
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.content = styledTextContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.cursor = cursor;
        if (cursor == null) {
            Display display = this.getDisplay();
            int n = this.blockSelection ? 2 : 19;
            super.setCursor(display.getSystemCursor(n));
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClickEnabled = bl;
    }

    @Override
    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.dragDetect = bl;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.editable = bl;
    }

    @Override
    public void setFont(Font font) {
        int n;
        this.checkWidget();
        int n2 = this.renderer.getLineHeight();
        super.setFont(font);
        this.renderer.setFont(this.getFont(), this.tabLength);
        if (this.isFixedLineHeight() && (n = this.renderer.getLineHeight()) != n2) {
            int n3 = this.getVerticalScrollOffset() * n / n2 - this.getVerticalScrollOffset();
            this.scrollVertical(n3, true);
        }
        this.resetCache(0, this.content.getLineCount());
        this.claimBottomFreeSpace();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    @Override
    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setHorizontalIndex(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.clientAreaWidth > 0 && (n *= this.getHorizontalIncrement()) > (n2 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n = Math.max(0, n2 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n - this.horizontalScrollOffset, true);
    }

    public void setHorizontalPixel(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.clientAreaWidth > 0 && n > (n2 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n = Math.max(0, n2 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n - this.horizontalScrollOffset, true);
    }

    public void setIndent(int n) {
        this.checkWidget();
        if (this.indent == n || n < 0) {
            return;
        }
        this.indent = n;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setJustify(boolean bl) {
        this.checkWidget();
        if (this.justify == bl) {
            return;
        }
        this.justify = bl;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setKeyBinding(int n, int n2) {
        this.checkWidget();
        int n3 = n & SWT.MODIFIER_MASK;
        char c = (char)(n & 0x100FFFF);
        if (Compatibility.isLetter(c)) {
            char c2 = Character.toUpperCase(c);
            int n4 = c2 | n3;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n4));
            } else {
                this.keyActionMap.put(new Integer(n4), new Integer(n2));
            }
            c2 = Character.toLowerCase(c);
            n4 = c2 | n3;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n4));
            } else {
                this.keyActionMap.put(new Integer(n4), new Integer(n2));
            }
        } else if (n2 == 0) {
            this.keyActionMap.remove(new Integer(n));
        } else {
            this.keyActionMap.put(new Integer(n), new Integer(n2));
        }
    }

    public void setLeftMargin(int n) {
        this.checkWidget();
        this.setMargins(n, this.topMargin, this.rightMargin, this.bottomMargin);
    }

    public void setLineAlignment(int n, int n2, int n3) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineAlignment(n, n2, n3);
        this.resetCache(n, n2);
        this.redrawLines(n, n2, false);
        int n4 = this.getCaretLine();
        if (n <= n4 && n4 < n + n2) {
            this.setCaretLocation();
        }
        this.setAlignment();
    }

    public void setLineBackground(int n, int n2, Color color) {
        this.checkWidget();
        if (this.isListening(3001)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (color != null) {
            this.renderer.setLineBackground(n, n2, color);
        } else {
            this.renderer.clearLineBackground(n, n2);
        }
        this.redrawLines(n, n2, false);
    }

    public void setLineBullet(int n, int n2, Bullet bullet) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n3 = this.getLinePixel(n + n2);
        this.renderer.setLineBullet(n, n2, bullet);
        this.resetCache(n, n2);
        int n4 = this.getLinePixel(n + n2);
        this.redrawLines(n, n2, n3 != n4);
        int n5 = this.getCaretLine();
        if (n <= n5 && n5 < n + n2) {
            this.setCaretLocation();
        }
    }

    void setVariableLineHeight() {
        if (!this.fixedLineHeight) {
            return;
        }
        this.fixedLineHeight = false;
        this.renderer.calculateIdle();
    }

    public void setLineIndent(int n, int n2, int n3) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n4 = this.getLinePixel(n + n2);
        this.renderer.setLineIndent(n, n2, n3);
        this.resetCache(n, n2);
        int n5 = this.getLinePixel(n + n2);
        this.redrawLines(n, n2, n4 != n5);
        int n6 = this.getCaretLine();
        if (n <= n6 && n6 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineJustify(int n, int n2, boolean bl) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineJustify(n, n2, bl);
        this.resetCache(n, n2);
        this.redrawLines(n, n2, false);
        int n3 = this.getCaretLine();
        if (n <= n3 && n3 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineSpacing(int n) {
        this.checkWidget();
        if (this.lineSpacing == n || n < 0) {
            return;
        }
        this.lineSpacing = n;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setLineTabStops(int n, int n2, int[] nArray) {
        int n3;
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (nArray != null) {
            n3 = 0;
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < n3) {
                    SWT.error(5);
                }
                nArray2[i] = n3 = nArray[i];
            }
            this.renderer.setLineTabStops(n, n2, nArray2);
        } else {
            this.renderer.setLineTabStops(n, n2, null);
        }
        this.resetCache(n, n2);
        this.redrawLines(n, n2, false);
        n3 = this.getCaretLine();
        if (n <= n3 && n3 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineWrapIndent(int n, int n2, int n3) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n4 = this.getLinePixel(n + n2);
        this.renderer.setLineWrapIndent(n, n2, n3);
        this.resetCache(n, n2);
        int n5 = this.getLinePixel(n + n2);
        this.redrawLines(n, n2, n4 != n5);
        int n6 = this.getCaretLine();
        if (n <= n6 && n6 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setMarginColor(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.marginColor = color;
        super.redraw();
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.leftMargin = Math.max(0, n);
        this.topMargin = Math.max(0, n2);
        this.rightMargin = Math.max(0, n3);
        this.bottomMargin = Math.max(0, n4);
        this.resetCache(0, this.content.getLineCount());
        this.setScrollBars(true);
        this.setCaretLocation();
        this.setAlignment();
        super.redraw();
    }

    void setMouseWordSelectionAnchor() {
        if (this.clickCount > 1) {
            if (this.caretOffset < this.doubleClickSelection.x) {
                this.selectionAnchor = this.doubleClickSelection.y;
            } else if (this.caretOffset > this.doubleClickSelection.y) {
                this.selectionAnchor = this.doubleClickSelection.x;
            }
        }
    }

    public void setOrientation(int n) {
        if ((n & 0x6000000) == 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && (n & 0x2000000) != 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((n & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!BidiUtil.setOrientation(this, n)) {
            return;
        }
        this.isMirrored = (n & 0x4000000) != 0;
        this.caretDirection = 0;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    public void setRightMargin(int n) {
        this.checkWidget();
        this.setMargins(this.leftMargin, this.topMargin, n, this.bottomMargin);
    }

    void setScrollBars(boolean bl) {
        int n;
        ScrollBar scrollBar;
        int n2 = 1;
        if ((bl || !this.isFixedLineHeight()) && (scrollBar = this.getVerticalBar()) != null) {
            n = this.renderer.getHeight();
            if (this.clientAreaHeight < n) {
                scrollBar.setMaximum(n - this.topMargin - this.bottomMargin);
                scrollBar.setThumb(this.clientAreaHeight - this.topMargin - this.bottomMargin);
                scrollBar.setPageIncrement(this.clientAreaHeight - this.topMargin - this.bottomMargin);
            } else if (scrollBar.getThumb() != n2 || scrollBar.getMaximum() != n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, n2, scrollBar.getIncrement(), n2);
            }
        }
        if ((scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible()) {
            n = this.renderer.getWidth();
            if (this.clientAreaWidth < n) {
                scrollBar.setMaximum(n - this.leftMargin - this.rightMargin);
                scrollBar.setThumb(this.clientAreaWidth - this.leftMargin - this.rightMargin);
                scrollBar.setPageIncrement(this.clientAreaWidth - this.leftMargin - this.rightMargin);
            } else if (scrollBar.getThumb() != n2 || scrollBar.getMaximum() != n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, n2, scrollBar.getIncrement(), n2);
            }
        }
    }

    public void setSelection(int n) {
        this.setSelection(n, n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setSelection(int n, int n2) {
        this.setSelectionRange(n, n2 - n);
        this.showSelection();
    }

    void setSelection(int n, int n2, boolean bl, boolean bl2) {
        int n3 = n + n2;
        if (n > n3) {
            int n4 = n3;
            n3 = n;
            n = n4;
        }
        if (this.selection.x != n || this.selection.y != n3 || n2 > 0 && this.selectionAnchor != this.selection.x || n2 < 0 && this.selectionAnchor != this.selection.y) {
            if (this.blockSelection && bl2) {
                this.setBlockSelectionOffset(n, n3, bl);
            } else {
                this.clearSelection(bl);
                if (n2 < 0) {
                    this.selectionAnchor = this.selection.y = n3;
                    this.selection.x = n;
                    this.setCaretOffset(n, 0);
                } else {
                    this.selectionAnchor = this.selection.x = n;
                    this.selection.y = n3;
                    this.setCaretOffset(n3, 0);
                }
                this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x);
                this.sendAccessibleTextCaretMoved();
            }
        }
    }

    public void setSelectionRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        n = Math.max(0, Math.min(n, n3));
        int n4 = n + n2;
        if (n4 < 0) {
            n2 = -n;
        } else if (n4 > n3) {
            n2 = n3 - n;
        }
        if (this.isLineDelimiter(n) || this.isLineDelimiter(n + n2)) {
            SWT.error(5);
        }
        this.setSelection(n, n2, false, true);
        this.setCaretLocation();
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRange != null) {
            if (styleRange.isUnstyled()) {
                this.setStyleRanges(styleRange.start, styleRange.length, null, null, false);
            } else {
                this.setStyleRanges(styleRange.start, 0, null, new StyleRange[]{styleRange}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int n, int n2, int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(n, n2, null, null, false);
        } else {
            this.setStyleRanges(n, n2, nArray, styleRangeArray, false);
        }
    }

    public void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, nArray, styleRangeArray, true);
        }
    }

    void setStyleRanges(int n, int n2, int[] nArray, StyleRange[] styleRangeArray, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.content.getCharCount();
        int n10 = n + n2;
        if (n > n10 || n < 0) {
            SWT.error(6);
        }
        if (styleRangeArray != null) {
            if (n10 > n9) {
                SWT.error(6);
            }
            if (nArray != null && nArray.length != styleRangeArray.length << 1) {
                SWT.error(5);
            }
            n8 = 0;
            n7 = 0;
            for (n6 = 0; n6 < styleRangeArray.length; ++n6) {
                if (styleRangeArray[n6] == null) {
                    SWT.error(5);
                }
                if (nArray != null) {
                    n5 = nArray[n6 << 1];
                    n4 = nArray[(n6 << 1) + 1];
                } else {
                    n5 = styleRangeArray[n6].start;
                    n4 = styleRangeArray[n6].length;
                }
                if (n4 < 0) {
                    SWT.error(5);
                }
                if (0 > n5 || n5 + n4 > n9) {
                    SWT.error(5);
                }
                if (n8 > n5) {
                    SWT.error(5);
                }
                n7 |= styleRangeArray[n6].isVariableHeight();
                n8 = n5 + n4;
            }
            if (n7 != 0) {
                this.setVariableLineHeight();
            }
        }
        n8 = n;
        n7 = n10;
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            if (nArray != null) {
                n8 = nArray[0];
                n7 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            } else {
                n8 = styleRangeArray[0].start;
                n7 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
            }
        }
        n6 = 0;
        if (!this.isFixedLineHeight() && !bl) {
            n5 = this.content.getLineAtOffset(Math.max(n10, n7));
            n4 = this.getPartialTopIndex();
            n3 = this.getPartialBottomIndex();
            if (n4 <= n5 && n5 <= n3) {
                n6 = this.getLinePixel(n5 + 1);
            }
        }
        if (bl) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(n, n2, n2);
        }
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            this.renderer.setStyleRanges(nArray, styleRangeArray);
        }
        if (bl) {
            this.resetCache(0, this.content.getLineCount());
            super.redraw();
        } else {
            n5 = this.content.getLineAtOffset(Math.min(n, n8));
            n4 = this.content.getLineAtOffset(Math.max(n10, n7));
            this.resetCache(n5, n4 - n5 + 1);
            n3 = this.getPartialTopIndex();
            int n11 = this.getPartialBottomIndex();
            if (n5 <= n11 && n4 >= n3) {
                int n12 = 0;
                int n13 = this.clientAreaHeight;
                if (n3 <= n5 && n5 <= n11) {
                    n12 = Math.max(0, this.getLinePixel(n5));
                }
                if (n3 <= n4 && n4 <= n11) {
                    n13 = this.getLinePixel(n4 + 1);
                }
                if (!this.isFixedLineHeight() && n13 != n6) {
                    n13 = this.clientAreaHeight;
                }
                super.redraw(0, n12, this.clientAreaWidth, n13 - n12, false);
            }
        }
        n5 = this.columnX;
        this.setCaretLocation();
        this.columnX = n5;
        this.doMouseLinkCursor();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(0, 0, null, styleRangeArray, true);
    }

    public void setTabs(int n) {
        this.checkWidget();
        this.tabLength = n;
        this.renderer.setFont(null, n);
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setTabStops(int[] nArray) {
        this.checkWidget();
        if (nArray != null) {
            int n = 0;
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < n) {
                    SWT.error(5);
                }
                nArray2[i] = n = nArray[i];
            }
            this.tabs = nArray2;
        } else {
            this.tabs = null;
        }
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Event event = new Event();
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.notifyListeners(24, event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            SWT.error(7);
        }
        this.textLimit = n;
    }

    public void setTopIndex(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        int n3 = this.content.getLineCount();
        if (this.isFixedLineHeight()) {
            int n4 = Math.max(1, Math.min(n3, this.getLineCountWhole()));
            if (n < 0) {
                n = 0;
            } else if (n > n3 - n4) {
                n = n3 - n4;
            }
            n2 = this.getLinePixel(n);
        } else {
            n2 = this.getLinePixel(n = Math.max(0, Math.min(n3 - 1, n)));
            n2 = n2 > 0 ? this.getAvailableHeightBellow(n2) : this.getAvailableHeightAbove(n2);
        }
        this.scrollVertical(n2, true);
    }

    public void setTopMargin(int n) {
        this.checkWidget();
        this.setMargins(this.leftMargin, n, this.rightMargin, this.bottomMargin);
    }

    public void setTopPixel(int n) {
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = this.content.getLineCount();
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        int n4 = this.getVerticalScrollOffset();
        if (this.isFixedLineHeight()) {
            int n5 = Math.max(0, n2 * this.getVerticalIncrement() - n3);
            if (n > n5) {
                n = n5;
            }
            n -= n4;
        } else if ((n -= n4) > 0) {
            n = this.getAvailableHeightBellow(n);
        }
        this.scrollVertical(n, true);
    }

    public void setWordWrap(boolean bl) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (this.wordWrap == bl) {
            return;
        }
        if (this.wordWrap && this.blockSelection) {
            this.setBlockSelection(false);
        }
        this.wordWrap = bl;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.horizontalScrollOffset = 0;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.wordWrap);
        }
        this.setScrollBars(true);
        this.setCaretLocation();
        super.redraw();
    }

    public void setWrapIndent(int n) {
        this.checkWidget();
        if (this.wrapIndent == n || n < 0) {
            return;
        }
        this.wrapIndent = n;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    boolean showLocation(Rectangle rectangle, boolean bl) {
        boolean bl2 = false;
        if (rectangle.y < this.topMargin) {
            bl2 = this.scrollVertical(rectangle.y - this.topMargin, true);
        } else if (rectangle.y + rectangle.height > this.clientAreaHeight - this.bottomMargin) {
            bl2 = this.clientAreaHeight - this.topMargin - this.bottomMargin <= 0 ? this.scrollVertical(rectangle.y - this.topMargin, true) : this.scrollVertical(rectangle.y + rectangle.height - (this.clientAreaHeight - this.bottomMargin), true);
        }
        int n = this.clientAreaWidth - this.rightMargin - this.leftMargin;
        if (n > 0) {
            int n2;
            int n3 = n2 = bl ? n / 4 : 0;
            if (rectangle.x < this.leftMargin) {
                int n4 = Math.max(this.leftMargin - rectangle.x, n2);
                int n5 = this.horizontalScrollOffset;
                bl2 = this.scrollHorizontal(-Math.min(n5, n4), true);
            } else if (rectangle.x + rectangle.width > this.clientAreaWidth - this.rightMargin) {
                int n6 = Math.max(rectangle.x + rectangle.width - (this.clientAreaWidth - this.rightMargin), n2);
                int n7 = this.renderer.getWidth() - this.horizontalScrollOffset - this.clientAreaWidth;
                bl2 = this.scrollHorizontal(Math.min(n7, n6), true);
            }
        }
        return bl2;
    }

    void showCaret() {
        Rectangle rectangle = this.getBoundsAtOffset(this.caretOffset);
        if (!this.showLocation(rectangle, true)) {
            this.setCaretLocation();
        }
    }

    public void showSelection() {
        boolean bl;
        int n;
        int n2;
        boolean bl2;
        this.checkWidget();
        boolean bl3 = bl2 = this.caretOffset == this.selection.x;
        if (bl2) {
            n2 = this.selection.y;
            n = this.selection.x;
        } else {
            n2 = this.selection.x;
            n = this.selection.y;
        }
        Rectangle rectangle = this.getBoundsAtOffset(n2);
        Rectangle rectangle2 = this.getBoundsAtOffset(n);
        int n3 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        boolean bl4 = bl2 ? rectangle.x - rectangle2.x <= n3 : (bl = rectangle2.x - rectangle.x <= n3);
        if (bl) {
            if (this.showLocation(rectangle, false)) {
                rectangle2 = this.getBoundsAtOffset(n);
            }
            rectangle2.width = n == this.caretOffset ? this.getCaretWidth() : 0;
            this.showLocation(rectangle2, false);
        } else {
            this.showLocation(rectangle2, true);
        }
    }

    void updateCaretVisibility() {
        Caret caret = this.getCaret();
        if (caret != null) {
            if (this.blockSelection && this.blockXLocation != -1) {
                caret.setVisible(false);
            } else {
                Point point = caret.getLocation();
                Point point2 = caret.getSize();
                boolean bl = this.topMargin <= point.y + point2.y && point.y <= this.clientAreaHeight - this.bottomMargin && this.leftMargin <= point.x + point2.x && point.x <= this.clientAreaWidth - this.rightMargin;
                caret.setVisible(bl);
            }
        }
    }

    void updateSelection(int n, int n2, int n3) {
        if (this.selection.y <= n) {
            if (this.wordWrap) {
                this.setCaretLocation();
            }
            return;
        }
        if (this.selection.x < n) {
            this.internalRedrawRange(this.selection.x, n - this.selection.x);
        }
        if (this.selection.y > n + n2 && this.selection.x < n + n2) {
            int n4 = n3 - n2;
            int n5 = n + n3;
            this.internalRedrawRange(n5, this.selection.y + n4 - n5);
        }
        if (this.selection.y > n && this.selection.x < n + n2) {
            this.setSelection(n + n3, 0, true, false);
        } else {
            this.setSelection(this.selection.x + n3 - n2, this.selection.y - this.selection.x, true, false);
        }
        this.setCaretLocation();
    }

    static {
        String string = SWT.getPlatform();
        IS_MAC = "carbon".equals(string) || "cocoa".equals(string);
        IS_GTK = "gtk".equals(string);
        IS_MOTIF = "motif".equals(string);
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int n, int n2) {
            this.buffer = new StringBuffer(n2);
            this.startOffset = n;
            this.endOffset = n + n2;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int n) {
            if (n < 0 || n > this.buffer.length()) {
                return;
            }
            this.buffer.insert(n, string);
        }

        void write(int n) {
            this.buffer.append(n);
        }

        void write(char c) {
            this.buffer.append(c);
        }

        public void writeLine(String string, int n) {
            int n2;
            int n3;
            int n4;
            if (this.isClosed) {
                SWT.error(39);
            }
            if ((n4 = this.startOffset - n) >= (n3 = string.length())) {
                return;
            }
            int n5 = n4 > 0 ? n4 : 0;
            if (n5 < (n2 = Math.min(n3, this.endOffset - n))) {
                this.write(string.substring(n5, n2));
            }
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(string);
        }
    }

    class RTFWriter
    extends TextWriter {
        static final int DEFAULT_FOREGROUND = 0;
        static final int DEFAULT_BACKGROUND = 1;
        Vector colorTable;
        Vector fontTable;
        boolean WriteUnicode;

        public RTFWriter(int n, int n2) {
            super(n, n2);
            this.colorTable = new Vector();
            this.fontTable = new Vector();
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.fontTable.addElement(StyledText.this.getFont());
            this.setUnicode();
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int n) {
            if (color == null) {
                return n;
            }
            int n2 = this.colorTable.indexOf(color);
            if (n2 == -1) {
                n2 = this.colorTable.size();
                this.colorTable.addElement(color);
            }
            return n2;
        }

        int getFontIndex(Font font) {
            int n = this.fontTable.indexOf(font);
            if (n == -1) {
                n = this.fontTable.size();
                this.fontTable.addElement(font);
            }
            return n;
        }

        void setUnicode() {
            int n;
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = System.getProperty("os.version");
            int n2 = 0;
            if (string.startsWith("windows nt") && string2 != null && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(0, n);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.WriteUnicode = !string.startsWith("windows 95") && !string.startsWith("windows 98") && !string.startsWith("windows me") && (!string.startsWith("windows nt") || n2 > 4);
        }

        void write(String string, int n, int n2) {
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (c > '\u007f' && this.WriteUnicode) {
                    if (i > n) {
                        this.write(string.substring(n, i));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)c));
                    this.write('?');
                    n = i + 1;
                    continue;
                }
                if (c != '}' && c != '{' && c != '\\') continue;
                if (i > n) {
                    this.write(string.substring(n, i));
                }
                this.write('\\');
                this.write(c);
                n = i + 1;
            }
            if (n < n2) {
                this.write(string.substring(n, n2));
            }
        }

        void writeHeader() {
            Object object;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            stringBuffer.append("{\\rtf1\\ansi");
            String string = System.getProperty("file.encoding").toLowerCase();
            if (string.startsWith("cp") || string.startsWith("ms")) {
                string = string.substring(2, string.length());
                stringBuffer.append("\\ansicpg");
                stringBuffer.append(string);
            }
            stringBuffer.append("\\uc1\\deff0{\\fonttbl{\\f0\\fnil ");
            stringBuffer.append(fontData.getName());
            stringBuffer.append(";");
            for (n = 1; n < this.fontTable.size(); ++n) {
                stringBuffer.append("\\f");
                stringBuffer.append(n);
                stringBuffer.append(" ");
                object = ((Font)this.fontTable.elementAt(n)).getFontData()[0];
                stringBuffer.append(((FontData)object).getName());
                stringBuffer.append(";");
            }
            stringBuffer.append("}}\n{\\colortbl");
            for (n = 0; n < this.colorTable.size(); ++n) {
                object = (Color)this.colorTable.elementAt(n);
                stringBuffer.append("\\red");
                stringBuffer.append(((Color)object).getRed());
                stringBuffer.append("\\green");
                stringBuffer.append(((Color)object).getGreen());
                stringBuffer.append("\\blue");
                stringBuffer.append(((Color)object).getBlue());
                stringBuffer.append(";");
            }
            stringBuffer.append("}\n{\\f0\\fs");
            stringBuffer.append(fontData.getHeight() * 2);
            stringBuffer.append(" ");
            this.write(stringBuffer.toString(), 0);
        }

        @Override
        public void writeLine(String string, int n) {
            StyleRange[] styleRangeArray;
            int[] nArray;
            boolean bl;
            int n2;
            int n3;
            if (this.isClosed()) {
                SWT.error(39);
            }
            int n4 = StyledText.this.content.getLineAtOffset(n);
            StyledTextEvent styledTextEvent = StyledText.this.getLineStyleData(n, string);
            if (styledTextEvent != null) {
                n3 = styledTextEvent.alignment;
                n2 = styledTextEvent.indent;
                bl = styledTextEvent.justify;
                nArray = styledTextEvent.ranges;
                styleRangeArray = styledTextEvent.styles;
            } else {
                n3 = StyledText.this.renderer.getLineAlignment(n4, StyledText.this.alignment);
                n2 = StyledText.this.renderer.getLineIndent(n4, StyledText.this.indent);
                bl = StyledText.this.renderer.getLineJustify(n4, StyledText.this.justify);
                nArray = StyledText.this.renderer.getRanges(n, string.length());
                styleRangeArray = StyledText.this.renderer.getStyleRanges(n, string.length(), false);
            }
            if (styleRangeArray == null) {
                styleRangeArray = new StyleRange[]{};
            }
            Color color = StyledText.this.renderer.getLineBackground(n4, null);
            styledTextEvent = StyledText.this.getLineBackgroundData(n, string);
            if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                color = styledTextEvent.lineBackground;
            }
            this.writeStyledLine(string, n, nArray, styleRangeArray, color, n2, n3, bl);
        }

        @Override
        public void writeLineDelimiter(String string) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(string, 0, string.length());
            this.write("\\par ");
        }

        void writeStyledLine(String string, int n, int[] nArray, StyleRange[] styleRangeArray, Color color, int n2, int n3, boolean bl) {
            int n4 = string.length();
            int n5 = this.getStart();
            int n6 = n5 - n;
            if (n6 >= n4) {
                return;
            }
            int n7 = Math.max(0, n6);
            this.write("\\fi");
            this.write(n2);
            switch (n3) {
                case 16384: {
                    this.write("\\ql");
                    break;
                }
                case 0x1000000: {
                    this.write("\\qc");
                    break;
                }
                case 131072: {
                    this.write("\\qr");
                }
            }
            if (bl) {
                this.write("\\qj");
            }
            this.write(" ");
            if (color != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(color, 1));
                this.write(" ");
            }
            int n8 = n5 + super.getCharCount();
            int n9 = Math.min(n4, n8 - n);
            for (int i = 0; i < styleRangeArray.length; ++i) {
                int n10;
                Font font;
                int n11;
                int n12;
                StyleRange styleRange = styleRangeArray[i];
                if (nArray != null) {
                    n12 = nArray[i << 1] - n;
                    n11 = n12 + nArray[(i << 1) + 1];
                } else {
                    n12 = styleRange.start - n;
                    n11 = n12 + styleRange.length;
                }
                if (n11 < n6) continue;
                if (n12 >= n9) break;
                if (n7 < n12) {
                    this.write(string, n7, n12);
                    n7 = n12;
                }
                this.write("{\\cf");
                this.write(this.getColorIndex(styleRange.foreground, 0));
                int n13 = this.getColorIndex(styleRange.background, 1);
                if (n13 != 1) {
                    this.write("\\highlight");
                    this.write(n13);
                }
                if ((font = styleRange.font) != null) {
                    n10 = this.getFontIndex(font);
                    this.write("\\f");
                    this.write(n10);
                    FontData fontData = font.getFontData()[0];
                    this.write("\\fs");
                    this.write(fontData.getHeight() * 2);
                } else {
                    if ((styleRange.fontStyle & 1) != 0) {
                        this.write("\\b");
                    }
                    if ((styleRange.fontStyle & 2) != 0) {
                        this.write("\\i");
                    }
                }
                if (styleRange.underline) {
                    this.write("\\ul");
                }
                if (styleRange.strikeout) {
                    this.write("\\strike");
                }
                this.write(" ");
                n10 = Math.min(n11, n9);
                n10 = Math.max(n10, n7);
                this.write(string, n7, n10);
                if (font == null) {
                    if ((styleRange.fontStyle & 1) != 0) {
                        this.write("\\b0");
                    }
                    if ((styleRange.fontStyle & 2) != 0) {
                        this.write("\\i0");
                    }
                }
                if (styleRange.underline) {
                    this.write("\\ul0");
                }
                if (styleRange.strikeout) {
                    this.write("\\strike0");
                }
                this.write("}");
                n7 = n10;
            }
            if (n7 < n9) {
                this.write(string, n7, n9);
            }
            if (color != null) {
                this.write("}");
            }
        }
    }

    static class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        Printer printer;
        StyledTextRenderer printerRenderer;
        StyledTextPrintOptions printOptions;
        Rectangle clientArea;
        FontData fontData;
        Font printerFont;
        Hashtable resources;
        int tabLength;
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int scope;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;
        boolean mirrored;
        int lineSpacing;
        int printMargin;

        Printing(StyledText styledText, Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
            this.printer = printer;
            this.printOptions = styledTextPrintOptions;
            this.mirrored = (styledText.getStyle() & 0x8000000) != 0;
            this.singleLine = styledText.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            PrinterData printerData = printer.getPrinterData();
            this.scope = printerData.scope;
            if (this.scope == 1) {
                this.startPage = printerData.startPage;
                this.endPage = printerData.endPage;
                if (this.endPage < this.startPage) {
                    int n = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = n;
                }
            } else if (this.scope == 2) {
                this.selection = styledText.getSelectionRange();
            }
            this.printerRenderer = new StyledTextRenderer(printer, null);
            this.printerRenderer.setContent(this.copyContent(styledText.getContent()));
            this.cacheLineData(styledText);
        }

        void cacheLineData(StyledText styledText) {
            StyleRange[] styleRangeArray;
            Object object;
            StyledTextRenderer styledTextRenderer = styledText.renderer;
            styledTextRenderer.copyInto(this.printerRenderer);
            this.fontData = styledText.getFont().getFontData()[0];
            this.tabLength = styledText.tabLength;
            int n = this.printerRenderer.lineCount;
            if (styledText.isListening(3001) || styledText.isBidi() && styledText.isListening(3007) || styledText.isListening(3002)) {
                object = this.printerRenderer.content;
                for (int i = 0; i < n; ++i) {
                    String string = object.getLine(i);
                    int n2 = object.getOffsetAtLine(i);
                    StyledTextEvent styledTextEvent = styledText.getLineBackgroundData(n2, string);
                    if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                        this.printerRenderer.setLineBackground(i, 1, styledTextEvent.lineBackground);
                    }
                    if (styledText.isBidi() && (styledTextEvent = styledText.getBidiSegments(n2, string)) != null) {
                        this.printerRenderer.setLineSegments(i, 1, styledTextEvent.segments);
                        this.printerRenderer.setLineSegmentChars(i, 1, styledTextEvent.segmentsChars);
                    }
                    if ((styledTextEvent = styledText.getLineStyleData(n2, string)) == null) continue;
                    this.printerRenderer.setLineIndent(i, 1, styledTextEvent.indent);
                    this.printerRenderer.setLineAlignment(i, 1, styledTextEvent.alignment);
                    this.printerRenderer.setLineJustify(i, 1, styledTextEvent.justify);
                    this.printerRenderer.setLineBullet(i, 1, styledTextEvent.bullet);
                    styleRangeArray = styledTextEvent.styles;
                    if (styleRangeArray == null || styleRangeArray.length <= 0) continue;
                    this.printerRenderer.setStyleRanges(styledTextEvent.ranges, styleRangeArray);
                }
            }
            object = styledText.getDisplay().getDPI();
            Point point = this.printer.getDPI();
            this.resources = new Hashtable();
            for (int i = 0; i < n; ++i) {
                int n3;
                Color color = this.printerRenderer.getLineBackground(i, null);
                if (color != null) {
                    if (this.printOptions.printLineBackground) {
                        Color color2 = (Color)this.resources.get(color);
                        if (color2 == null) {
                            color2 = new Color(this.printer, color.getRGB());
                            this.resources.put(color, color2);
                        }
                        this.printerRenderer.setLineBackground(i, 1, color2);
                    } else {
                        this.printerRenderer.setLineBackground(i, 1, null);
                    }
                }
                if ((n3 = this.printerRenderer.getLineIndent(i, 0)) == 0) continue;
                this.printerRenderer.setLineIndent(i, 1, n3 * point.x / ((Point)object).x);
            }
            StyleRange[] styleRangeArray2 = this.printerRenderer.styles;
            for (int i = 0; i < this.printerRenderer.styleCount; ++i) {
                Object object2;
                Resource resource;
                StyleRange styleRange = styleRangeArray2[i];
                styleRangeArray = styleRange.font;
                if (styleRange.font != null) {
                    resource = (Font)this.resources.get(styleRangeArray);
                    if (resource == null) {
                        resource = new Font((Device)this.printer, styleRangeArray.getFontData());
                        this.resources.put(styleRangeArray, resource);
                    }
                    styleRange.font = resource;
                }
                if ((resource = styleRange.foreground) != null) {
                    object2 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextForeground) {
                        if (object2 == null) {
                            object2 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object2);
                        }
                        styleRange.foreground = object2;
                    } else {
                        styleRange.foreground = null;
                    }
                }
                if ((resource = styleRange.background) != null) {
                    object2 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextBackground) {
                        if (object2 == null) {
                            object2 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object2);
                        }
                        styleRange.background = object2;
                    } else {
                        styleRange.background = null;
                    }
                }
                if (!this.printOptions.printTextFontStyle) {
                    styleRange.fontStyle = 0;
                }
                styleRange.rise = styleRange.rise * point.y / ((Point)object).y;
                object2 = styleRange.metrics;
                if (object2 == null) continue;
                ((GlyphMetrics)object2).ascent = ((GlyphMetrics)object2).ascent * point.y / ((Point)object).y;
                ((GlyphMetrics)object2).descent = ((GlyphMetrics)object2).descent * point.y / ((Point)object).y;
                ((GlyphMetrics)object2).width = ((GlyphMetrics)object2).width * point.x / ((Point)object).x;
            }
            this.lineSpacing = styledText.lineSpacing * point.y / ((Point)object).y;
            if (this.printOptions.printLineNumbers) {
                this.printMargin = 3 * point.x / ((Point)object).x;
            }
        }

        StyledTextContent copyContent(StyledTextContent styledTextContent) {
            DefaultContent defaultContent = new DefaultContent();
            int n = 0;
            for (int i = 0; i < styledTextContent.getLineCount(); ++i) {
                int n2 = i < styledTextContent.getLineCount() - 1 ? styledTextContent.getOffsetAtLine(i + 1) : styledTextContent.getCharCount();
                defaultContent.replaceTextRange(n, 0, styledTextContent.getTextRange(n, n2 - n));
                n = n2;
            }
            return defaultContent;
        }

        void dispose() {
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.resources != null) {
                Enumeration enumeration = this.resources.elements();
                while (enumeration.hasMoreElements()) {
                    Resource resource = (Resource)enumeration.nextElement();
                    resource.dispose();
                }
                this.resources = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.printerRenderer != null) {
                this.printerRenderer.dispose();
                this.printerRenderer = null;
            }
        }

        void init() {
            Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
            Point point = this.printer.getDPI();
            this.printerFont = new Font((Device)this.printer, this.fontData.getName(), this.fontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = point.x + rectangle.x;
            this.clientArea.y = point.y + rectangle.y;
            this.clientArea.width -= this.clientArea.x + rectangle.width;
            this.clientArea.height -= this.clientArea.y + rectangle.height;
            int n = this.mirrored ? 0x4000000 : 0x2000000;
            this.gc = new GC(this.printer, n);
            this.gc.setFont(this.printerFont);
            this.printerRenderer.setFont(this.printerFont, this.tabLength);
            int n2 = this.printerRenderer.getLineHeight();
            if (this.printOptions.header != null) {
                this.clientArea.y += n2 * 2;
                this.clientArea.height -= n2 * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= n2 * 2;
            }
            StyledTextContent styledTextContent = this.printerRenderer.content;
            this.startLine = 0;
            int n3 = this.endLine = this.singleLine ? 0 : styledTextContent.getLineCount() - 1;
            if (this.scope == 1) {
                int n4 = this.clientArea.height / n2;
                this.startLine = (this.startPage - 1) * n4;
            } else if (this.scope == 2) {
                this.startLine = styledTextContent.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? styledTextContent.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        void print() {
            int n;
            int n2;
            Object object;
            int n3;
            Color color = this.gc.getBackground();
            Color color2 = this.gc.getForeground();
            int n4 = this.clientArea.y;
            int n5 = this.clientArea.x;
            int n6 = this.clientArea.width;
            int n7 = this.startPage;
            int n8 = this.clientArea.y + this.clientArea.height;
            int n9 = this.gc.getStyle() & 0x6000000;
            TextLayout textLayout = null;
            if (this.printOptions.printLineNumbers || this.printOptions.header != null || this.printOptions.footer != null) {
                textLayout = new TextLayout(this.printer);
                textLayout.setFont(this.printerFont);
            }
            if (this.printOptions.printLineNumbers) {
                n3 = 0;
                int n10 = this.endLine - this.startLine + 1;
                object = this.printOptions.lineLabels;
                if (object != null) {
                    for (n2 = this.startLine; n2 < Math.min(n10, ((String[])object).length); ++n2) {
                        if (object[n2] == null) continue;
                        textLayout.setText(object[n2]);
                        n = textLayout.getBounds().width;
                        n3 = Math.max(n3, n);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer("0");
                    while ((n10 /= 10) > 0) {
                        stringBuffer.append("0");
                    }
                    textLayout.setText(stringBuffer.toString());
                    n3 = textLayout.getBounds().width;
                }
                if ((n3 += this.printMargin) > n6) {
                    n3 = n6;
                }
                n5 += n3;
                n6 -= n3;
            }
            for (n3 = this.startLine; n3 <= this.endLine && n7 <= this.endPage; ++n3) {
                if (n4 == this.clientArea.y) {
                    this.printer.startPage();
                    this.printDecoration(n7, true, textLayout);
                }
                TextLayout textLayout2 = this.printerRenderer.getTextLayout(n3, n9, n6, this.lineSpacing);
                object = this.printerRenderer.getLineBackground(n3, color);
                n2 = n4 + textLayout2.getBounds().height;
                if (n2 <= n8) {
                    this.printLine(n5, n4, this.gc, color2, (Color)object, textLayout2, textLayout, n3);
                    n4 = n2;
                } else {
                    n = textLayout2.getLineCount();
                    while (n2 > n8 && n > 0) {
                        n2 -= textLayout2.getLineBounds((int)(--n)).height + textLayout2.getSpacing();
                    }
                    if (n == 0) {
                        this.printDecoration(n7, false, textLayout);
                        this.printer.endPage();
                        if (++n7 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n7, true, textLayout);
                            n4 = this.clientArea.y;
                            this.printLine(n5, n4, this.gc, color2, (Color)object, textLayout2, textLayout, n3);
                            n4 += textLayout2.getBounds().height;
                        }
                    } else {
                        int n11 = n2 - n4;
                        this.gc.setClipping(this.clientArea.x, n4, this.clientArea.width, n11);
                        this.printLine(n5, n4, this.gc, color2, (Color)object, textLayout2, textLayout, n3);
                        this.gc.setClipping((Rectangle)null);
                        this.printDecoration(n7, false, textLayout);
                        this.printer.endPage();
                        if (++n7 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n7, true, textLayout);
                            n4 = this.clientArea.y - n11;
                            int n12 = textLayout2.getBounds().height;
                            this.gc.setClipping(this.clientArea.x, this.clientArea.y, this.clientArea.width, n12 - n11);
                            this.printLine(n5, n4, this.gc, color2, (Color)object, textLayout2, textLayout, n3);
                            this.gc.setClipping((Rectangle)null);
                            n4 += n12;
                        }
                    }
                }
                this.printerRenderer.disposeTextLayout(textLayout2);
            }
            if (n7 <= this.endPage && n4 > this.clientArea.y) {
                this.printDecoration(n7, false, textLayout);
                this.printer.endPage();
            }
            if (textLayout != null) {
                textLayout.dispose();
            }
        }

        void printDecoration(int n, boolean bl, TextLayout textLayout) {
            String string;
            String string2 = string = bl ? this.printOptions.header : this.printOptions.footer;
            if (string == null) {
                return;
            }
            int n2 = 0;
            for (int i = 0; i < 3; ++i) {
                String string3;
                int n3 = string.indexOf("\t", n2);
                if (n3 == -1) {
                    string3 = string.substring(n2);
                    this.printDecorationSegment(string3, i, n, bl, textLayout);
                    break;
                }
                string3 = string.substring(n2, n3);
                this.printDecorationSegment(string3, i, n, bl, textLayout);
                n2 = n3 + "\t".length();
            }
        }

        void printDecorationSegment(String string, int n, int n2, boolean bl, TextLayout textLayout) {
            int n3;
            int n4 = string.indexOf("<page>");
            if (n4 != -1) {
                n3 = "<page>".length();
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n4));
                stringBuffer.append(n2);
                stringBuffer.append(string.substring(n4 + n3));
                string = stringBuffer.toString();
            }
            if (string.length() > 0) {
                textLayout.setText(string);
                n3 = textLayout.getBounds().width;
                int n5 = this.printerRenderer.getLineHeight();
                int n6 = 0;
                if (n == 0) {
                    n6 = this.clientArea.x;
                } else if (n == 1) {
                    n6 = (this.pageWidth - n3) / 2;
                } else if (n == 2) {
                    n6 = this.clientArea.x + this.clientArea.width - n3;
                }
                int n7 = bl ? this.clientArea.y - n5 * 2 : this.clientArea.y + this.clientArea.height + n5;
                textLayout.draw(this.gc, n6, n7);
            }
        }

        void printLine(int n, int n2, GC gC, Color color, Color color2, TextLayout textLayout, TextLayout textLayout2, int n3) {
            Object object;
            if (color2 != null) {
                object = textLayout.getBounds();
                gC.setBackground(color2);
                gC.fillRectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (this.printOptions.printLineNumbers) {
                object = textLayout.getLineMetrics(0);
                textLayout2.setAscent(((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading());
                textLayout2.setDescent(((FontMetrics)object).getDescent());
                String[] stringArray = this.printOptions.lineLabels;
                if (stringArray != null) {
                    if (0 <= n3 && n3 < stringArray.length && stringArray[n3] != null) {
                        textLayout2.setText(stringArray[n3]);
                    } else {
                        textLayout2.setText("");
                    }
                } else {
                    textLayout2.setText(String.valueOf(n3));
                }
                int n4 = n - this.printMargin - textLayout2.getBounds().width;
                textLayout2.draw(gC, n4, n2);
                textLayout2.setAscent(-1);
                textLayout2.setDescent(-1);
            }
            gC.setForeground(color);
            textLayout.draw(gC, n, n2);
        }

        @Override
        public void run() {
            String string = this.printOptions.jobName;
            if (string == null) {
                string = "Printing";
            }
            if (this.printer.startJob(string)) {
                this.init();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }
    }
}

