/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <PeerHood.h>
#include <BasicCallback.h>
#include <netinet/in.h>
using namespace std;


static volatile bool run = true;
static MAbstractConnection* connection = NULL;

class ServerCallback : public CBasicCallback
{
 public:
  // from the CBasicCallback
  void Notify(TEventType aEvent, const string& aAddress) {
    cout << "Got an event!" << endl;
  };

  void NewConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId) {
    connection = aConnection; 
    std::cout << "ServerCallback::NewConnection : Got connection Id " << aConnectionId << " port " << aPort << std::endl;
    std::cout << "Remote address: " << connection->GetRemoteAddress();
  };

};


void SignalHandler(int aSignal)
{
  cerr << "Ouch! Hit by a fatal signal!" << endl;
  run = false;
}

// Test server having only few services

int main(int argc, char** argv)
{
  MPeerHood* peerHood;
  ServerCallback* callback;
  fd_set set;
  struct timeval timeVal;
  int length;
  char* buffer;

  callback = new ServerCallback;
  peerHood = MPeerHood::GetInstance(callback);

  if (!peerHood->Init(argc, argv)) {
    cerr << "PeerHood initialization failed!" << endl;
    exit(EXIT_FAILURE);
  }

  if ((peerHood->RegisterService(string("numbers"), string("Number crunching"))) == 0) {
    cerr << "Registering the numbers service failed, aborting..." << endl;
    return EXIT_FAILURE;
  }

//   if ((peerHood->RegisterService(string("alphabet"), string("Alphabet crunching"),string("44444"))) == 0) {
//     cerr << "Registering the numbers service failed, aborting..." << endl;
//     return EXIT_FAILURE;
//   }

  signal(SIGTERM, SignalHandler);
  signal(SIGINT, SignalHandler);

  while (run) {
    if (!connection) {
      sleep(1);
    }
    else {

      if (connection->HasData()) {
	int actualRead = 0;
	actualRead = connection->Read(&length, sizeof(length));	
	if(actualRead != sizeof(length))
	  {
	    delete connection;
	    connection = NULL;
	    std::cout << "Receiving length failed, received " << actualRead  << std::endl;
	  }
	else {
	  length = ntohl(length);
	  buffer = new char[length + 1];
	  bzero(buffer, length + 1);
	  if(connection->Read(buffer, length) != length)
	    {
	      delete[] buffer;
	      delete connection;
	      connection = NULL;
	      std::cout << "Receiving message failed" << std::endl;
	      break;
	    }
	  cout << "[message] " << buffer << endl;
	  cout << connection->GetRemoteAddress() << endl;
	  delete[] buffer;
	}
      } else {
	cout << "No data available" << endl;
	
      }
      
	
    }
      
  }

  if (connection) {
    connection->Disconnect();
  }

  peerHood->UnregisterService(string("numbers"));
  //  peerHood->UnregisterService(string("alphabet"), string("44444"));

  return 0;
}
