/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003-2010 LUT. .
 *
 * @name PluginStorage.h
 * @memo Definition of plugin storage class.
 *
 * @version 0.1
 * date     23.02.2010
 * change   28.04.2010
 */


#ifndef __PLUGIN_STORAGE_H__
#define __PLUGIN_STORAGE_H__

#include <map>
#include <pthread.h>

#include "AbstractPlugin.h"

class PluginStorage {

public:

	virtual ~PluginStorage();
	
	static PluginStorage* GetInstance();
	
	void AddPlugin(const char* aName, MAbstractPlugin* aPlugin);
	
	std::map<const char*, MAbstractPlugin*>::iterator Begin();
	
	std::map<const char*, MAbstractPlugin*>::iterator End();
	
	void Stop();
	
private:
	
	PluginStorage();
	
	inline void Lock();
	
	inline void UnLock();
	
	std::map<const char*, MAbstractPlugin*> iPlugins;
	
	static PluginStorage* iInstance;
	
	pthread_mutex_t iPluginStorageLock;
};

#endif

