/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name Engine.h
 * @memo Defines the core class of the whole PeerHood system.
 *
 * @version 0.1
 * date     01.04.2003
 * change   01.04.2003
 */

#ifndef __ENGINE_H__
#define __ENGINE_H__

#include <list>
#include <pthread.h>

#include "PHObject.h"
#include "VirtualConnection.h"

class CEngine;
class CConnInfo;

/**
 * @memo The core class of the whole PeerHood system.
 * @doc The core class of the whole PeerHood system. This singleton class is
 * responsible for receiving incoming method requests handling and dispatching.
 * If a service is registered then a dedicated thread listens for incoming
 * requests. If a request is received it is forwarded to a correct dispatcher.
 * Requests are handled using the fifo (first in first out) methology. If all
 * services are unregistered then the thread is also terminated.
 */
class CEngine
{
 public:
  ~CEngine();
  static CEngine* GetInstance(CBasicCallback* aCallback);
  bool LoadConnections(const int aLocalPid);
  void StartListening();

 protected:
  CEngine(CBasicCallback* aCallback);
  CEngine(const CEngine&);
  const CEngine& operator= (const CEngine&);

 private:
  static void* ThreadStarter(void *aArguments);
  void EternalThread();
  volatile bool iStop;
  static CEngine* iInstance;
  CBasicCallback* iCallback;
  pthread_t iThread;
  pthread_mutex_t iLock;
  std::list<MAbstractConnection *> iConnectionList;

  CVirtualConnection *iVirtualConnection;
  std::list<CConnInfo*> iVirtualConnectionList;
};

class CConnInfo
{
 public:
  MAbstractConnection* iVirtualConnection;
  int iId;
};

#endif // __ENGINE_H__

